/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.javadoc.Doc;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.refactoring.java.RefactoringModule;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.ui.ChangeParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class IntroduceParameterPanel
extends JPanel
implements CustomRefactoringPanel {
    private static final String OVERLOADMETHOD = "overloadmethod.introduceParameter";
    private static final String REPLACEALL = "replaceall.introduceParameter";
    private static final String DECLAREFINAL = "declarefinal.introduceParameter";
    private static final String UPDATEJAVADOC = "updateJavadoc.introduceParameters";
    private static final String GENJAVADOC = "generateJavadoc.introduceParameters";
    private static final String MIME_JAVA = "text/x-java";
    private static final String DEFAULT_NAME = "par";
    TreePathHandle refactoredObj;
    private ChangeListener parent;
    private final JComponent[] singleLineEditor;
    private final DocumentListener nameChangedListener;
    private int startOffset;
    private boolean initialized = false;
    private ButtonGroup bgOverloadMethod;
    private JCheckBox chkGenJavadoc;
    private JCheckBox chkIsDeclareFinal;
    private JCheckBox chkIsReplaceAll;
    private JCheckBox chkUpdateJavadoc;
    private JScrollPane jScrollPane1;
    private JLabel lblCodeGeneration;
    private JLabel lblName;
    private JRadioButton rbOverloadMethod;
    private JRadioButton rbUpdateMethod;

    public Component getComponent() {
        return this;
    }

    public IntroduceParameterPanel(TreePathHandle refactoredObj, ChangeListener parent) {
        this.refactoredObj = refactoredObj;
        this.parent = parent;
        this.singleLineEditor = Utilities.createSingleLineEditor((String)MIME_JAVA);
        this.initComponents();
        this.nameChangedListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent de) {
                IntroduceParameterPanel.this.postUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                IntroduceParameterPanel.this.postUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                IntroduceParameterPanel.this.postUpdate();
            }
        };
        ((JEditorPane)this.singleLineEditor[1]).getDocument().addDocumentListener(this.nameChangedListener);
    }

    private void postUpdate() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                IntroduceParameterPanel.this.parent.stateChanged(null);
            }
        });
    }

    public void initialize() {
        try {
            if (this.initialized) {
                return;
            }
            JavaSource source = JavaSource.forFileObject((FileObject)this.refactoredObj.getFileObject());
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController info) {
                    try {
                        Document doc;
                        info.toPhase(JavaSource.Phase.RESOLVED);
                        final FileObject fileObject = IntroduceParameterPanel.this.refactoredObj.getFileObject();
                        DataObject dob = DataObject.find((FileObject)fileObject);
                        ((JEditorPane)IntroduceParameterPanel.this.singleLineEditor[1]).getDocument().putProperty("stream", dob);
                        TreePath path = IntroduceParameterPanel.this.refactoredObj.resolve((CompilationInfo)info);
                        TreePath methodPath = JavaPluginUtils.findMethod(path);
                        MethodTree methodTree = (MethodTree)methodPath.getLeaf();
                        final int[] parameterSpan = info.getTreeUtilities().findMethodParameterSpan(methodTree);
                        TypeMirror typeMirror = info.getTrees().getTypeMirror(path);
                        final String tm = typeMirror == null ? "Object" : typeMirror.toString();
                        Element methodElement = info.getTrees().getElement(methodPath);
                        Doc javadocDoc = info.getElementUtilities().javaDocFor(methodElement);
                        if (javadocDoc != null && javadocDoc.commentText() == null || javadocDoc.getRawCommentText().equals("")) {
                            IntroduceParameterPanel.this.chkGenJavadoc.setEnabled(true);
                            IntroduceParameterPanel.this.chkGenJavadoc.setVisible(true);
                            IntroduceParameterPanel.this.chkUpdateJavadoc.setVisible(false);
                        } else {
                            IntroduceParameterPanel.this.chkUpdateJavadoc.setEnabled(true);
                            IntroduceParameterPanel.this.chkUpdateJavadoc.setVisible(true);
                            IntroduceParameterPanel.this.chkGenJavadoc.setVisible(false);
                        }
                        String name = JavaPluginUtils.getName(path.getLeaf());
                        if (name == null) {
                            name = IntroduceParameterPanel.DEFAULT_NAME;
                        }
                        Scope scope = null;
                        if (methodTree.getBody() != null) {
                            TreePath bodyPath = new TreePath(methodPath, methodTree.getBody());
                            scope = info.getTrees().getScope(bodyPath);
                        }
                        CodeStyle cs = (doc = info.getDocument()) != null ? CodeStyle.getDefault((Document)doc) : CodeStyle.getDefault((FileObject)info.getFileObject());
                        final String parameterName = JavaPluginUtils.makeNameUnique((CompilationInfo)info, scope, name, cs.getParameterNamePrefix(), cs.getParameterNameSuffix());
                        final boolean variableRewrite = path.getLeaf().getKind() == Tree.Kind.VARIABLE;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JEditorPane editorPane = (JEditorPane)IntroduceParameterPanel.this.singleLineEditor[1];
                                DialogBinding.bindComponentToFile((FileObject)fileObject, (int)(parameterSpan[0] + 1), (int)(parameterSpan[1] - parameterSpan[0]), (JTextComponent)editorPane);
                                editorPane.setText(tm + " " + parameterName);
                                IntroduceParameterPanel.this.startOffset = tm.length() + 1;
                                int endOffset = parameterName.length() + IntroduceParameterPanel.this.startOffset;
                                editorPane.select(IntroduceParameterPanel.this.startOffset, endOffset);
                                try {
                                    Position startPos = editorPane.getDocument().createPosition(IntroduceParameterPanel.this.startOffset);
                                    Position endPos = editorPane.getDocument().createPosition(endOffset);
                                    editorPane.putClientProperty("document-view-start-position", startPos);
                                    editorPane.putClientProperty("document-view-end-position", endPos);
                                }
                                catch (BadLocationException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                                ((JEditorPane)IntroduceParameterPanel.this.singleLineEditor[1]).getDocument().addDocumentListener(IntroduceParameterPanel.this.nameChangedListener);
                                if (variableRewrite) {
                                    IntroduceParameterPanel.this.chkIsReplaceAll.setEnabled(false);
                                    IntroduceParameterPanel.this.chkIsReplaceAll.setSelected(false);
                                }
                                IntroduceParameterPanel.this.initialized = true;
                            }
                        });
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }

                public void cancel() {
                }
            }, true);
            this.initialized = true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initComponents() {
        this.bgOverloadMethod = new ButtonGroup();
        this.lblName = new JLabel();
        this.chkIsDeclareFinal = new JCheckBox();
        this.chkIsReplaceAll = new JCheckBox();
        this.jScrollPane1 = (JScrollPane)this.singleLineEditor[0];
        this.chkGenJavadoc = new JCheckBox();
        this.chkUpdateJavadoc = new JCheckBox();
        this.rbUpdateMethod = new JRadioButton();
        this.rbOverloadMethod = new JRadioButton();
        this.lblCodeGeneration = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setAutoscrolls(true);
        this.setName(IntroduceParameterPanel.getString("LBL_TitleIntroduceParameter"));
        this.lblName.setLabelFor(this.jScrollPane1);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(IntroduceParameterPanel.class, (String)"IntroduceParameterPanel.lblName.text"));
        this.chkIsDeclareFinal.setSelected(RefactoringModule.getOption(DECLAREFINAL, Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.chkIsDeclareFinal, (String)NbBundle.getMessage(IntroduceParameterPanel.class, (String)"IntroduceParameterPanel.chkIsDeclareFinal.text"));
        this.chkIsDeclareFinal.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceParameterPanel.this.chkIsDeclareFinalItemStateChanged(evt);
            }
        });
        this.chkIsReplaceAll.setSelected(RefactoringModule.getOption(REPLACEALL, Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.chkIsReplaceAll, (String)NbBundle.getMessage(IntroduceParameterPanel.class, (String)"IntroduceParameterPanel.chkIsReplaceAll.text"));
        this.chkIsReplaceAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceParameterPanel.this.chkIsReplaceAllItemStateChanged(evt);
            }
        });
        this.chkGenJavadoc.setSelected(RefactoringModule.getOption(GENJAVADOC, Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.chkGenJavadoc, (String)NbBundle.getMessage(IntroduceParameterPanel.class, (String)"IntroduceParameterPanel.chkGenJavadoc.text"));
        this.chkGenJavadoc.setEnabled(false);
        this.chkGenJavadoc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceParameterPanel.this.chkGenJavadocItemStateChanged(evt);
            }
        });
        this.chkUpdateJavadoc.setSelected(RefactoringModule.getOption(UPDATEJAVADOC, Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.chkUpdateJavadoc, (String)NbBundle.getMessage(IntroduceParameterPanel.class, (String)"IntroduceParameterPanel.chkUpdateJavadoc.text"));
        this.chkUpdateJavadoc.setEnabled(false);
        this.chkUpdateJavadoc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceParameterPanel.this.chkUpdateJavadocItemStateChanged(evt);
            }
        });
        this.bgOverloadMethod.add(this.rbUpdateMethod);
        this.rbUpdateMethod.setSelected(Boolean.valueOf(RefactoringModule.getOption(OVERLOADMETHOD, Boolean.FALSE)) == false);
        Mnemonics.setLocalizedText((AbstractButton)this.rbUpdateMethod, (String)NbBundle.getMessage(IntroduceParameterPanel.class, (String)"IntroduceParameterPanel.rbUpdateMethod.text"));
        this.bgOverloadMethod.add(this.rbOverloadMethod);
        this.rbOverloadMethod.setSelected(RefactoringModule.getOption(OVERLOADMETHOD, Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.rbOverloadMethod, (String)NbBundle.getMessage(IntroduceParameterPanel.class, (String)"IntroduceParameterPanel.rbOverloadMethod.text"));
        this.rbOverloadMethod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IntroduceParameterPanel.this.rbOverloadMethodItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblCodeGeneration, (String)NbBundle.getMessage(IntroduceParameterPanel.class, (String)"IntroduceParameterPanel.lblCodeGeneration.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblName).addGap(2, 2, 2).addComponent(this.jScrollPane1, -1, 428, Short.MAX_VALUE)).addComponent(this.chkIsDeclareFinal).addComponent(this.chkIsReplaceAll).addComponent(this.chkUpdateJavadoc).addComponent(this.chkGenJavadoc).addComponent(this.lblCodeGeneration).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.rbUpdateMethod)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.rbOverloadMethod)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblName, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1)).addGap(18, 18, 18).addComponent(this.chkIsDeclareFinal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkIsReplaceAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkUpdateJavadoc).addComponent(this.chkGenJavadoc)).addGap(18, 18, 18).addComponent(this.lblCodeGeneration).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbUpdateMethod).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbOverloadMethod).addContainerGap(24, Short.MAX_VALUE)));
    }

    private void chkIsReplaceAllItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption(REPLACEALL, b);
        this.parent.stateChanged(null);
    }

    private void chkIsDeclareFinalItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption(DECLAREFINAL, b);
        this.parent.stateChanged(null);
    }

    private void chkGenJavadocItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption(GENJAVADOC, b);
        this.parent.stateChanged(null);
    }

    private void chkUpdateJavadocItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption(UPDATEJAVADOC, b);
        this.parent.stateChanged(null);
    }

    private void rbOverloadMethodItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption(OVERLOADMETHOD, b);
        this.parent.stateChanged(null);
    }

    private static String getString(String key) {
        return NbBundle.getMessage(ChangeParametersPanel.class, (String)key);
    }

    public boolean isCompatible() {
        return this.rbOverloadMethod.isSelected();
    }

    public boolean isDeclareFinal() {
        return this.chkIsDeclareFinal.isSelected();
    }

    public boolean isReplaceAll() {
        return this.chkIsReplaceAll.isSelected();
    }

    public String getParameterName() {
        String text = ((JEditorPane)this.singleLineEditor[1]).getText();
        String substring = text.length() < this.startOffset ? text : text.substring(this.startOffset);
        return substring;
    }

    protected ChangeParametersPanel.Javadoc getJavadoc() {
        if (this.chkUpdateJavadoc.isVisible() && this.chkUpdateJavadoc.isSelected()) {
            return ChangeParametersPanel.Javadoc.UPDATE;
        }
        if (this.chkGenJavadoc.isVisible() && this.chkGenJavadoc.isSelected()) {
            return ChangeParametersPanel.Javadoc.GENERATE;
        }
        return ChangeParametersPanel.Javadoc.NONE;
    }

    @Override
    public boolean requestFocusInWindow() {
        ((JEditorPane)this.singleLineEditor[1]).requestFocusInWindow();
        return true;
    }
}

