/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.MessageLayout;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layout
extends PolicyAssertion
implements SecurityAssertionValidator {
    MessageLayout ml;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private boolean populated = false;
    private SecurityPolicyVersion spVersion;

    public Layout() {
        this.spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    }

    public Layout(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
    }

    public MessageLayout getMessageLayout() {
        this.populate();
        return this.ml;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy = this.getNestedPolicy();
            AssertionSet assertionSet = policy.getAssertionSet();
            for (PolicyAssertion assertion : assertionSet) {
                if (PolicyUtil.isLax(assertion, this.spVersion)) {
                    this.ml = MessageLayout.Lax;
                    continue;
                }
                if (PolicyUtil.isLaxTsFirst(assertion, this.spVersion)) {
                    this.ml = MessageLayout.LaxTsFirst;
                    continue;
                }
                if (PolicyUtil.isLaxTsLast(assertion, this.spVersion)) {
                    this.ml = MessageLayout.LaxTsLast;
                    continue;
                }
                if (PolicyUtil.isStrict(assertion, this.spVersion)) {
                    this.ml = MessageLayout.Strict;
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "Layout");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            this.populated = true;
        }
        return this.fitness;
    }
}

