/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProjectImporterWizard;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

final class SelectionPanel
extends JPanel {
    private String errorMessage;
    private ButtonGroup buttonGroup;
    private JLabel jLabel1;
    private JLabel note;
    private JButton projectBrowse;
    private JRadioButton projectButton;
    private JButton projectDestBrowse;
    private JTextField projectDestDir;
    private JLabel projectDestLBL;
    private JTextField projectDir;
    private JLabel projectLBL;
    private JLabel workSpaceLBL;
    private JRadioButton workspaceButton;
    private JTextField workspaceDir;
    private JButton worskpaceBrowse;

    public SelectionPanel() {
        this.initComponents();
        this.workspaceDir.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SelectionPanel.this.workspaceChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SelectionPanel.this.workspaceChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.projectDir.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SelectionPanel.this.projectChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SelectionPanel.this.projectChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.projectDestDir.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SelectionPanel.this.projectChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SelectionPanel.this.projectChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.setWorkspaceEnabled(this.workspaceButton.isSelected());
    }

    File getWorkspaceDir() {
        String d = this.workspaceDir.getText();
        if (d != null && d.trim().length() > 0) {
            return FileUtil.normalizeFile((File)new File(d.trim()));
        }
        return null;
    }

    private void workspaceChanged() {
        File workspace = this.getWorkspaceDir();
        if (workspace == null) {
            this.setErrorMessage(ProjectImporterWizard.getMessage("MSG_ChooseWorkspace"));
            return;
        }
        boolean wsValid = EclipseUtils.isRegularWorkSpace(workspace);
        this.setErrorMessage(wsValid ? null : (EclipseUtils.isRegularProject(workspace) ? ProjectImporterWizard.getMessage("MSG_NotRegularWorkspaceButProject", workspace) : ProjectImporterWizard.getMessage("MSG_NotRegularWorkspace", workspace)));
    }

    private void projectChanged() {
        String project = this.getProjectDir();
        if ("".equals(project)) {
            this.setErrorMessage(ProjectImporterWizard.getMessage("MSG_ChooseProject"));
            return;
        }
        File projectDirFile = new File(project);
        if (!EclipseUtils.isRegularProject(projectDirFile)) {
            this.setErrorMessage(ProjectImporterWizard.getMessage("MSG_NotRegularProject", project));
            return;
        }
        String projectDest = this.projectDestDir.getText().trim();
        if ("".equals(projectDest)) {
            this.setErrorMessage(ProjectImporterWizard.getMessage("MSG_ChooseProjectDestination"));
            return;
        }
        File projectDestFile = new File(projectDest, projectDirFile.getName());
        if (!projectDestFile.equals(projectDirFile) && projectDestFile.exists()) {
            this.setErrorMessage(ProjectImporterWizard.getMessage("MSG_ProjectExist", projectDestFile.getName()));
            return;
        }
        this.setErrorMessage(null);
    }

    void setErrorMessage(String newMessage) {
        String oldMessage = this.errorMessage;
        this.errorMessage = newMessage;
        this.firePropertyChange("errorMessage", oldMessage, newMessage);
    }

    boolean isWorkspaceChosen() {
        return this.workspaceButton.isSelected();
    }

    public String getProjectDir() {
        return this.projectDir.getText().trim();
    }

    public String getProjectDestinationDir() {
        if (this.projectDestDir.getText().trim().equals(this.projectDir.getText().trim())) {
            return null;
        }
        return this.projectDestDir.getText().trim();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.workspaceDir = new JTextField();
        this.worskpaceBrowse = new JButton();
        this.workSpaceLBL = new JLabel();
        this.projectDir = new JTextField();
        this.projectBrowse = new JButton();
        this.projectLBL = new JLabel();
        this.projectButton = new JRadioButton();
        this.workspaceButton = new JRadioButton();
        this.projectDestLBL = new JLabel();
        this.projectDestDir = new JTextField();
        this.projectDestBrowse = new JButton();
        this.jLabel1 = new JLabel();
        this.note = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.worskpaceBrowse, (String)NbBundle.getMessage(SelectionPanel.class, (String)"CTL_BrowseButton_B"));
        this.worskpaceBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionPanel.this.worskpaceBrowseActionPerformed(evt);
            }
        });
        this.workSpaceLBL.setLabelFor(this.workspaceDir);
        Mnemonics.setLocalizedText((JLabel)this.workSpaceLBL, (String)NbBundle.getMessage(SelectionPanel.class, (String)"LBL_Workspace"));
        Mnemonics.setLocalizedText((AbstractButton)this.projectBrowse, (String)NbBundle.getMessage(SelectionPanel.class, (String)"CTL_BrowseButton_R"));
        this.projectBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionPanel.this.projectBrowseActionPerformed(evt);
            }
        });
        this.projectLBL.setLabelFor(this.projectDir);
        Mnemonics.setLocalizedText((JLabel)this.projectLBL, (String)NbBundle.getMessage(SelectionPanel.class, (String)"LBL_Project"));
        this.buttonGroup.add(this.projectButton);
        Mnemonics.setLocalizedText((AbstractButton)this.projectButton, (String)NbBundle.getMessage(SelectionPanel.class, (String)"CTL_ProjectButton"));
        this.projectButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionPanel.this.projectButtonActionPerformed(evt);
            }
        });
        this.buttonGroup.add(this.workspaceButton);
        this.workspaceButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.workspaceButton, (String)NbBundle.getMessage(SelectionPanel.class, (String)"CTL_WorkspaceButton"));
        this.workspaceButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.workspaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionPanel.this.workspaceButtonActionPerformed(evt);
            }
        });
        this.projectDestLBL.setLabelFor(this.projectDestDir);
        Mnemonics.setLocalizedText((JLabel)this.projectDestLBL, (String)NbBundle.getMessage(SelectionPanel.class, (String)"LBL_ProjectDestination"));
        Mnemonics.setLocalizedText((AbstractButton)this.projectDestBrowse, (String)NbBundle.getMessage(SelectionPanel.class, (String)"CTL_BrowseButton_S"));
        this.projectDestBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionPanel.this.projectDestBrowseActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SelectionPanel.class, (String)"LBL_SpecifyWorkspaceDescription"));
        Mnemonics.setLocalizedText((JLabel)this.note, (String)NbBundle.getMessage(SelectionPanel.class, (String)"LBL_NoteAboutWorkspaceAdvantage"));
        this.note.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.note, -1, 562, Short.MAX_VALUE).addComponent(this.jLabel1, -1, 562, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.workSpaceLBL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.workspaceDir, -1, 281, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.worskpaceBrowse)).addComponent(this.workspaceButton).addComponent(this.projectButton).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectDestLBL).addComponent(this.projectLBL)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.projectDir, -1, 293, Short.MAX_VALUE).addComponent(this.projectDestDir, -1, 293, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectBrowse, GroupLayout.Alignment.TRAILING).addComponent(this.projectDestBrowse, GroupLayout.Alignment.TRAILING))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.workspaceButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.workSpaceLBL, -2, 29, -2).addComponent(this.worskpaceBrowse).addComponent(this.workspaceDir, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLBL, -2, 29, -2).addComponent(this.projectBrowse).addComponent(this.projectDir, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectDestLBL, -2, 29, -2).addComponent(this.projectDestBrowse).addComponent(this.projectDestDir, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.note, -2, 130, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.workspaceDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.worskpaceBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.workSpaceLBL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.projectDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.projectBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.projectLBL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.projectButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.workspaceButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.projectDestLBL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.projectDestDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.projectDestBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.note.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectionPanel.class, (String)"ACSD_SelectionPanel_NA"));
    }

    private void projectDestBrowseActionPerformed(ActionEvent evt) {
        File dir = new FileChooserBuilder(SelectionPanel.class).setDirectoriesOnly(true).showOpenDialog();
        if (dir != null) {
            this.projectDestDir.setText(dir.getAbsolutePath());
        }
    }

    private void projectButtonActionPerformed(ActionEvent evt) {
        this.setWorkspaceEnabled(false);
        this.projectChanged();
        this.projectDir.requestFocusInWindow();
        this.firePropertyChange("workspaceChoosen", true, false);
    }

    private void workspaceButtonActionPerformed(ActionEvent evt) {
        this.setWorkspaceEnabled(true);
        this.workspaceChanged();
        this.firePropertyChange("workspaceChoosen", false, true);
    }

    private void setWorkspaceEnabled(boolean enabled) {
        this.workSpaceLBL.setEnabled(enabled);
        this.worskpaceBrowse.setEnabled(enabled);
        this.workspaceDir.setEnabled(enabled);
        this.projectLBL.setEnabled(!enabled);
        this.projectBrowse.setEnabled(!enabled);
        this.projectDir.setEnabled(!enabled);
        this.projectDestBrowse.setEnabled(!enabled);
        this.projectDestDir.setEnabled(!enabled);
        this.projectDestLBL.setEnabled(!enabled);
        this.note.setVisible(!enabled);
    }

    private void projectBrowseActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(SelectionPanel.class).setDirectoriesOnly(true).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.projectDir.setText(file.getAbsolutePath());
        }
    }

    private void worskpaceBrowseActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(SelectionPanel.class + "_wksp").setDirectoriesOnly(true).showOpenDialog();
        if (file != null) {
            this.workspaceDir.setText(file.getAbsolutePath());
        }
    }
}

