/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.DocumentationTool;
import javax.tools.JavaCompiler;

public class ToolProvider {
    private static final String propertyName = "sun.tools.ToolProvider";
    private static final String loggerName = "javax.tools";
    private static final String systemJavaCompilerName = "com.sun.tools.javac.api.JavacTool";
    private static final String systemDocumentationToolName = "com.sun.tools.javadoc.api.JavadocTool";
    private static ToolProvider instance;
    private final Map<String, Reference<Class<?>>> toolClasses = new HashMap();

    static <T> T trace(Level level, Object reason) {
        try {
            if (System.getProperty(propertyName) != null) {
                StackTraceElement[] st = Thread.currentThread().getStackTrace();
                String method = "???";
                String cls = ToolProvider.class.getName();
                if (st.length > 2) {
                    StackTraceElement frame = st[2];
                    method = String.format((Locale)null, "%s(%s:%s)", frame.getMethodName(), frame.getFileName(), frame.getLineNumber());
                    cls = frame.getClassName();
                }
                Logger logger = Logger.getLogger(loggerName);
                if (reason instanceof Throwable) {
                    logger.logp(level, cls, method, reason.getClass().getName(), (Throwable)reason);
                } else {
                    logger.logp(level, cls, method, String.valueOf(reason));
                }
            }
        }
        catch (SecurityException ex) {
            System.err.format((Locale)null, "%s: %s; %s%n", ToolProvider.class.getName(), reason, ex.getLocalizedMessage());
        }
        return null;
    }

    public static JavaCompiler getSystemJavaCompiler() {
        return ToolProvider.instance().getSystemTool(JavaCompiler.class, systemJavaCompilerName);
    }

    public static DocumentationTool getSystemDocumentationTool() {
        return ToolProvider.instance().getSystemTool(DocumentationTool.class, systemDocumentationToolName);
    }

    public static ClassLoader getSystemToolClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    private static synchronized ToolProvider instance() {
        if (instance == null) {
            instance = new ToolProvider();
        }
        return instance;
    }

    private ToolProvider() {
    }

    private <T> T getSystemTool(Class<T> clazz, String name) {
        Class<T> c = this.getSystemToolClass(clazz, name);
        try {
            return c.asSubclass(clazz).newInstance();
        }
        catch (Error | IllegalAccessException | InstantiationException | RuntimeException e) {
            return ToolProvider.trace(Level.WARNING, e);
        }
    }

    private <T> Class<? extends T> getSystemToolClass(Class<T> clazz, String name) {
        Class<?> c;
        Reference<Class<?>> refClass = this.toolClasses.get(name);
        Class<?> clazz2 = c = refClass == null ? null : refClass.get();
        if (c == null) {
            try {
                c = Class.forName(name, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException | Error | RuntimeException e) {
                return (Class)ToolProvider.trace(Level.WARNING, e);
            }
            this.toolClasses.put(name, new WeakReference(c));
        }
        return c.asSubclass(clazz);
    }
}

