/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.blocking;

import com.sun.enterprise.web.connector.grizzly.DefaultProcessorTask;
import com.sun.enterprise.web.connector.grizzly.DefaultReadTask;
import com.sun.enterprise.web.connector.grizzly.ProcessorTask;
import com.sun.enterprise.web.connector.grizzly.SecureSelector;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.SelectorThreadConfig;
import com.sun.enterprise.web.connector.grizzly.blocking.ProcessorBlockingTask;
import com.sun.enterprise.web.connector.grizzly.blocking.ReadBlockingTask;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessControlException;
import java.util.logging.Level;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.ServerSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorBlockingThread
extends SelectorThread
implements SecureSelector<SSLImplementation> {
    protected SSLImplementation sslImplementation = null;
    private boolean secure = false;
    private ServerSocketFactory factory;

    @Override
    public void initEndpoint() throws IOException, InstantiationException {
        SelectorThreadConfig.configure(this);
        this.initFileCacheFactory();
        this.initAlgorithm();
        this.initPipeline();
        this.initMonitoringLevel();
        this.setName("SelectorThread-" + this.getPort());
        try {
            if (this.getInet() == null) {
                this.setServerSocket(this.getServerSocketFactory().createSocket(this.getPort(), this.getSsBackLog()));
            } else {
                this.setServerSocket(this.getServerSocketFactory().createSocket(this.getPort(), this.getSsBackLog(), this.getInet()));
            }
            this.getServerSocket().setReuseAddress(true);
        }
        catch (SocketException ex) {
            throw new BindException(ex.getMessage() + ": " + this.getPort());
        }
        this.getServerSocket().setSoTimeout(this.getServerTimeout());
        this.initReadBlockingTask(this.getMinReadQueueLength());
        this.setInitialized(true);
        SelectorBlockingThread.getLogger().log(Level.FINE, "Initializing Grizzly Blocking Mode");
    }

    private void initReadBlockingTask(int size) {
        for (int i = 0; i < size; ++i) {
            this.getReadTasks().offer(this.newReadBlockingTask(false));
        }
    }

    private ReadBlockingTask newReadBlockingTask(boolean initialize) {
        ReadBlockingTask task = new ReadBlockingTask();
        task.setSelectorThread(this);
        task.setPipeline(this.getProcessorPipeline());
        task.setRecycle(this.isRecycleTasks());
        task.attachProcessor(this.newProcessorTask(initialize));
        task.setPipelineStatistic(this.getPipelineStat());
        task.setSecure(this.secure);
        return task;
    }

    protected ReadBlockingTask getReadBlockingTask(Socket socket) {
        DefaultReadTask task = null;
        if (this.isRecycleTasks()) {
            task = (ReadBlockingTask)this.getReadTasks().poll();
        }
        if (task == null) {
            task = this.newReadBlockingTask(false);
        }
        ProcessorTask processorTask = task.getProcessorTask();
        processorTask.setSocket(socket);
        return task;
    }

    private void handleConnection(Socket socket) throws IOException {
        if (this.isMonitoringEnabled()) {
            this.getGlobalRequestProcessor().increaseCountOpenConnections();
            this.getPipelineStat().incrementTotalAcceptCount();
        }
        this.getReadBlockingTask(socket).execute();
    }

    @Override
    protected void setSocketOptions(Socket socket) {
        super.setSocketOptions(socket);
        if (this.getKeepAliveTimeoutInSeconds() > 0) {
            try {
                socket.setSoTimeout(this.getKeepAliveTimeoutInSeconds() * 1000);
            }
            catch (SocketException ex) {
                logger.log(Level.WARNING, "setSoTimeout exception ", ex);
            }
        }
    }

    @Override
    public void startEndpoint() throws IOException, InstantiationException {
        this.setRunning(true);
        this.rampUpProcessorTask();
        this.registerComponents();
        this.startPipelines();
        this.startListener();
    }

    protected Socket acceptSocket() {
        if (!this.isRunning() || this.getServerSocket() == null) {
            return null;
        }
        Socket socket = null;
        try {
            socket = this.getServerSocketFactory() == null ? this.getServerSocketChannel().accept().socket() : this.getServerSocketFactory().acceptSocket(this.getServerSocket());
            if (null == socket) {
                SelectorBlockingThread.getLogger().log(Level.WARNING, "selectorThread.acceptSocket");
            } else if (!this.isRunning()) {
                socket.close();
                socket = null;
            } else if (this.getServerSocketFactory() != null) {
                this.getServerSocketFactory().initSocket(socket);
            }
        }
        catch (InterruptedIOException iioe) {
        }
        catch (AccessControlException ace) {
            SelectorBlockingThread.getLogger().log(Level.WARNING, "selectorThread.wrongPermission", new Object[]{this.getServerSocket(), ace});
        }
        catch (IOException e) {
            Object msg = null;
            if (this.isRunning()) {
                SelectorBlockingThread.getLogger().log(Level.SEVERE, "selectorThread.shutdownException", new Object[]{this.getServerSocket(), e});
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable ex) {
                    SelectorBlockingThread.getLogger().log(Level.SEVERE, "selectorThread.shutdownException", new Object[]{this.getServerSocket(), ex});
                }
                socket = null;
            }
            if (!this.isRunning()) {
                return null;
            }
        }
        catch (Throwable t) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            SelectorBlockingThread.getLogger().log(Level.FINE, "selectorThread.errorOnRequest", t);
        }
        return socket;
    }

    @Override
    protected void startListener() {
        Socket socket = null;
        while (this.isRunning()) {
            socket = this.acceptSocket();
            if (socket == null) continue;
            try {
                this.handleConnection(socket);
            }
            catch (Throwable ex) {
                SelectorBlockingThread.getLogger().log(Level.FINE, "selectorThread.handleConnectionException", ex);
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected DefaultProcessorTask newProcessorTask(boolean initialize) {
        ProcessorBlockingTask task = new ProcessorBlockingTask(initialize);
        this.configureProcessorTask(task);
        task.setMaxKeepAliveRequests(this.getMaxKeepAliveRequests());
        if (this.secure) {
            task.setSSLImplementation(this.sslImplementation);
        }
        return task;
    }

    @Override
    public ServerSocketFactory getServerSocketFactory() {
        return this.factory;
    }

    @Override
    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public SSLImplementation getSSLImplementation() {
        return this.sslImplementation;
    }

    @Override
    public void setSSLImplementation(SSLImplementation sslImplementation) {
        this.sslImplementation = sslImplementation;
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return null;
    }

    @Override
    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
    }

    @Override
    public String[] getEnabledProtocols() {
        return null;
    }

    @Override
    public void setEnabledProtocols(String[] enabledProtocols) {
    }

    @Override
    public boolean isClientMode() {
        return false;
    }

    @Override
    public void setClientMode(boolean clientMode) {
    }

    @Override
    public boolean isNeedClientAuth() {
        return false;
    }

    @Override
    public void setNeedClientAuth(boolean needClientAuth) {
    }

    @Override
    public boolean isWantClientAuth() {
        return false;
    }

    @Override
    public void setWantClientAuth(boolean wantClientAuth) {
    }
}

