/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.tool.hbm2x.AbstractExporter;
import org.hibernate.tool.hbm2x.ExporterException;

public class QueryExporter
extends AbstractExporter {
    private String filename;
    private List queryStrings;

    @Override
    public void doStart() {
        Session session = null;
        SessionFactory sessionFactory = null;
        Transaction transaction = null;
        try {
            sessionFactory = this.getConfiguration().buildSessionFactory();
            session = sessionFactory.openSession();
            transaction = session.beginTransaction();
            for (String query : this.queryStrings) {
                List list = session.createQuery(query).list();
                if (this.getFileName() == null) continue;
                PrintWriter pw = null;
                try {
                    File file = new File(this.getOutputDirectory(), this.getFileName());
                    this.getTemplateHelper().ensureExistence(file);
                    pw = new PrintWriter(new FileWriter(file, true));
                    this.getArtifactCollector().addFile(file, "query-output");
                    for (Object element : list) {
                        pw.println(element);
                    }
                }
                catch (IOException e) {
                    throw new ExporterException("Could not write query output", e);
                }
                finally {
                    if (pw == null) continue;
                    pw.flush();
                    pw.close();
                }
            }
            transaction.commit();
        }
        catch (HibernateException he) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw new ExporterException("Error occured while trying to execute query", he);
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (sessionFactory != null) {
                sessionFactory.close();
            }
        }
    }

    private String getFileName() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setQueries(List queryStrings) {
        this.queryStrings = queryStrings;
    }
}

