/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import org.netbeans.modules.cnd.api.remote.ui.RemoteFileChooserUtil;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PreBuildConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.configurations.MacroExpandedEditorPanel;
import org.netbeans.modules.cnd.makeproject.ui.configurations.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakefileCustomizerNode;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PreBuildCustomizerNode
extends CustomizerNode {
    public PreBuildCustomizerNode(String name, String displayName, CustomizerNode[] children, Lookup lookup) {
        super(name, displayName, children, lookup);
    }

    @Override
    public Sheet[] getSheets(Configuration configuration) {
        Sheet sheet = PreBuildCustomizerNode.getSheet(((MakeConfiguration)configuration).getPreBuildConfiguration());
        return new Sheet[]{sheet};
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx("ProjectPropsPreBuild");
    }

    private static String getString(String s) {
        return NbBundle.getBundle(PreBuildCustomizerNode.class).getString(s);
    }

    public static Sheet getSheet(PreBuildConfiguration conf) {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("PreBuild");
        set.setDisplayName(PreBuildCustomizerNode.getString("PreBuildTxt"));
        set.setShortDescription(PreBuildCustomizerNode.getString("PreBuildHint"));
        set.put((Node.Property)new DirStringNodeProp(conf.getPreBuildCommandWorkingDir(), "PreBuildWorkingDirectory", PreBuildCustomizerNode.getString("PreBuildWorkingDirectory_LBL"), PreBuildCustomizerNode.getString("PreBuildWorkingDirectory_TT"), conf));
        set.put((Node.Property)new PreviewStringNodeProp(conf.getPreBuildCommand(), "PreBuildCommandLine", PreBuildCustomizerNode.getString("PreBuildCommandLine_LBL"), PreBuildCustomizerNode.getString("PreBuildCommandLine_TT"), conf));
        set.put((Node.Property)new BooleanNodeProp(conf.getPreBuildFirst(), true, "PreBuildFirst", PreBuildCustomizerNode.getString("PreBuildFirst_LBL"), PreBuildCustomizerNode.getString("PreBuildFirst_TT")));
        sheet.put(set);
        return sheet;
    }

    private static ExecutionEnvironment getSourceExecutionEnvironment(PreBuildConfiguration conf) {
        ExecutionEnvironment env = null;
        MakeConfiguration mc = conf.getMakeConfiguration();
        if (mc != null) {
            return FileSystemProvider.getExecutionEnvironment((FileSystem)mc.getBaseFSPath().getFileSystem());
        }
        if (env == null) {
            env = ExecutionEnvironmentFactory.getLocal();
        }
        return env;
    }

    private static class PreviewCommandLinePropEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv env;
        private final Map<String, String> macros;

        private PreviewCommandLinePropEditor(Map<String, String> macros) {
            this.macros = macros;
        }

        @Override
        public Component getCustomEditor() {
            MacroExpandedEditorPanel commandLineEditorPanel = new MacroExpandedEditorPanel(this, this.env, this.macros);
            return commandLineEditorPanel;
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        public void attachEnv(PropertyEnv env) {
            this.env = env;
        }
    }

    private static final class PreviewStringNodeProp
    extends StringNodeProp {
        private final PreBuildConfiguration conf;

        private PreviewStringNodeProp(StringConfiguration stringConfiguration, String txt1, String txt2, String txt3, PreBuildConfiguration conf) {
            super(stringConfiguration, txt1, txt2, txt3);
            this.conf = conf;
        }

        public PropertyEditor getPropertyEditor() {
            HashMap<String, String> macros = new HashMap<String, String>();
            CompilerSet cs = this.conf.getMakeConfiguration().getCompilerSet().getCompilerSet();
            if (cs != null) {
                Tool tool = cs.getTool((ToolKind)PredefinedToolKind.CCompiler);
                if (tool != null) {
                    macros.put("${IDE_CC}", tool.getPath());
                }
                if ((tool = cs.getTool((ToolKind)PredefinedToolKind.CCCompiler)) != null) {
                    macros.put("${IDE_CXX}", tool.getPath());
                }
            }
            return new PreviewCommandLinePropEditor(macros);
        }
    }

    private static class DirEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv propenv;
        private final String seed;
        private final PreBuildConfiguration conf;

        public DirEditor(String seed, PreBuildConfiguration conf) {
            this.seed = seed;
            this.conf = conf;
        }

        @Override
        public void setAsText(String text) {
            this.conf.getPreBuildCommandWorkingDir().setValue(text);
        }

        @Override
        public String getAsText() {
            return this.conf.getPreBuildCommandWorkingDir().getValue();
        }

        @Override
        public Object getValue() {
            return this.conf.getPreBuildCommandWorkingDir().getValue();
        }

        @Override
        public void setValue(Object v) {
            this.conf.getPreBuildCommandWorkingDir().setValue((String)v);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            return this.createDirPanel(this.seed, this, this.propenv);
        }

        public void attachEnv(PropertyEnv propenv) {
            this.propenv = propenv;
        }

        private JFileChooser createDirPanel(String seed, PropertyEditorSupport editor, PropertyEnv propenv) {
            String titleText = NbBundle.getMessage(MakefileCustomizerNode.class, (String)"Run_Directory");
            String buttonText = NbBundle.getMessage(MakefileCustomizerNode.class, (String)"SelectLabel");
            JFileChooser chooser = RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)PreBuildCustomizerNode.getSourceExecutionEnvironment(this.conf), (String)titleText, (String)buttonText, (int)1, null, (String)seed, (boolean)true);
            chooser.putClientProperty("title", chooser.getDialogTitle());
            chooser.setControlButtonsAreShown(false);
            propenv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            propenv.addPropertyChangeListener(evt -> {
                if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
                    File selectedFile = chooser.getSelectedFile();
                    String path = CndPathUtilities.toRelativePath((String)this.conf.getMakeConfiguration().getBaseDir(), (String)selectedFile.getPath());
                    path = CndPathUtilities.normalizeSlashes((String)path);
                    editor.setValue(path);
                }
            });
            return chooser;
        }
    }

    private static class DirStringNodeProp
    extends StringNodeProp {
        private final PreBuildConfiguration conf;

        public DirStringNodeProp(StringConfiguration stringConfiguration, String txt1, String txt2, String txt3, PreBuildConfiguration conf) {
            super(stringConfiguration, txt1, txt2, txt3);
            this.conf = conf;
        }

        @Override
        public void setValue(String v) {
            String path = CndPathUtilities.toRelativePath((String)this.conf.getMakeConfiguration().getBaseDir(), (String)v);
            path = CndPathUtilities.normalizeSlashes((String)path);
            super.setValue(path);
        }

        public PropertyEditor getPropertyEditor() {
            return new DirEditor(this.conf.getAbsPreBuildCommandWorkingDir(), this.conf);
        }
    }
}

