/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.ui.RemoteFileChooserUtil;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.utils.PathPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class AddExternalItemAction
extends AbstractAction {
    private final Project project;

    public AddExternalItemAction(Project project) {
        this.putValue("Name", NbBundle.getBundle(this.getClass()).getString("CTL_AddExternalItem"));
        this.project = project;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor projectDescriptor = pdp.getConfigurationDescriptor();
        MakeConfigurationDescriptor makeProjectDescriptor = projectDescriptor;
        if (!makeProjectDescriptor.okToChange()) {
            return;
        }
        String chooser_key = "AddExternalItem";
        ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)makeProjectDescriptor.getBaseDirFileSystem());
        String seed = RemoteFileChooserUtil.getCurrentChooserFile((String)"AddExternalItem", (ExecutionEnvironment)env);
        if (seed == null) {
            seed = makeProjectDescriptor.getBaseDir();
        }
        JFileChooser fileChooser = RemoteFileChooserUtil.createFileChooser((FileSystem)makeProjectDescriptor.getBaseDirFileSystem(), (String)NbBundle.getBundle(this.getClass()).getString("LBL_FileChooserTitle"), (String)NbBundle.getBundle(this.getClass()).getString("LBL_SelectButton"), (int)2, null, (String)seed, (boolean)true);
        PathPanel pathPanel = new PathPanel();
        fileChooser.setAccessory(pathPanel);
        fileChooser.setMultiSelectionEnabled(true);
        int ret = fileChooser.showOpenDialog(null);
        if (ret == 1) {
            return;
        }
        File[] files = fileChooser.getSelectedFiles();
        ArrayList<Item> items = new ArrayList<Item>();
        if (files.length > 0) {
            File selectedFolder = files[0].isFile() ? files[0].getParentFile() : files[0];
            RemoteFileChooserUtil.setCurrentChooserFile((String)"AddExternalItem", (String)selectedFolder.getPath(), (ExecutionEnvironment)env);
        }
        for (File file : files) {
            if (!file.exists()) {
                String errormsg = NbBundle.getMessage(AddExternalItemAction.class, (String)"FILE_DOESNT_EXISTS", (Object)file.getPath());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)errormsg, 0));
                continue;
            }
            String itemPath = ProjectSupport.toProperPath((FileObject)makeProjectDescriptor.getBaseDirFileObject(), (String)file.getPath(), (Project)this.project);
            itemPath = CndPathUtilities.normalizeSlashes((String)itemPath);
            Item item = makeProjectDescriptor.getExternalItemFolder().findItemByPath(itemPath);
            if (item != null) {
                items.add(item);
                continue;
            }
            item = Item.ItemFactory.getDefault().createInFileSystem(makeProjectDescriptor.getBaseDirFileSystem(), itemPath);
            makeProjectDescriptor.getExternalItemFolder().addItem(item);
            items.add(item);
        }
        if (items.size() > 0) {
            makeProjectDescriptor.save();
            MakeLogicalViewProvider.setVisible(this.project, items.toArray(new Item[items.size()]));
        }
    }
}

