/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.provider;

import com.sun.istack.Nullable;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.server.provider.ProviderEndpointModel;
import com.sun.xml.ws.server.provider.SOAPProviderArgumentBuilder;
import com.sun.xml.ws.server.provider.XMLProviderArgumentBuilder;
import javax.xml.ws.soap.SOAPBinding;

abstract class ProviderArgumentsBuilder<T> {
    ProviderArgumentsBuilder() {
    }

    protected abstract Message getResponseMessage(Exception var1);

    protected Packet getResponse(Packet request, Exception e, WSDLPort port, WSBinding binding) {
        Message message = this.getResponseMessage(e);
        Packet response = request.createServerResponse(message, port, null, binding);
        return response;
    }

    protected abstract T getParameter(Packet var1);

    protected abstract Message getResponseMessage(T var1);

    protected Packet getResponse(Packet request, @Nullable T returnValue, WSDLPort port, WSBinding binding) {
        Message message = null;
        if (returnValue != null) {
            message = this.getResponseMessage(returnValue);
        }
        Packet response = request.createServerResponse(message, port, null, binding);
        return response;
    }

    public static ProviderArgumentsBuilder<?> create(ProviderEndpointModel model, WSBinding binding) {
        if (model.datatype == Packet.class) {
            return new PacketProviderArgumentsBuilder();
        }
        return binding instanceof SOAPBinding ? SOAPProviderArgumentBuilder.create(model, binding.getSOAPVersion()) : XMLProviderArgumentBuilder.createBuilder(model, binding);
    }

    private static class PacketProviderArgumentsBuilder
    extends ProviderArgumentsBuilder<Packet> {
        private PacketProviderArgumentsBuilder() {
        }

        @Override
        protected Message getResponseMessage(Exception e) {
            throw new IllegalStateException();
        }

        @Override
        protected Packet getParameter(Packet packet) {
            return packet;
        }

        @Override
        protected Message getResponseMessage(Packet returnValue) {
            throw new IllegalStateException();
        }

        @Override
        protected Packet getResponse(Packet request, @Nullable Packet returnValue, WSDLPort port, WSBinding binding) {
            return returnValue;
        }
    }
}

