/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.qnavigator.navigator.CppDeclarationNode;
import org.netbeans.modules.cnd.qnavigator.navigator.CsmFileModel;
import org.netbeans.modules.cnd.qnavigator.navigator.IndexOffsetNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class NavigatorChildren
extends Children.SortedArray {
    private CsmOffsetableDeclaration element;
    private CsmCompoundClassifier container;
    private CsmFileModel model;
    private List<IndexOffsetNode> lineNumberIndex;
    private final AtomicBoolean canceled;

    public NavigatorChildren(CsmOffsetableDeclaration element, CsmFileModel model, List<IndexOffsetNode> lineNumberIndex, AtomicBoolean canceled) {
        this(element, model, null, lineNumberIndex, canceled);
    }

    public NavigatorChildren(CsmOffsetableDeclaration element, CsmFileModel model, CsmCompoundClassifier container, List<IndexOffsetNode> lineNumberIndex, AtomicBoolean canceled) {
        this.element = element;
        this.container = container;
        this.model = model;
        this.lineNumberIndex = lineNumberIndex;
        this.canceled = canceled;
        this.getNodes();
    }

    protected Collection<Node> initCollection() {
        ArrayList<CppDeclarationNode> retValue = new ArrayList<CppDeclarationNode>();
        if (this.container != null) {
            if (CsmKindUtilities.isClass((CsmObject)this.container)) {
                this.initClassifier((CsmClass)this.container, retValue);
            } else {
                this.initEnum((CsmEnum)this.container, retValue);
            }
        } else if (CsmKindUtilities.isClass((CsmObject)this.element)) {
            this.initClassifier((CsmClass)this.element, retValue);
        } else if (CsmKindUtilities.isEnum((CsmObject)this.element)) {
            this.initEnum((CsmEnum)this.element, retValue);
        } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)this.element)) {
            CsmNamespaceDefinition ns = (CsmNamespaceDefinition)this.element;
            if (!this.canceled.get()) {
                for (CsmDeclaration decl : ns.getDeclarations()) {
                    if (this.canceled.get()) break;
                    CppDeclarationNode node = CppDeclarationNode.nodeFactory((CsmObject)decl, this.model, false, this.lineNumberIndex, this.canceled);
                    if (node == null) continue;
                    retValue.add(node);
                }
            }
        }
        if (!this.canceled.get()) {
            Collections.sort(retValue);
        }
        ArrayList<CppDeclarationNode> ret = retValue;
        return ret;
    }

    private void initClassifier(CsmClass cls, List<CppDeclarationNode> retValue) {
        CppDeclarationNode node;
        if (this.canceled.get()) {
            return;
        }
        for (CsmMember member : cls.getMembers()) {
            if (this.canceled.get()) {
                return;
            }
            node = CppDeclarationNode.nodeFactory((CsmObject)member, this.model, false, this.lineNumberIndex, this.canceled);
            if (node == null) continue;
            retValue.add(node);
        }
        if (this.canceled.get()) {
            return;
        }
        for (CsmFriend friend : cls.getFriends()) {
            if (this.canceled.get()) {
                return;
            }
            node = CppDeclarationNode.nodeFactory((CsmObject)friend, this.model, true, this.lineNumberIndex, this.canceled);
            if (node == null) continue;
            retValue.add(node);
        }
    }

    private void initEnum(CsmEnum cls, List<CppDeclarationNode> retValue) {
        if (this.canceled.get()) {
            return;
        }
        for (CsmEnumerator en : cls.getEnumerators()) {
            if (this.canceled.get()) {
                return;
            }
            CppDeclarationNode node = CppDeclarationNode.nodeFactory((CsmObject)en, this.model, false, this.lineNumberIndex, this.canceled);
            if (node == null) continue;
            retValue.add(node);
        }
    }
}

