/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.qnavigator.navigator.CppDeclarationNode;
import org.netbeans.modules.cnd.qnavigator.navigator.CsmFileFilter;
import org.netbeans.modules.cnd.qnavigator.navigator.IndexOffsetNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

public class CsmFileModel {
    static final Logger logger = Logger.getLogger("org.netbeans.modules.cnd.qnavigator");
    private final List<IndexOffsetNode> lineNumberIndex = Collections.synchronizedList(new ArrayList());
    private final List<CppDeclarationNode> list = Collections.synchronizedList(new ArrayList());
    private final CsmFileFilter filter;
    private final Action[] actions;
    private FileObject fileObject;
    private CsmFile csmModelFile;
    private DataObject cdo;
    private boolean isStandalone;
    private Project unopenedProject;

    public CsmFileModel(CsmFileFilter filter, Action[] actions) {
        this.filter = filter;
        this.actions = actions;
    }

    public Node[] getNodes() {
        return this.list.toArray(new Node[0]);
    }

    void clear() {
        this.lineNumberIndex.clear();
        this.list.clear();
    }

    public CsmFileFilter getFilter() {
        return this.filter;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public DataObject getDataObject() {
        return this.cdo;
    }

    public boolean isStandalone() {
        return this.isStandalone;
    }

    public Project getUnopenedProject() {
        return this.unopenedProject;
    }

    public void addOffset(Node node, CsmOffsetable element, List<IndexOffsetNode> lineNumberIndex) {
        if (this.csmModelFile.equals(element.getContainingFile())) {
            lineNumberIndex.add(new IndexOffsetNode(node, element.getStartOffset(), element.getEndOffset()));
        } else {
            lineNumberIndex.add(new IndexOffsetNode(node, -1L, -1L));
        }
    }

    public void addFileOffset(Node node, CsmFile element, List<IndexOffsetNode> lineNumberIndex) {
        lineNumberIndex.add(new IndexOffsetNode(node, 0L, 0L));
    }

    public PreBuildModel buildPreModel(DataObject cdo, FileObject fo, CsmFile csmFile, AtomicBoolean canceled) {
        boolean oldValue = this.isStandalone;
        this.fileObject = fo;
        this.cdo = cdo;
        this.csmModelFile = csmFile;
        this.isStandalone = CsmStandaloneFileProvider.getDefault().isStandalone(csmFile);
        PreBuildModel preBuildModel = new PreBuildModel(oldValue != this.isStandalone);
        this.unopenedProject = null;
        if (csmFile != null && csmFile.isValid()) {
            CppDeclarationNode node;
            if (this.isStandalone) {
                CppDeclarationNode node2 = CppDeclarationNode.nodeFactory((CsmObject)csmFile, this, false, preBuildModel.newLineNumberIndex, canceled);
                if (node2 != null) {
                    preBuildModel.newList.add(node2);
                }
                this.unopenedProject = FileOwnerQuery.getOwner((FileObject)this.fileObject);
                if (OpenProjects.getDefault().isProjectOpen(this.unopenedProject)) {
                    this.unopenedProject = null;
                }
            }
            if (this.filter.isApplicableInclude() && !canceled.get()) {
                for (CsmInclude element : csmFile.getIncludes()) {
                    if (canceled.get()) break;
                    node = CppDeclarationNode.nodeFactory((CsmObject)element, this, false, preBuildModel.newLineNumberIndex, canceled);
                    if (node == null) continue;
                    preBuildModel.newList.add(node);
                }
            }
            if (this.filter.isApplicableMacro()) {
                if (!canceled.get()) {
                    for (CsmInclude element : csmFile.getMacros()) {
                        if (canceled.get()) break;
                        node = CppDeclarationNode.nodeFactory((CsmObject)element, this, false, preBuildModel.newLineNumberIndex, canceled);
                        if (node == null) continue;
                        preBuildModel.newList.add(node);
                    }
                }
                if (!canceled.get()) {
                    for (CsmInclude element : csmFile.getErrors()) {
                        if (canceled.get()) break;
                        node = CppDeclarationNode.nodeFactory((CsmObject)element, this, false, preBuildModel.newLineNumberIndex, canceled);
                        if (node == null) continue;
                        preBuildModel.newList.add(node);
                    }
                }
            }
            if (!canceled.get()) {
                for (CsmInclude element : csmFile.getDeclarations()) {
                    if (canceled.get()) break;
                    if (!this.filter.isApplicable((CsmOffsetable)element) || (node = CppDeclarationNode.nodeFactory((CsmObject)element, this, false, preBuildModel.newLineNumberIndex, canceled)) == null) continue;
                    preBuildModel.newList.add(node);
                }
            }
        }
        if (csmFile != null && csmFile.isValid() && !canceled.get()) {
            Collections.sort(preBuildModel.newList);
            Collections.sort(preBuildModel.newLineNumberIndex);
        }
        return preBuildModel;
    }

    public boolean buildModel(PreBuildModel preBuildModel, CsmFile csmFile, boolean force) {
        boolean res = true;
        if (csmFile != null && csmFile.isValid()) {
            this.resetScope(preBuildModel.newLineNumberIndex);
            if (force || preBuildModel.forceRebuild || this.isNeedChange(preBuildModel.newLineNumberIndex, preBuildModel.newList)) {
                this.clear();
                this.list.addAll(preBuildModel.newList);
                this.lineNumberIndex.addAll(preBuildModel.newLineNumberIndex);
                logger.log(Level.FINE, "Set new navigator model for file {0}", csmFile);
            } else {
                this.resetScope(this.lineNumberIndex);
                res = false;
                logger.log(Level.FINE, "Reset navigator model for file {0}", csmFile);
            }
        } else {
            this.clear();
            logger.log(Level.FINE, "Clear navigator model for file {0}", csmFile);
        }
        preBuildModel.newList.clear();
        preBuildModel.newLineNumberIndex.clear();
        return res;
    }

    private boolean isNeedChange(List<IndexOffsetNode> newLineNumberIndex, List<CppDeclarationNode> newList) {
        IndexOffsetNode n2;
        if (newLineNumberIndex.size() != this.lineNumberIndex.size()) {
            return true;
        }
        int i = 0;
        for (IndexOffsetNode n1 : this.lineNumberIndex) {
            if (newLineNumberIndex.size() <= i) {
                return true;
            }
            n2 = newLineNumberIndex.get(i);
            if (!this.compareNodeContent(n1, n2)) {
                return true;
            }
            ++i;
        }
        i = 0;
        for (IndexOffsetNode n1 : this.lineNumberIndex) {
            if (newLineNumberIndex.size() <= i) {
                return true;
            }
            n2 = newLineNumberIndex.get(i);
            this.updateNodeContent(n1, n2);
            ++i;
        }
        return !this.isTreeEquals(this.list, newList);
    }

    private boolean isTreeEquals(List<? extends Node> list1, List<? extends Node> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            List<Node> l2;
            Node n1 = list1.get(i);
            Node n2 = list2.get(i);
            List<Node> l1 = Arrays.asList(n1.getChildren().getNodes());
            if (this.isTreeEquals(l1, l2 = Arrays.asList(n2.getChildren().getNodes()))) continue;
            return false;
        }
        return true;
    }

    private boolean compareNodeContent(IndexOffsetNode n1, IndexOffsetNode n2) {
        CppDeclarationNode d2;
        CppDeclarationNode d1 = (CppDeclarationNode)n1.getNode();
        return d1.compareToWithoutOffset(d2 = (CppDeclarationNode)n2.getNode()) == 0;
    }

    private void updateNodeContent(IndexOffsetNode n1, IndexOffsetNode n2) {
        CppDeclarationNode d1 = (CppDeclarationNode)n1.getNode();
        CppDeclarationNode d2 = (CppDeclarationNode)n2.getNode();
        d1.resetNode(d2);
        n1.resetContent(n2);
    }

    private void resetScope(List<IndexOffsetNode> newLineNumberIndex) {
        Stack<IndexOffsetNode> stack = new Stack<IndexOffsetNode>();
        for (IndexOffsetNode node : newLineNumberIndex) {
            while (!stack.empty()) {
                IndexOffsetNode scope = (IndexOffsetNode)stack.peek();
                if (node.getStartOffset() >= scope.getStartOffset() && node.getEndOffset() <= scope.getEndOffset()) {
                    node.setScope(scope);
                    break;
                }
                stack.pop();
            }
            stack.push(node);
        }
    }

    public Node setSelection(long caretLineNo) {
        int index = Collections.binarySearch(this.lineNumberIndex, new IndexOffsetNode(null, caretLineNo, caretLineNo));
        if (index < 0) {
            index = -index - 2;
        }
        if (index > -1 && index < this.lineNumberIndex.size()) {
            IndexOffsetNode node = this.lineNumberIndex.get(index);
            if (node.getStartOffset() <= caretLineNo && node.getEndOffset() >= caretLineNo) {
                return node.getNode();
            }
            for (IndexOffsetNode scopedNode = node.getScope(); scopedNode != null; scopedNode = scopedNode.getScope()) {
                node = scopedNode;
                if (scopedNode.getStartOffset() > caretLineNo || scopedNode.getEndOffset() < caretLineNo) continue;
                return scopedNode.getNode();
            }
            if (node.getStartOffset() >= 0L && node.getEndOffset() >= 0L) {
                return node.getNode();
            }
        }
        return null;
    }

    public Action[] getActions() {
        return this.actions;
    }

    public static final class PreBuildModel {
        final List<CppDeclarationNode> newList = new ArrayList<CppDeclarationNode>();
        final List<IndexOffsetNode> newLineNumberIndex = new ArrayList<IndexOffsetNode>();
        final boolean forceRebuild;

        public PreBuildModel(boolean forceRebuild) {
            this.forceRebuild = forceRebuild;
        }
    }
}

