/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.nodes.RestServiceChildFactory;
import org.netbeans.modules.websvc.rest.nodes.RestServicesNode;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class RestServicesNodeFactory
implements NodeFactory {
    public static RestServicesNodeFactory mavenproject() {
        return new RestServicesNodeFactory();
    }

    public NodeList createNodes(Project p) {
        assert (p != null);
        return new RestNodeList(p);
    }

    private static class RestNodeList
    implements NodeList<String>,
    PropertyChangeListener {
        private static final String KEY_SERVICES = "rest_services";
        private static final String NO_SERVICES = "no_rest_services";
        private Project project;
        private AtomicReference<String> result = new AtomicReference();
        private RequestProcessor.Task restModelTask = new RequestProcessor("RestServicesModel-request-processor").create(new Runnable(){

            @Override
            public void run() {
                try {
                    RestServicesModel model = RestNodeList.this.getModel();
                    if (model != null) {
                        model.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                            public Void run(RestServicesMetadata metadata) throws IOException {
                                String oldValue;
                                RestServices root = metadata.getRoot();
                                String newValue = root.sizeRestServiceDescription() > 0 ? RestNodeList.KEY_SERVICES : RestNodeList.NO_SERVICES;
                                if (!newValue.equals(oldValue = RestNodeList.this.result.getAndSet(newValue))) {
                                    RestNodeList.this.fireChange();
                                }
                                return null;
                            }
                        });
                    } else {
                        RestNodeList.this.result.set(RestNodeList.NO_SERVICES);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(RestServiceChildFactory.class.getName()).log(Level.INFO, null, ex);
                }
            }
        });
        private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

        public RestNodeList(Project proj) {
            this.project = proj;
        }

        public List<String> keys() {
            String keys = this.result.get();
            if (keys != null) {
                ArrayList<String> tmpResult = new ArrayList<String>();
                if (KEY_SERVICES.equals(keys)) {
                    tmpResult.add(KEY_SERVICES);
                }
                return tmpResult;
            }
            this.restModelTask.schedule(100);
            return Collections.emptyList();
        }

        private RestSupport getRestSupport() {
            return (RestSupport)this.project.getLookup().lookup(RestSupport.class);
        }

        private RestServicesModel getModel() {
            RestSupport support = this.getRestSupport();
            if (support != null) {
                return support.getRestServicesModel();
            }
            return null;
        }

        public synchronized void addChangeListener(ChangeListener l) {
            this.listeners.add(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            this.listeners.remove(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ArrayList<ChangeListener> list = new ArrayList<ChangeListener>();
            RestNodeList restNodeList = this;
            synchronized (restNodeList) {
                list.addAll(this.listeners);
            }
            for (ChangeListener elem : list) {
                elem.stateChanged(new ChangeEvent(this));
            }
        }

        public Node node(String key) {
            if (KEY_SERVICES.equals(key)) {
                return new RestServicesNode(this.project, this.getRestSupport());
            }
            return null;
        }

        public void addNotify() {
            RestServicesModel m = this.getModel();
            if (m != null) {
                m.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void removeNotify() {
            RestServicesModel m = this.getModel();
            if (m != null) {
                m.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("/restservices".equals(evt.getPropertyName())) {
                this.restModelTask.schedule(100);
            }
        }
    }
}

