/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.websvc.rest.client.ClientJavaSourceHelper;
import org.netbeans.modules.websvc.rest.client.HttpParams;
import org.netbeans.modules.websvc.rest.client.Security;
import org.netbeans.modules.websvc.rest.client.SecurityParams;
import org.netbeans.modules.websvc.rest.client.Wadl2JavaHelper;
import org.netbeans.modules.websvc.rest.model.api.HttpMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.oauth.Metadata;
import org.netbeans.modules.websvc.saas.model.wadl.Method;
import org.netbeans.modules.websvc.saas.model.wadl.Representation;
import org.netbeans.modules.websvc.saas.model.wadl.Request;
import org.netbeans.modules.websvc.saas.model.wadl.Response;
import org.openide.nodes.Node;

abstract class ClientGenerationStrategy {
    private static final String SIGN_PARAMS_METHOD = "signParams";

    ClientGenerationStrategy() {
    }

    abstract ClassTree generateFields(TreeMaker var1, WorkingCopy var2, ClassTree var3, String var4, Security var5);

    abstract MethodTree generateConstructor(TreeMaker var1, WorkingCopy var2, ClassTree var3, ClientJavaSourceHelper.PathFormat var4, Security var5);

    abstract MethodTree generateSubresourceMethod(TreeMaker var1, WorkingCopy var2, ClassTree var3, ClientJavaSourceHelper.PathFormat var4);

    abstract MethodTree generateClose(TreeMaker var1, WorkingCopy var2);

    abstract MethodTree generateBasicAuth(TreeMaker var1, WorkingCopy var2, List<VariableTree> var3);

    abstract MethodTree generateHttpPOSTMethod(WorkingCopy var1, HttpMethod var2, ClientJavaSourceHelper.HttpMimeType var3, boolean var4);

    abstract Collection<? extends MethodTree> generateHttpGETMethod(WorkingCopy var1, HttpMethod var2, ClientJavaSourceHelper.HttpMimeType var3, boolean var4);

    abstract MethodTree generateHttpGETMethod(WorkingCopy var1, WadlSaasMethod var2, ClientJavaSourceHelper.HttpMimeType var3, boolean var4, HttpParams var5, Security var6);

    abstract MethodTree generateHttpPOSTMethod(WorkingCopy var1, WadlSaasMethod var2, ClientJavaSourceHelper.HttpMimeType var3, boolean var4, HttpParams var5, Security var6);

    abstract MethodTree generateFormMethod(TreeMaker var1, WorkingCopy var2);

    abstract MethodTree generateOptionalFormMethod(TreeMaker var1, WorkingCopy var2);

    abstract ClassTree generateOAuthMethods(String var1, WorkingCopy var2, ClassTree var3, Metadata var4);

    abstract boolean requiresJersey(Node var1, Security var2);

    List<MethodTree> generateHttpMethods(WorkingCopy copy, HttpMethod httpMethod) {
        ArrayList<MethodTree> httpMethods = new ArrayList<MethodTree>();
        String method = httpMethod.getType();
        if ("GET".equals(method)) {
            boolean found = false;
            String produces = httpMethod.getProduceMime();
            if (produces.length() > 0) {
                boolean multipleMimeTypes = produces.contains(",");
                for (ClientJavaSourceHelper.HttpMimeType mimeType : ClientJavaSourceHelper.HttpMimeType.values()) {
                    if (!produces.contains(mimeType.getMimeType())) continue;
                    httpMethods.addAll(this.generateHttpGETMethod(copy, httpMethod, mimeType, multipleMimeTypes));
                    found = true;
                }
            }
            if (!found) {
                httpMethods.addAll(this.generateHttpGETMethod(copy, httpMethod, null, false));
            }
        } else if ("PUT".equals(method) || "POST".equals(method) || "DELETE".equals(method)) {
            boolean found = false;
            String consumes = httpMethod.getConsumeMime();
            if (consumes.length() > 0) {
                boolean multipleMimeTypes = consumes.contains(",");
                for (ClientJavaSourceHelper.HttpMimeType mimeType : ClientJavaSourceHelper.HttpMimeType.values()) {
                    if (!consumes.contains(mimeType.getMimeType())) continue;
                    httpMethods.add(this.generateHttpPOSTMethod(copy, httpMethod, mimeType, multipleMimeTypes));
                    found = true;
                }
            }
            if (!found) {
                httpMethods.add(this.generateHttpPOSTMethod(copy, httpMethod, null, false));
            }
        }
        return httpMethods;
    }

    MethodTree generateConstructorAuthBasic(TreeMaker maker) {
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        IdentifierTree argTypeTree = maker.Identifier((CharSequence)"String");
        ModifiersTree fieldModifier = maker.Modifiers(Collections.emptySet());
        VariableTree argFieldTree = maker.Variable(fieldModifier, (CharSequence)"username", (Tree)argTypeTree, null);
        paramList.add(argFieldTree);
        argFieldTree = maker.Variable(fieldModifier, (CharSequence)"password", (Tree)argTypeTree, null);
        paramList.add(argFieldTree);
        String body = "{this();setUsernamePassword(username, password);}";
        return maker.Constructor(methodModifier, Collections.emptyList(), paramList, Collections.emptyList(), body);
    }

    List<MethodTree> generateHttpMethods(WorkingCopy copy, WadlSaasMethod saasMethod, HttpParams httpParams, Security security) {
        ArrayList<MethodTree> httpMethods = new ArrayList<MethodTree>();
        Method wadlMethod = saasMethod.getWadlMethod();
        String methodType = wadlMethod.getName();
        if ("GET".equals(methodType)) {
            ArrayList produces = new ArrayList();
            for (Response wadlResponse : wadlMethod.getResponse()) {
                if (wadlResponse == null) continue;
                List representations = wadlResponse.getRepresentation();
                produces.addAll(representations);
            }
            boolean found = false;
            boolean multipleMimeTypes = produces.size() > 1;
            block1: for (Representation prod : produces) {
                String mediaType = prod.getMediaType();
                if (mediaType == null) continue;
                for (ClientJavaSourceHelper.HttpMimeType mimeType : ClientJavaSourceHelper.HttpMimeType.values()) {
                    if (!mediaType.equals(mimeType.getMimeType())) continue;
                    MethodTree method = this.generateHttpGETMethod(copy, saasMethod, mimeType, multipleMimeTypes, httpParams, security);
                    if (method != null) {
                        httpMethods.add(method);
                    }
                    found = true;
                    continue block1;
                }
            }
            if (!found) {
                httpMethods.add(this.generateHttpGETMethod(copy, saasMethod, null, false, httpParams, security));
            }
        } else if ("PUT".equals(methodType) || "POST".equals(methodType) || "DELETE".equals(methodType)) {
            ArrayList<Representation> consumes = new ArrayList<Representation>();
            Request wadlRequest = wadlMethod.getRequest();
            if (wadlRequest != null) {
                List representationTypes = wadlRequest.getRepresentation();
                for (Representation reprType : representationTypes) {
                    consumes.add(reprType);
                }
            }
            boolean found = false;
            boolean multipleMimeTypes = consumes.size() > 1;
            block4: for (Representation cons : consumes) {
                String mediaType = cons.getMediaType();
                if (mediaType == null) continue;
                for (ClientJavaSourceHelper.HttpMimeType mimeType : ClientJavaSourceHelper.HttpMimeType.values()) {
                    if (!mediaType.equals(mimeType.getMimeType())) continue;
                    MethodTree method = this.generateHttpPOSTMethod(copy, saasMethod, mimeType, multipleMimeTypes, httpParams, security);
                    if (method != null) {
                        httpMethods.add(method);
                    }
                    found = true;
                    continue block4;
                }
            }
            if (!found) {
                httpMethods.add(this.generateHttpPOSTMethod(copy, saasMethod, null, false, httpParams, security));
            }
        }
        return httpMethods;
    }

    protected abstract void buildQueryFormParams(StringBuilder var1);

    protected abstract void buildQParams(StringBuilder var1);

    protected String getPathExpression(ClientJavaSourceHelper.PathFormat pf) {
        String[] arguments = pf.getArguments();
        if (arguments.length == 0) {
            return "\"" + pf.getPattern() + "\"";
        }
        return "java.text.MessageFormat.format(\"" + pf.getPattern() + "\", new Object[] {" + this.getArgumentList(arguments) + "})";
    }

    protected String getArgumentList(String[] arguments) {
        if (arguments.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(arguments[0]);
        for (int i = 1; i < arguments.length; ++i) {
            buf.append("," + arguments[i]);
        }
        return buf.toString();
    }

    protected void buildQueryParams(StringBuilder body, HttpMethod httpMethod, List<VariableTree> paramList, TreeMaker maker) {
        Map queryParams = httpMethod.getQueryParams();
        if (queryParams.size() == 0) {
            return;
        }
        for (Map.Entry entry : queryParams.entrySet()) {
            String paramName = (String)entry.getKey();
            if (paramName == null) continue;
            String clientParam = this.getClientParamName(paramName, paramList);
            IdentifierTree typeTree = maker.Identifier((CharSequence)"String");
            ModifiersTree fieldModifier = maker.Modifiers(Collections.emptySet());
            VariableTree fieldTree = maker.Variable(fieldModifier, (CharSequence)clientParam, (Tree)typeTree, null);
            paramList.add(fieldTree);
            body.append("if (");
            body.append(clientParam);
            body.append("!=null){");
            body.append("resource = resource.queryParam(\"");
            body.append(paramName);
            body.append("\",");
            body.append(clientParam);
            body.append(");}");
        }
    }

    protected String getClientParamName(String paramName, List<VariableTree> paramList) {
        return this.getClientParamName(paramName, paramList, 0);
    }

    protected String getClientParamName(String paramName, List<VariableTree> paramList, int index) {
        String result = paramName;
        if (index != 0) {
            result = paramName + index;
        }
        for (VariableTree var : paramList) {
            String name = var.getName().toString();
            if (!name.equals(result)) continue;
            return this.getClientParamName(paramName, paramList, index + 1);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    protected void addQueryParams(TreeMaker maker, HttpParams httpParams, Security security, List<VariableTree> paramList, StringBuilder queryP, StringBuilder queryParamPart, StringBuilder commentBuffer) {
        Wadl2JavaHelper.Pair<String> paramPair;
        String javaIdentifier;
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        SecurityParams securityParams = security.getSecurityParams();
        if (httpParams.hasFormParams()) {
            for (String string : httpParams.getFormParams()) {
                if (securityParams != null && (Wadl2JavaHelper.isSecurityParam(string, securityParams) || Wadl2JavaHelper.isSignatureParam(string, securityParams))) continue;
                javaIdentifier = Wadl2JavaHelper.makeJavaIdentifier(string);
                VariableTree variableTree = maker.Variable(paramModifier, (CharSequence)javaIdentifier, (Tree)maker.Identifier((CharSequence)"String"), null);
                paramList.add(variableTree);
                commentBuffer.append("@param " + javaIdentifier + " form parameter\n");
            }
            paramPair = null;
            paramPair = securityParams != null ? Wadl2JavaHelper.getParamList(httpParams.getFormParams(), httpParams.getFixedFormParams(), securityParams) : Wadl2JavaHelper.getParamList(httpParams.getFormParams(), httpParams.getFixedFormParams());
            queryParamPart.append("String[] formParamNames = new String[] {" + paramPair.getKey() + "};");
            queryParamPart.append("String[] formParamValues = new String[] {" + paramPair.getValue() + "};");
        }
        if (httpParams.hasQueryParams()) {
            if (httpParams.hasRequiredQueryParams()) {
                for (String string : httpParams.getRequiredQueryParams()) {
                    if (securityParams != null && (Wadl2JavaHelper.isSecurityParam(string, securityParams) || Wadl2JavaHelper.isSignatureParam(string, securityParams))) continue;
                    javaIdentifier = Wadl2JavaHelper.makeJavaIdentifier(string);
                    VariableTree variableTree = maker.Variable(paramModifier, (CharSequence)javaIdentifier, (Tree)maker.Identifier((CharSequence)"String"), null);
                    paramList.add(variableTree);
                    commentBuffer.append("@param " + javaIdentifier + " query parameter[REQUIRED]\n");
                }
                if (httpParams.hasMultipleParamsInList()) {
                    paramPair = null;
                    paramPair = securityParams != null ? Wadl2JavaHelper.getParamList(httpParams.getRequiredQueryParams(), httpParams.getFixedQueryParams(), securityParams) : Wadl2JavaHelper.getParamList(httpParams.getRequiredQueryParams(), httpParams.getFixedQueryParams());
                    queryParamPart.append("String[] queryParamNames = new String[] {" + paramPair.getKey() + "};");
                    queryParamPart.append("String[] queryParamValues = new String[] {" + paramPair.getValue() + "};");
                    if (Security.Authentication.SESSION_KEY == security.getAuthentication() && securityParams != null) {
                        void var11_16;
                        String string = "";
                        if (httpParams.hasOptionalQueryParams()) {
                            String string2 = ", optionalQueryParams";
                        }
                        queryParamPart.append("String signature = signParams(queryParamNames, queryParamValues" + (String)var11_16 + ");");
                        String sigParam = securityParams.getSignature();
                        queryP.append(".queryParam(\"" + sigParam + "\", signature)");
                        this.buildQueryFormParams(queryP);
                    } else {
                        this.buildQueryFormParams(queryP);
                    }
                } else {
                    List<String> requiredParams = httpParams.getRequiredQueryParams();
                    if (requiredParams.size() > 0) {
                        String string = (String)requiredParams.get(0);
                        String paramValue = Wadl2JavaHelper.makeJavaIdentifier((String)requiredParams.get(0));
                        if (Security.Authentication.SESSION_KEY == security.getAuthentication() && securityParams != null && httpParams.hasFormParams()) {
                            void var13_32;
                            String string3 = "";
                            if (httpParams.hasOptionalQueryParams()) {
                                String string4 = ", optionalQueryParams";
                            }
                            queryParamPart.append("String signature = signParams(formParamNames, formParamValues" + (String)var13_32 + ");");
                            String sigParam = securityParams.getSignature();
                            queryP.append(".queryParam(\"" + sigParam + "\", signature)");
                        } else {
                            queryP.append(".queryParam(\"" + string + "\"," + (String)paramValue + ")");
                        }
                    } else {
                        Map<String, String> map = httpParams.getFixedQueryParams();
                        for (Map.Entry entry : map.entrySet()) {
                            String paramName = (String)entry.getKey();
                            String paramValue = (String)entry.getValue();
                            queryP.append(".queryParam(\"" + paramName + "\",\"" + paramValue + "\")");
                        }
                    }
                }
            } else if (httpParams.hasOptionalQueryParams()) {
                for (String string : httpParams.getOptionalQueryParams()) {
                    javaIdentifier = Wadl2JavaHelper.makeJavaIdentifier(string);
                    VariableTree variableTree = maker.Variable(paramModifier, (CharSequence)javaIdentifier, (Tree)maker.Identifier((CharSequence)"String"), null);
                    paramList.add(variableTree);
                    commentBuffer.append("@param " + javaIdentifier + " query parameter\n");
                }
                paramPair = Wadl2JavaHelper.getParamList(httpParams.getOptionalQueryParams(), Collections.<String, String>emptyMap());
                queryParamPart.append("String[] queryParamNames = new String[] {" + paramPair.getKey() + "};");
                queryParamPart.append("String[] queryParamValues = new String[] {" + paramPair.getValue() + "};");
                this.buildQueryFormParams(queryP);
            }
            if (httpParams.hasOptionalQueryParams() && httpParams.hasRequiredQueryParams() || httpParams.hasDefaultQueryParams()) {
                VariableTree paramTree2 = maker.Variable(paramModifier, (CharSequence)"optionalQueryParams", (Tree)maker.Identifier((CharSequence)"String..."), null);
                paramList.add(paramTree2);
                commentBuffer.append("@param optionalQueryParams List of optional query parameters in the form of \"param_name=param_value\",...<br>\nList of optional query parameters:\n");
                for (String otherParam : httpParams.getOptionalQueryParams()) {
                    commentBuffer.append("<LI>" + otherParam + " [OPTIONAL]\n");
                }
                Map<String, String> map = httpParams.getDefaultQueryParams();
                for (String string : map.keySet()) {
                    commentBuffer.append("<LI>" + string + " [OPTIONAL, DEFAULT VALUE: \"" + map.get(string) + "\"]\n");
                }
                this.buildQParams(queryP);
            }
        }
    }

    protected void addHeaderParams(TreeMaker maker, HttpParams httpParams, List<VariableTree> paramList, StringBuilder queryP, StringBuilder commentBuffer) {
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        if (httpParams.hasHeaderParams()) {
            for (String headerParam : httpParams.getHeaderParams()) {
                String javaIdentifier = Wadl2JavaHelper.makeJavaIdentifier(headerParam);
                VariableTree paramTree = maker.Variable(paramModifier, (CharSequence)javaIdentifier, (Tree)maker.Identifier((CharSequence)"String"), null);
                paramList.add(paramTree);
                commentBuffer.append("@param " + javaIdentifier + " header parameter[REQUIRED]\n");
                queryP.append(".header(\"" + headerParam + "\"," + javaIdentifier + ")");
            }
            Map<String, String> fixedHeaderParams = httpParams.getFixedHeaderParams();
            for (String paramName : fixedHeaderParams.keySet()) {
                String paramValue = fixedHeaderParams.get(paramName);
                queryP.append(".header(\"" + paramName + "\",\"" + paramValue + "\")");
            }
        }
    }

    static ClientJavaSourceHelper.PathFormat getPathFormat(String path) {
        String p = ClientGenerationStrategy.normalizePath(path);
        ClientJavaSourceHelper.PathFormat pathFormat = new ClientJavaSourceHelper.PathFormat();
        StringBuilder buf = new StringBuilder();
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = 0; i < p.length(); ++i) {
            char ch = p.charAt(i);
            if (ch == '{') {
                int j;
                for (j = i + 1; j < p.length() && p.charAt(j) != '}'; ++j) {
                }
                String arg = p.substring(i + 1, j);
                int index = arg.indexOf(58);
                if (index > -1) {
                    arg = arg.substring(0, index);
                }
                buf.append("{" + arguments.size() + "}");
                arguments.add(arg);
                i = j;
                continue;
            }
            buf.append(ch);
        }
        pathFormat.setPattern(buf.toString().trim());
        pathFormat.setArguments(arguments.toArray(new String[arguments.size()]));
        return pathFormat;
    }

    static String normalizePath(String path) {
        String s = path;
        while (s.startsWith("/")) {
            s = s.substring(1);
        }
        while (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }
}

