/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.java.navigation.ClassMemberFilters;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.actions.OpenAction;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class ElementNode
extends AbstractNode {
    private static final String ACTION_FOLDER = "Navigator/Actions/Members/text/x-java";
    private static Node WAIT_NODE;
    private OpenAction openAction;
    private Description description;
    private static final InstanceContent.Convertor<Description, TreePathHandle> ConvertDescription2TreePathHandle;
    private static final InstanceContent.Convertor<Description, FileObject> ConvertDescription2FileObject;
    private static final InstanceContent.Convertor<Description, DataObject> ConvertDescription2DataObject;

    public ElementNode(Description description) {
        super((Children)(description.subs == null ? Children.LEAF : new ElementChilren(description.subs, description.ui.getFilters())), description.elementHandle == null ? null : ElementNode.prepareLookup(description));
        this.description = description;
        this.setDisplayName(description.name);
    }

    public Image getIcon(int type) {
        return this.description.kind == null ? super.getIcon(type) : ImageUtilities.icon2Image((Icon)ElementIcons.getElementIcon((ElementKind)this.description.kind, this.description.modifiers));
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public String getDisplayName() {
        if (this.description.name != null) {
            return this.description.name;
        }
        if (this.description.fileObject != null) {
            return this.description.fileObject.getNameExt();
        }
        return null;
    }

    public String getHtmlDisplayName() {
        return this.description.htmlHeader;
    }

    public Action[] getActions(boolean context) {
        if (context || this.description.name == null) {
            return this.description.ui.getActions();
        }
        Action[] panelActions = this.description.ui.getActions();
        List additionalActions = Utilities.actionsForPath((String)ACTION_FOLDER);
        int additionalActionSize = additionalActions.isEmpty() ? 0 : additionalActions.size() + 1;
        ArrayList<Action> actions = new ArrayList<Action>(4 + panelActions.length + additionalActionSize);
        actions.add(this.getOpenAction());
        actions.add((Action)RefactoringActionsFactory.whereUsedAction());
        actions.add((Action)RefactoringActionsFactory.popupSubmenuAction());
        actions.add(null);
        if (additionalActionSize > 0) {
            actions.addAll(additionalActions);
            actions.add(null);
        }
        actions.addAll(Arrays.asList(panelActions));
        return actions.toArray(new Action[actions.size()]);
    }

    public Action getPreferredAction() {
        return this.getOpenAction();
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        return null;
    }

    public Transferable drag() throws IOException {
        return null;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
    }

    private synchronized Action getOpenAction() {
        if (this.openAction == null && this.description.elementHandle != null) {
            this.openAction = new OpenAction(this.description.elementHandle, this.description.getFileObject(), this.description.name);
        }
        return this.openAction;
    }

    static synchronized Node getWaitNode() {
        if (WAIT_NODE == null) {
            WAIT_NODE = new WaitNode();
        }
        return WAIT_NODE;
    }

    public void refreshRecursively() {
        Children ch = this.getChildren();
        if (ch instanceof ElementChilren) {
            boolean scrollOnExpand = this.description.ui.getScrollOnExpand();
            this.description.ui.setScrollOnExpand(false);
            ((ElementChilren)ch).resetKeys(this.description.subs, this.description.ui.getFilters());
            for (Node sub : ch.getNodes()) {
                this.description.ui.expandNode(sub);
                ((ElementNode)sub).refreshRecursively();
            }
            this.description.ui.setScrollOnExpand(scrollOnExpand);
        }
    }

    public ElementNode getNodeForElement(ElementHandle<Element> eh) {
        if (this.getDescritption().elementHandle != null && eh.signatureEquals(this.getDescritption().elementHandle)) {
            return this;
        }
        Children ch = this.getChildren();
        if (ch instanceof ElementChilren) {
            for (Node sub : ch.getNodes()) {
                ElementNode result = ((ElementNode)sub).getNodeForElement(eh);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public void updateRecursively(Description newDescription) {
        Children ch = this.getChildren();
        if (ch instanceof ElementChilren) {
            HashSet<Description> oldSubs = new HashSet<Description>(this.description.subs);
            Node[] nodes = ch.getNodes(true);
            HashMap<Description, ElementNode> oldD2node = new HashMap<Description, ElementNode>();
            for (Node node : nodes) {
                oldD2node.put(((ElementNode)node).description, (ElementNode)node);
            }
            ((ElementChilren)ch).resetKeys(newDescription.subs, newDescription.ui.getFilters());
            nodes = ch.getNodes(true);
            for (Description newSub : newDescription.subs) {
                ElementNode node = (ElementNode)((Object)oldD2node.get(newSub));
                if (node == null) continue;
                if (!oldSubs.contains(newSub) && node.getChildren() != Children.LEAF) {
                    this.description.ui.expandNode((Node)node);
                }
                node.updateRecursively(newSub);
            }
        }
        Description oldDescription = this.description;
        this.description = newDescription;
        if (oldDescription.htmlHeader != null && !oldDescription.htmlHeader.equals(this.description.htmlHeader)) {
            this.fireDisplayNameChange(oldDescription.htmlHeader, this.description.htmlHeader);
        }
        if (oldDescription.modifiers != null && !oldDescription.modifiers.equals(newDescription.modifiers)) {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }
    }

    public Description getDescritption() {
        return this.description;
    }

    private static Lookup prepareLookup(Description d) {
        InstanceContent ic = new InstanceContent();
        ic.add((Object)d, ConvertDescription2TreePathHandle);
        ic.add((Object)d, ConvertDescription2FileObject);
        ic.add((Object)d, ConvertDescription2DataObject);
        return new AbstractLookup((AbstractLookup.Content)ic);
    }

    static {
        ConvertDescription2TreePathHandle = new InstanceContent.Convertor<Description, TreePathHandle>(){

            public TreePathHandle convert(Description obj) {
                return obj.elementHandle == null ? null : TreePathHandle.from(obj.elementHandle, (ClasspathInfo)obj.cpInfo);
            }

            public Class<? extends TreePathHandle> type(Description obj) {
                return TreePathHandle.class;
            }

            public String id(Description obj) {
                return "IL[" + obj.toString();
            }

            public String displayName(Description obj) {
                return this.id(obj);
            }
        };
        ConvertDescription2FileObject = new InstanceContent.Convertor<Description, FileObject>(){

            public FileObject convert(Description d) {
                return d.getFileObject();
            }

            public Class<? extends FileObject> type(Description obj) {
                return FileObject.class;
            }

            public String id(Description obj) {
                return "IL[" + obj.toString();
            }

            public String displayName(Description obj) {
                return this.id(obj);
            }
        };
        ConvertDescription2DataObject = new InstanceContent.Convertor<Description, DataObject>(){

            public DataObject convert(Description d) {
                try {
                    FileObject fo = d.getFileObject();
                    return fo == null ? null : DataObject.find((FileObject)fo);
                }
                catch (DataObjectNotFoundException ex) {
                    return null;
                }
            }

            public Class<? extends DataObject> type(Description obj) {
                return DataObject.class;
            }

            public String id(Description obj) {
                return "IL[" + obj.toString();
            }

            public String displayName(Description obj) {
                return this.id(obj);
            }
        };
    }

    private static class WaitNode
    extends AbstractNode {
        private Image waitIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/wait.gif");

        WaitNode() {
            super(Children.LEAF);
        }

        public Image getIcon(int type) {
            return this.waitIcon;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(ElementNode.class, (String)"LBL_WaitNode");
        }
    }

    static class Description {
        public static final Comparator<Description> ALPHA_COMPARATOR = new DescriptionComparator(true);
        public static final Comparator<Description> POSITION_COMPARATOR = new DescriptionComparator(false);
        ClassMemberPanelUI ui;
        FileObject fileObject;
        final String name;
        final ElementHandle<? extends Element> elementHandle;
        final ElementKind kind;
        Set<Modifier> modifiers;
        Collection<Description> subs;
        String htmlHeader;
        long pos;
        final boolean isInherited;
        final boolean isTopLevel;
        ClasspathInfo cpInfo;

        Description(ClassMemberPanelUI ui) {
            this.ui = ui;
            this.name = null;
            this.elementHandle = null;
            this.kind = null;
            this.isInherited = false;
            this.isTopLevel = false;
        }

        Description(@NonNull ClassMemberPanelUI ui, @NonNull String name, @NonNull ElementHandle<? extends Element> elementHandle, @NonNull ElementKind kind, boolean inherited, boolean topLevel) {
            Parameters.notNull((CharSequence)"ui", (Object)ui);
            Parameters.notNull((CharSequence)"name", (Object)name);
            Parameters.notNull((CharSequence)"elementHandle", elementHandle);
            Parameters.notNull((CharSequence)"kind", (Object)((Object)kind));
            this.ui = ui;
            this.name = name;
            this.elementHandle = elementHandle;
            this.kind = kind;
            this.isInherited = inherited;
            this.isTopLevel = topLevel;
        }

        public FileObject getFileObject() {
            if (!this.isInherited) {
                return this.ui.getFileObject();
            }
            return SourceUtils.getFile(this.elementHandle, (ClasspathInfo)this.cpInfo);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Description)) {
                return false;
            }
            Description d = (Description)o;
            if (this.kind != d.kind) {
                return false;
            }
            if (!(this.name == d.name || this.name != null && this.name.equals(d.name))) {
                return false;
            }
            return this.elementHandle == d.elementHandle || this.elementHandle != null && this.elementHandle.equals(d.elementHandle);
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 29 * hash + (this.kind != null ? this.kind.hashCode() : 0);
            return hash;
        }

        private static class DescriptionComparator
        implements Comparator<Description> {
            boolean alpha;

            DescriptionComparator(boolean alpha) {
                this.alpha = alpha;
            }

            @Override
            public int compare(Description d1, Description d2) {
                if (this.alpha) {
                    return this.alphaCompare(d1, d2);
                }
                if (d1.isInherited && !d2.isInherited) {
                    return 1;
                }
                if (!d1.isInherited && d2.isInherited) {
                    return -1;
                }
                if (d1.isInherited && d2.isInherited) {
                    return this.alphaCompare(d1, d2);
                }
                return d1.pos == d2.pos ? 0 : (d1.pos < d2.pos ? -1 : 1);
            }

            int alphaCompare(Description d1, Description d2) {
                if (this.k2i(d1.kind) != this.k2i(d2.kind)) {
                    return this.k2i(d1.kind) - this.k2i(d2.kind);
                }
                return d1.name.compareTo(d2.name);
            }

            int k2i(ElementKind kind) {
                switch (kind) {
                    case CONSTRUCTOR: {
                        return 1;
                    }
                    case METHOD: {
                        return 2;
                    }
                    case FIELD: {
                        return 3;
                    }
                    case CLASS: 
                    case INTERFACE: 
                    case ENUM: 
                    case ANNOTATION_TYPE: {
                        return 4;
                    }
                }
                return 100;
            }
        }
    }

    private static final class ElementChilren
    extends Children.Keys<Description> {
        public ElementChilren(Collection<Description> descriptions, ClassMemberFilters filters) {
            this.resetKeys(descriptions, filters);
        }

        protected Node[] createNodes(Description key) {
            return new Node[]{new ElementNode(key)};
        }

        void resetKeys(Collection<Description> descriptions, ClassMemberFilters filters) {
            this.setKeys(filters.filter((Collection<? extends Description>)descriptions));
        }
    }
}

