/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.model;

import com.sun.tools.xjc.api.ClassNameAllocator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AutoClassNameAllocator
implements ClassNameAllocator {
    private final ClassNameAllocator core;
    private final Map<String, Set<String>> names = new HashMap<String, Set<String>>();

    public AutoClassNameAllocator(ClassNameAllocator core) {
        this.core = core;
    }

    public String assignClassName(String packageName, String className) {
        className = this.determineName(packageName, className);
        if (this.core != null) {
            className = this.core.assignClassName(packageName, className);
        }
        return className;
    }

    private String determineName(String packageName, String className) {
        Set<String> s = this.names.get(packageName);
        if (s == null) {
            s = new HashSet<String>();
            this.names.put(packageName, s);
        }
        if (s.add(className)) {
            return className;
        }
        int i = 2;
        while (!s.add(className + i)) {
            ++i;
        }
        return className + i;
    }
}

