/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.spi.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.spi.annotation.AnnotationCompletionTag;
import org.openide.util.Parameters;

public abstract class AnnotationCompletionTagProvider {
    private final String identifier;
    private final String name;
    private final String description;

    public AnnotationCompletionTagProvider(@NonNull String identifier, @NonNull String name, @NullAllowed String description) {
        Parameters.notNull((CharSequence)"identifier", (Object)identifier);
        Parameters.notNull((CharSequence)"name", (Object)name);
        this.identifier = identifier;
        this.name = name;
        this.description = description;
    }

    public final String getIdentifier() {
        return this.identifier;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.getName();
    }

    public List<AnnotationCompletionTag> getAnnotations() {
        LinkedHashSet<AnnotationCompletionTag> annotations = new LinkedHashSet<AnnotationCompletionTag>();
        annotations.addAll(this.getFunctionAnnotations());
        annotations.addAll(this.getTypeAnnotations());
        annotations.addAll(this.getFieldAnnotations());
        annotations.addAll(this.getMethodAnnotations());
        return new ArrayList<AnnotationCompletionTag>(annotations);
    }

    public abstract List<AnnotationCompletionTag> getFunctionAnnotations();

    public abstract List<AnnotationCompletionTag> getTypeAnnotations();

    public abstract List<AnnotationCompletionTag> getFieldAnnotations();

    public abstract List<AnnotationCompletionTag> getMethodAnnotations();

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface Registration {
        public int position() default 0x7FFFFFFF;
    }
}

