/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.Scope;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.modules.java.hints.introduce.MemberSearchResult;
import org.netbeans.modules.java.hints.introduce.MemberValidator;

final class FieldValidator
implements MemberValidator {
    private final JavaSource theSource;
    private final TypeMirrorHandle fieldTypeHandle;
    private String name;
    private ElementHandle<Element> target;
    private MemberSearchResult lastResult;

    public FieldValidator(JavaSource theSource, TypeMirrorHandle fieldTypeHandle) {
        this.theSource = theSource;
        this.fieldTypeHandle = fieldTypeHandle;
    }

    MemberSearchResult getLastResult() {
        return this.lastResult;
    }

    @Override
    public synchronized MemberSearchResult validateName(TreePathHandle target, String n) {
        if ((target == target || target.equals((Object)target)) && n.equals(this.name)) {
            return this.lastResult;
        }
        SearchImpl impl = new SearchImpl(target, n);
        try {
            this.theSource.runUserActionTask((Task)impl, true);
        }
        catch (IOException ex) {
            return null;
        }
        return this.lastResult;
    }

    private class SearchImpl
    implements Task<CompilationController>,
    ElementUtilities.ElementAcceptor {
        private final TreePathHandle targetHandle;
        private final String name;
        private CompilationInfo cinfo;
        private Element target;
        private Scope initialScope;

        public SearchImpl(TreePathHandle targetHandle, String name) {
            this.targetHandle = targetHandle;
            this.name = name;
        }

        public void run(CompilationController parameter) throws Exception {
            parameter.toPhase(JavaSource.Phase.RESOLVED);
            this.cinfo = parameter;
            if (this.targetHandle == null) {
                return;
            }
            TreePath targetPath = this.targetHandle.resolve(this.cinfo);
            if (this.target == null) {
                return;
            }
            this.initialScope = this.cinfo.getTrees().getScope(targetPath);
            Map visibleVariables = this.cinfo.getElementUtilities().findElementsAndOrigins(this.initialScope, (ElementUtilities.ElementAcceptor)this);
            for (Element e : visibleVariables.keySet()) {
                if (e.getKind() == ElementKind.FIELD || e.getKind() == ElementKind.ENUM_CONSTANT) {
                    Scope def = (Scope)visibleVariables.get(e);
                    TypeElement owner = def.getEnclosingClass();
                    if (owner == null) {
                        FieldValidator.this.lastResult = new MemberSearchResult((ElementHandle<? extends Element>)ElementHandle.create((Element)e), (ElementHandle<? extends TypeElement>)ElementHandle.create((Element)((TypeElement)e.getEnclosingElement())));
                        continue;
                    }
                    if (owner == e.getEnclosingElement()) {
                        FieldValidator.this.lastResult = new MemberSearchResult((ElementHandle<? extends Element>)ElementHandle.create((Element)e), (ElementHandle<? extends TypeElement>)ElementHandle.create((Element)owner));
                        continue;
                    }
                    FieldValidator.this.lastResult = new MemberSearchResult((ElementHandle<? extends Element>)ElementHandle.create((Element)e), (ElementHandle<? extends TypeElement>)ElementHandle.create((Element)owner), null);
                    continue;
                }
                FieldValidator.this.lastResult = new MemberSearchResult((ElementHandle<? extends Element>)ElementHandle.create((Element)e));
                return;
            }
        }

        public boolean accept(Element e, TypeMirror type) {
            boolean checkAccessible = false;
            switch (e.getKind()) {
                case ENUM_CONSTANT: 
                case FIELD: {
                    checkAccessible = true;
                    break;
                }
                case PARAMETER: 
                case LOCAL_VARIABLE: 
                case EXCEPTION_PARAMETER: 
                case TYPE_PARAMETER: 
                case RESOURCE_VARIABLE: {
                    break;
                }
                default: {
                    return false;
                }
            }
            if (!e.getSimpleName().contentEquals(this.name)) {
                return false;
            }
            return !checkAccessible || type == null || this.cinfo.getTrees().isAccessible(this.initialScope, e, (DeclaredType)type);
        }
    }
}

