/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.clank.java.std;
import org.clank.support.ByteUtils;
import org.clank.support.Casts;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.UTF_8;
import org.clank.support.aliases.char$memory;
import org.clank.support.aliases.char$ptr;
import org.clank.support.aliases.char$ptr$heavy;
import org.clank.support.aliases.int$ptr;
import org.clank.support.aliases.int$ptr$heavy;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.uint$memory;
import org.clank.support.aliases.uint$ptr;
import org.clank.support.aliases.uint$ptr$heavy;
import org.clank.support.char$ptr$CharSequence;
import org.clank.support.void$ptr;

public final class Casts {
    private static final AtomicLong counter = new AtomicLong(1L);
    private static final HashMap<Long, Reference<Object>> longToObjectMap = new HashMap();
    private static final WeakHashMap<Object, Long> objTolongMap = new WeakHashMap();
    private static long callReinterpret_cast = 0L;
    private static long callReinterpret_cast_long = 0L;
    private static long callReinterpret_cast_long_bytes = 0L;
    private static long callReinterpret_cast_int_bytes = 0L;

    private Casts() {
    }

    public static <T> T static_cast(Object o, Class<T> cls) {
        if (o != null && cls.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        if (!(o instanceof void$ptr) && cls == void$ptr.class) {
            return (T)new void.ptr.impl(o);
        }
        if (o instanceof void.ptr.impl) {
            return (T)((void.ptr.impl)o).value;
        }
        throw new UnsupportedOperationException("Static conversion from " + o.getClass() + " to " + cls + " is not implemented!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T reinterpret_cast(Class<T> cls, long val) {
        assert ((val & 7L) == 0L) : "Incorrect val = " + val;
        if ((val >>= 3) == 0L) {
            return null;
        }
        if (val == -1L) {
            throw new AssertionError();
        }
        Casts.trackReinterpret_cast();
        AtomicLong atomicLong2 = counter;
        synchronized (atomicLong2) {
            Reference<Object> res = longToObjectMap.get(val);
            assert (res != null && res.get() != null) : "No " + cls + " for " + val;
            return cls.cast(res.get());
        }
    }

    public static <T> T reinterpret_cast(Class<T> cls, int val) {
        return Casts.reinterpret_cast(cls, (long)val);
    }

    public static Object reinterpret_cast_Object(Object o) {
        return o;
    }

    public static int $uint(byte c) {
        return 0xFF & c;
    }

    public static char $char(byte c) {
        return (char)(0xFF & c);
    }

    public static char $char(int c) {
        return (char)(0xFF & c);
    }

    public static char $char(char c) {
        return c;
    }

    public static char $char(long c) {
        return (char)(0xFFL & c);
    }

    public static int reinterpret_cast_int(Object obj) {
        return (int)Casts.reinterpret_cast_long(obj);
    }

    public static int reinterpret_cast_uint(Object obj) {
        return (int)Casts.reinterpret_cast_long(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long reinterpret_cast_long(Object obj) {
        if (obj == null) {
            return 0L;
        }
        new Exception(obj.getClass().getSimpleName() + " => long").printStackTrace(System.err);
        Casts.trackReinterpret_cast_long();
        AtomicLong atomicLong2 = counter;
        synchronized (atomicLong2) {
            if (objTolongMap.containsKey(obj)) {
                return objTolongMap.get(obj) << 3;
            }
            long current = counter.incrementAndGet();
            objTolongMap.put(obj, current);
            longToObjectMap.put(current, new WeakReference<Object>(obj));
            return current << 3;
        }
    }

    public static <T> type$ptr<T> reinterpret_ptr_cast(Class<T> cls, void$ptr Ptr) {
        throw new UnsupportedOperationException();
    }

    public static char$ptr reinterpret_cast_const_char$ptr(Object val) {
        assert (false) : "no conversion to char$ptr from " + val;
        return NativePointer.create_char$ptr(val.toString());
    }

    public static char$ptr reinterpret_cast_const_char$ptr(int val) {
        Casts.trackReinterpret_cast_int_bytes();
        return NativePointer.create_char$ptr(ByteUtils.intToBytes(val));
    }

    public static char$ptr reinterpret_cast_const_char$ptr(long val) {
        Casts.trackReinterpret_cast_long_bytes();
        return NativePointer.create_char$ptr(ByteUtils.longToBytes(val));
    }

    public static <T> T reinterpret_cast(Class<T> cls, Object val) {
        return (T)val;
    }

    public static <T> T reinterpret_cast(Class<T> cls, void$ptr Ptr) {
        if (Ptr == null) {
            return null;
        }
        if (cls.isAssignableFrom(Ptr.getClass())) {
            return (T)Ptr.clone();
        }
        if (Ptr instanceof void.ptr.impl) {
            return cls.cast(((void.ptr.impl)Ptr).value);
        }
        NativeMemory.MemoryPoint data = NativeMemory.unfoldMemoryPoint(NativePointer.extractMemoryPoint(Ptr));
        if (data.memory instanceof char$memory) {
            if (char$ptr.class == cls) {
                return (T)new char$ptr$heavy((char$memory)data.memory, data.byteIndex);
            }
            if (int$ptr.class == cls) {
                char$memory byteMemory = (char$memory)data.memory;
                int byteIndex = data.byteIndex;
                NativeMemory.int.char.memproj intMemory = new NativeMemory.int.char.memproj(byteMemory, byteIndex % 4);
                int intIndex = intMemory.fromByteIndex(byteIndex - intMemory.getByteShift());
                return (T)new int$ptr$heavy(intMemory, intIndex);
            }
        } else if (data.memory instanceof uint$memory) {
            if (uint$ptr.class == cls) {
                return (T)new uint$ptr$heavy((uint$memory)data.memory, data.byteIndex);
            }
            if (char$ptr.class == cls) {
                uint$memory uintMemory = (uint$memory)data.memory;
                int byteIndex = data.byteIndex;
                NativeMemory.char.uint.memproj charMemory = new NativeMemory.char.uint.memproj(uintMemory);
                int charIndex = charMemory.fromByteIndex(byteIndex - charMemory.getByteShift());
                return (T)new char$ptr$heavy(charMemory, charIndex);
            }
        }
        throw new UnsupportedOperationException("Reinterpret conversion from " + Ptr.getClass() + " to " + cls + " is not implemented!");
    }

    public static <T> T dynamic_cast(Class<T> cls, Object o) {
        if (cls.isInstance(o)) {
            return cls.cast(o);
        }
        return null;
    }

    public static <T> T const_cast(Object o) {
        return (T)o;
    }

    public static String toJavaString(char$ptr str) {
        return Casts.toCharSequence(str).toString();
    }

    public static String toJavaString(char$ptr str, int Len) {
        return Casts.toCharSequence(str, Len).toString();
    }

    public static String toJavaString(byte[] bytes, int start, int len) {
        return Casts.toCharSequence(bytes, start, len).toString();
    }

    public static CharSequence toCharSequence(byte[] bytes, int start, int len) {
        return Casts.toCharSequenceImpl(null, bytes, start, len);
    }

    public static void toStringBuilder(StringBuilder buf, byte[] bytes, int start, int len) {
        assert (buf != null);
        Casts.toCharSequenceImpl(buf, bytes, start, len);
    }

    public static CharSequence toCharSequence(char$ptr str) {
        return Casts.toCharSequence(str, -1);
    }

    public static CharSequence toCharSequence(char$ptr str, int len) {
        if (Native.$is_array_based(str)) {
            return Casts.toCharSequenceImpl((StringBuilder)null, str.$array(), str.$index(), len);
        }
        if (str instanceof char$ptr$CharSequence) {
            return Casts.toCharSequenceImpl((StringBuilder)null, ((char$ptr$CharSequence)str).getCharSequence(), str.$index(), len);
        }
        StringBuilder buf = new StringBuilder(16);
        return Casts.toCharSequenceNonArrayBasedAsciiPtr(buf, str, len);
    }

    public static void toStringBuilder(StringBuilder buf, char$ptr str) {
        assert (buf != null);
        Casts.toStringBuilderImpl(buf, str, -1);
    }

    public static void toStringBuilder(StringBuilder buf, char$ptr str, int len) {
        assert (buf != null);
        Casts.toStringBuilderImpl(buf, str, len);
    }

    private static void toStringBuilderImpl(StringBuilder buf, char$ptr str, int len) {
        if (Native.$is_array_based(str)) {
            Casts.toCharSequenceImpl(buf, str.$array(), str.$index(), len);
            return;
        }
        if (str instanceof char$ptr$CharSequence) {
            Casts.toCharSequenceImpl(buf, ((char$ptr$CharSequence)str).getCharSequence(), str.$index(), len);
            return;
        }
        Casts.toCharSequenceNonArrayBasedAsciiPtr(buf, str, len);
    }

    private static CharSequence toCharSequenceImpl(StringBuilder buf, CharSequence text, int start, int len) {
        CharSequence out;
        int textLen = text.length();
        len = len < 0 ? textLen - start : len;
        CharSequence charSequence = out = start == 0 && len == textLen ? text : text.subSequence(start, start + len);
        if (buf == null) {
            return out;
        }
        buf.append(out);
        return buf;
    }

    private static CharSequence toCharSequenceImpl(StringBuilder buf, byte[] bytes, int start, int len) {
        try {
            len = len < 0 ? std.strlen(bytes, start) : len;
            CharSequence out = UTF_8.decode(bytes, start, len);
            if (buf != null) {
                buf.append(out);
                return buf;
            }
            return out;
        }
        catch (Exception e) {
            if (buf == null) {
                buf = new StringBuilder(16);
            }
            return Casts.toCharSequenceNonArrayBasedAsciiPtr(buf, NativePointer.create_char$ptr(bytes, start), len);
        }
    }

    private static StringBuilder toCharSequenceNonArrayBasedAsciiPtr(StringBuilder buf, char$ptr str, int len) {
        assert (buf != null);
        if (str == null) {
            buf.append("<null>");
            return buf;
        }
        int idx = 0;
        if (len < 0) {
            try {
                char c;
                while ((c = Casts.$char(str.$at(idx++))) != '\u0000') {
                    buf.append(c);
                }
            }
            catch (Exception e) {
                buf.replace(buf.length() - idx + 1, buf.length(), "###Corrupted IDX=" + str.$index() + "###");
            }
        } else {
            while (len-- > 0) {
                buf.append(Casts.$char(str.$at(idx++)));
            }
        }
        return buf;
    }

    private static void trackReinterpret_cast_long() {
        ++callReinterpret_cast_long;
    }

    private static void trackReinterpret_cast_long_bytes() {
        ++callReinterpret_cast_long_bytes;
    }

    private static void trackReinterpret_cast_int_bytes() {
        ++callReinterpret_cast_int_bytes;
    }

    private static void trackReinterpret_cast() {
        ++callReinterpret_cast;
    }

    public static void clearStatistics() {
        callReinterpret_cast = 0L;
        callReinterpret_cast_long = 0L;
        callReinterpret_cast_long_bytes = 0L;
        callReinterpret_cast_int_bytes = 0L;
    }

    public static long printStatistics(PrintWriter out) {
        out.printf("%22s  called:\t%s.%n", "Cast [Object->long]", NativeTrace.formatNumber(callReinterpret_cast_long));
        out.printf("%22s  called:\t%s.%n", "Cast [long->Object]", NativeTrace.formatNumber(callReinterpret_cast));
        out.printf("%22s  called:\t%s.%n", "Cast [long->byte[]]", NativeTrace.formatNumber(callReinterpret_cast_long_bytes));
        out.printf("%22s  called:\t%s.%n", "Cast [int->byte[]]", NativeTrace.formatNumber(callReinterpret_cast_int_bytes));
        long Value = callReinterpret_cast_long + callReinterpret_cast + callReinterpret_cast_long_bytes + callReinterpret_cast_int_bytes;
        NativeTrace.dumpStatisticValue(out, "TotalLibStdCastsValue", Value);
        return Value;
    }
}

