/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.doxygensupport;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.spi.editor.completion.CompletionDocumentation;

public class DoxygenDocumentation {
    private static final Pattern STRIP_STARS = Pattern.compile("^[ \t]*\\*[ \t]?", 8);
    private static final String[] formatItalic = new String[]{"<i>", "</i>"};
    private static final Map<String, CommandDescription> commands = new HashMap<String, CommandDescription>();

    static String doxygen2HTML(String doxygen, CppTokenId kind) {
        switch (kind) {
            case LINE_COMMENT: {
                doxygen = doxygen.substring(2);
                break;
            }
            case DOXYGEN_LINE_COMMENT: {
                doxygen = doxygen.substring(3);
                break;
            }
            case DOXYGEN_COMMENT: {
                doxygen = doxygen.substring(3, doxygen.length() - 2);
                break;
            }
            case BLOCK_COMMENT: {
                doxygen = doxygen.substring(2, doxygen.length() - 2);
            }
        }
        doxygen = STRIP_STARS.matcher(doxygen).replaceAll("");
        doxygen = doxygen.trim();
        if (kind == CppTokenId.BLOCK_COMMENT) {
            doxygen = "\\verbatim\n" + doxygen + "\n\\endverbatim";
        }
        StringBuilder output = new StringBuilder();
        LinkedList<String> wordEnd = new LinkedList<String>();
        LinkedList<String> lineEnd = new LinkedList<String>();
        LinkedList<String> parEnd = new LinkedList<String>();
        String[] nextWordFormat = null;
        for (Token t : DoxygenDocumentation.lex(doxygen)) {
            switch (t.id) {
                case WHITESPACE: {
                    output.append(t.image);
                    break;
                }
                case WORD: {
                    if (nextWordFormat != null) {
                        output.append((String)nextWordFormat[0]);
                    }
                    output.append(t.image);
                    for (String s : wordEnd) {
                        output.append(s);
                    }
                    wordEnd.clear();
                    if (nextWordFormat != null) {
                        output.append((String)nextWordFormat[1]);
                    }
                    nextWordFormat = null;
                    break;
                }
                case LINE_END: {
                    for (String s : wordEnd) {
                        output.append(s);
                    }
                    wordEnd.clear();
                    for (String s : lineEnd) {
                        output.append(s);
                    }
                    lineEnd.clear();
                    output.append(t.image);
                    output.append("</p><p>\n");
                    break;
                }
                case PAR_END: {
                    for (String s : wordEnd) {
                        output.append(s);
                    }
                    wordEnd.clear();
                    for (String s : lineEnd) {
                        output.append(s);
                    }
                    for (String s : parEnd) {
                        output.append(s);
                    }
                    lineEnd.clear();
                    parEnd.clear();
                    output.append("</p><p>\n");
                    break;
                }
                case COMMAND: {
                    CommandDescription cd = commands.get(t.image);
                    if (cd == null) {
                        cd = new CommandDescription(EndsOn.PAR, "<strong>" + t.image.substring(1) + ":</strong><br>&nbsp; ", "");
                    }
                    output.append(cd.htmlStart);
                    switch (cd.end) {
                        case WORD: {
                            wordEnd.add(cd.htmlEnd);
                            break;
                        }
                        case LINE: {
                            lineEnd.add(cd.htmlEnd);
                            break;
                        }
                        case PAR: {
                            parEnd.add(cd.htmlEnd);
                        }
                    }
                    if (!t.image.equals("\\param")) break;
                    nextWordFormat = formatItalic;
                }
            }
        }
        return "<p>" + output.toString() + "</p>";
    }

    public static CompletionDocumentationImpl create(CsmObject csmObject) {
        CsmFunction fun;
        CsmFunctionDefinition definition;
        if (!(csmObject instanceof CsmOffsetable)) {
            return null;
        }
        ArrayList<DocCandidate> list = new ArrayList<DocCandidate>();
        DoxygenDocumentation.getDocText(csmObject, list);
        if ((list.isEmpty() || DoxygenDocumentation.getBestDoc(list).kind != CppTokenId.DOXYGEN_COMMENT) && CsmKindUtilities.isFunctionDeclaration((CsmObject)csmObject) && (definition = (fun = (CsmFunction)csmObject).getDefinition()) != null && !definition.equals(fun)) {
            DoxygenDocumentation.getDocText((CsmObject)definition, list);
        }
        if (list.isEmpty()) {
            return null;
        }
        DocCandidate bestDoc = DoxygenDocumentation.getBestDoc(list);
        String htmlDocText = DoxygenDocumentation.doxygen2HTML(bestDoc.text, bestDoc.kind);
        return new CompletionDocumentationImpl(htmlDocText, bestDoc.kind);
    }

    private static DocCandidate getBestDoc(List<DocCandidate> list) {
        DocCandidate candidate = null;
        for (DocCandidate doc : list) {
            switch (doc.kind) {
                case DOXYGEN_LINE_COMMENT: 
                case DOXYGEN_COMMENT: {
                    return doc;
                }
                case LINE_COMMENT: 
                case BLOCK_COMMENT: {
                    if (candidate != null) break;
                    candidate = doc;
                }
            }
        }
        return candidate;
    }

    /*
     * Unable to fully structure code
     */
    private static void getDocText(CsmObject csmObject, List<DocCandidate> list) {
        csmOffsetable = (CsmOffsetable)csmObject;
        containingFile = csmOffsetable.getContainingFile();
        if (containingFile == null) {
            return;
        }
        h = TokenHierarchy.create((CharSequence)containingFile.getText(), (Language)CppTokenId.languageHeader());
        ts = h.tokenSequence(CppTokenId.languageHeader());
        ts.move(csmOffsetable.getStartOffset());
        newLineOccured = false;
        block30: while (ts.movePrevious()) {
            switch (1.$SwitchMap$org$netbeans$cnd$api$lexer$CppTokenId[((CppTokenId)ts.token().id()).ordinal()]) {
                case 6: {
                    if (newLineOccured) break block30;
                    newLineOccured = true;
                    continue block30;
                }
                case 1: 
                case 2: {
                    stack = new LinkedList<String>();
                    id = (CppTokenId)ts.token().id();
                    if (id == CppTokenId.LINE_COMMENT) {
                        stack.addFirst(ts.token().text().toString().substring(2));
                    } else {
                        stack.addFirst(ts.token().text().toString().substring(3));
                    }
                    addDoc = true;
                    newLine = 0;
                    block31: while (ts.movePrevious()) {
                        switch (1.$SwitchMap$org$netbeans$cnd$api$lexer$CppTokenId[((CppTokenId)ts.token().id()).ordinal()]) {
                            case 5: {
                                continue block31;
                            }
                            case 6: {
                                if (newLine > 0) break block31;
                                ++newLine;
                                continue block31;
                            }
                            case 1: {
                                stack.addFirst(ts.token().text().toString().substring(2));
                                newLine = 0;
                                continue block31;
                            }
                            case 2: {
                                stack.addFirst(ts.token().text().toString().substring(3));
                                newLine = 0;
                                continue block31;
                            }
                            default: {
                                addDoc = newLine > 0;
                                break block31;
                            }
                        }
                    }
                    if (!addDoc) break block30;
                    buf = new StringBuilder();
                    if (id == CppTokenId.LINE_COMMENT) {
                        buf.append("//");
                    } else {
                        buf.append("///");
                    }
                    iterator = stack.iterator();
                    first = true;
                    while (iterator.hasNext()) {
                        if (!first) {
                            buf.append('\n');
                        }
                        buf.append((String)iterator.next());
                        first = false;
                    }
                    docCandidate = new DocCandidate(buf.toString(), id);
                    list.add(docCandidate);
                    break block30;
                }
                case 3: 
                case 4: {
                    docCandidate = new DocCandidate(ts.token().text().toString(), (CppTokenId)ts.token().id());
                    addDoc = true;
                    block33: while (ts.movePrevious()) {
                        switch (1.$SwitchMap$org$netbeans$cnd$api$lexer$CppTokenId[((CppTokenId)ts.token().id()).ordinal()]) {
                            case 5: {
                                continue block33;
                            }
                            case 6: 
                            case 7: {
                                break block33;
                            }
                            default: {
                                addDoc = false;
                                break block33;
                            }
                        }
                    }
                    if (!addDoc) break block30;
                    list.add(docCandidate);
                    break block30;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break block30;
                }
                default: {
                    continue block30;
                }
            }
        }
        ts2 = ts;
        ts2.move(csmOffsetable.getEndOffset());
        block34: while (ts2.moveNext()) {
            switch (1.$SwitchMap$org$netbeans$cnd$api$lexer$CppTokenId[((CppTokenId)ts2.token().id()).ordinal()]) {
                case 6: {
                    break block34;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    list.add(new DocCandidate(ts2.token().text().toString(), (CppTokenId)ts2.token().id()));
                    break block34;
                }
                case 7: {
                    ts2 = ts2.embedded(CppTokenId.languagePreproc());
                    if (!(csmOffsetable instanceof CsmMacro)) ** GOTO lbl107
                    ts2.move(csmOffsetable.getEndOffset());
                    ts2.movePrevious();
                    ts2.movePrevious();
                    ** GOTO lbl115
lbl107:
                    // 1 sources

                    ts2.move(csmOffsetable.getStartOffset());
                    ts2.moveNext();
                    switch (1.$SwitchMap$org$netbeans$cnd$api$lexer$CppTokenId[((CppTokenId)ts2.token().id()).ordinal()]) {
                        case 3: 
                        case 4: {
                            list.add(new DocCandidate(ts2.token().text().toString(), (CppTokenId)ts2.token().id()));
                        }
                    }
                }
lbl115:
                // 4 sources

                default: {
                    continue block34;
                }
            }
        }
        if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
            ts.move(csmOffsetable.getStartOffset());
            block35: while (ts.moveNext()) {
                switch (1.$SwitchMap$org$netbeans$cnd$api$lexer$CppTokenId[((CppTokenId)ts.token().id()).ordinal()]) {
                    case 5: 
                    case 6: {
                        continue block35;
                    }
                    case 1: 
                    case 4: {
                        list.add(new DocCandidate(ts.token().text().toString(), (CppTokenId)ts.token().id()));
                        continue block35;
                    }
                    case 3: {
                        list.add(new DocCandidate(ts.token().text().toString(), (CppTokenId)ts.token().id()));
                        break block35;
                    }
                    case 10: {
                        break block35;
                    }
                    default: {
                        continue block35;
                    }
                }
            }
        }
    }

    static Collection<Token> lex(String text) {
        LinkedList<Token> result = new LinkedList<Token>();
        StringBuilder img = new StringBuilder();
        int i = 0;
        boolean wasContent = true;
        boolean verbatimMode = false;
        boolean codeMode = false;
        boolean escapedCommand = false;
        block21: while (i < text.length()) {
            switch (text.charAt(i)) {
                case '\n': {
                    if (i < text.length() - 1) {
                        if (!verbatimMode && !codeMode) {
                            while (i < text.length() - 1 && (text.charAt(i + 1) == ' ' || text.charAt(i + 1) == '\t')) {
                                ++i;
                            }
                        }
                        if (text.charAt(i + 1) == '@' || text.charAt(i + 1) == '\\' || text.charAt(i + 1) == '\n') {
                            Token last = result.getLast();
                            if (last.id != TokenId.LINE_END && last.id != TokenId.PAR_END) {
                                result.add(new Token(wasContent ? TokenId.LINE_END : TokenId.PAR_END, "\n"));
                                wasContent = false;
                            }
                        } else if (!verbatimMode && !codeMode) {
                            result.add(new Token(TokenId.WHITESPACE, " "));
                            wasContent = false;
                        }
                    }
                    ++i;
                    continue block21;
                }
                case '\t': 
                case ' ': {
                    img.append(text.charAt(i++));
                    while (i < text.length() && (text.charAt(i) == ' ' || text.charAt(i) == '\t')) {
                        img.append(text.charAt(i++));
                    }
                    result.add(new Token(TokenId.WHITESPACE, img.toString()));
                    img = new StringBuilder();
                    continue block21;
                }
                case '@': 
                case '\\': {
                    if (escapedCommand) {
                        escapedCommand = false;
                        img.append(text.charAt(i));
                        ++i;
                        continue block21;
                    }
                    boolean escaped = false;
                    if (text.charAt(i) == '\\' && i + 1 < text.length()) {
                        switch (text.charAt(i + 1)) {
                            case '\\': {
                                escaped = true;
                                escapedCommand = true;
                                ++i;
                                break;
                            }
                            case '@': {
                                escaped = true;
                                escapedCommand = true;
                                ++i;
                                break;
                            }
                            case '\"': {
                                ++i;
                                img.append("&quot;");
                                escaped = true;
                                break;
                            }
                            case '&': {
                                ++i;
                                img.append("&amp;");
                                escaped = true;
                                break;
                            }
                            case '<': {
                                ++i;
                                img.append("&lt;");
                                escaped = true;
                                break;
                            }
                            case '>': {
                                ++i;
                                img.append("&gt;");
                                escaped = true;
                                break;
                            }
                            case '#': 
                            case '$': 
                            case '%': {
                                img.append(text.charAt(++i));
                                escaped = true;
                                break;
                            }
                            case ':': {
                                if (i + 2 >= text.length() || text.charAt(i + 2) != ':') break;
                                i += 3;
                                img.append("::");
                                escaped = true;
                            }
                        }
                        if (escaped) {
                            wasContent = true;
                            continue block21;
                        }
                    }
                    img.append('\\');
                    ++i;
                    while (i < text.length() && Character.isLetter(text.charAt(i))) {
                        img.append(text.charAt(i++));
                    }
                    if (img.toString().equals("\\verbatim")) {
                        verbatimMode = true;
                    } else if (img.toString().equals("\\code")) {
                        codeMode = true;
                    }
                    if (verbatimMode && img.toString().equals("\\endverbatim")) {
                        verbatimMode = false;
                    } else if (codeMode && img.toString().equals("\\endcode")) {
                        codeMode = false;
                    }
                    result.add(new Token(TokenId.COMMAND, img.toString()));
                    img = new StringBuilder();
                    wasContent = true;
                    continue block21;
                }
            }
            img.append(text.charAt(i++));
            while (i < text.length()) {
                char c = text.charAt(i);
                if (!verbatimMode && !codeMode && (c == ' ' || c == '\t' || c == '\n') || c == '\\' || c == '@') break;
                if (verbatimMode || codeMode) {
                    switch (c) {
                        case '&': {
                            img.append("&amp;");
                            break;
                        }
                        case '<': {
                            img.append("&lt;");
                            break;
                        }
                        case '>': {
                            img.append("&gt;");
                            break;
                        }
                        case '\"': {
                            img.append("&quot;");
                            break;
                        }
                        default: {
                            img.append(c);
                            break;
                        }
                    }
                } else {
                    img.append(c);
                }
                ++i;
            }
            result.add(new Token(TokenId.WORD, img.toString()));
            img = new StringBuilder();
            wasContent = true;
        }
        return result;
    }

    static {
        commands.put("\\c", new CommandDescription(EndsOn.WORD, "<tt>", "</tt>"));
        commands.put("\\p", new CommandDescription(EndsOn.WORD, "<tt>", "</tt>"));
        commands.put("\\a", new CommandDescription(EndsOn.WORD, "<i>", "</i>"));
        commands.put("\\n", new CommandDescription(EndsOn.NONE, "<br/>", ""));
        commands.put("\\author", new CommandDescription(EndsOn.PAR, "<strong>Author:</strong><br>&nbsp; ", ""));
        commands.put("\\exception", new CommandDescription(EndsOn.PAR, "<strong>Exceptions:</strong><br>&nbsp; ", ""));
        commands.put("\\throw", new CommandDescription(EndsOn.PAR, "<strong>Throws:</strong><br>&nbsp; ", ""));
        commands.put("\\return", new CommandDescription(EndsOn.PAR, "<strong>Returns:</strong><br>&nbsp; ", ""));
        commands.put("\\param", new CommandDescription(EndsOn.PAR, "<strong>Parameter:</strong><br>&nbsp; ", ""));
        commands.put("\\sa", new CommandDescription(EndsOn.PAR, "<strong>See Also:</strong><br>&nbsp; ", ""));
        commands.put("\\verbatim", new CommandDescription(EndsOn.NONE, "<pre>", ""));
        commands.put("\\endverbatim", new CommandDescription(EndsOn.NONE, "</pre>", ""));
        commands.put("\\code", new CommandDescription(EndsOn.NONE, "<pre>", ""));
        commands.put("\\endcode", new CommandDescription(EndsOn.NONE, "</pre>", ""));
        commands.put("\\brief", new CommandDescription(EndsOn.PAR, "", ""));
        commands.put("\\date", new CommandDescription(EndsOn.PAR, "<strong>Date:</strong><br>&nbsp; ", ""));
        commands.put("\\bug", new CommandDescription(EndsOn.PAR, "<strong>Bug:</strong><br>&nbsp; ", ""));
        commands.put("\\warning", new CommandDescription(EndsOn.PAR, "<strong>Warning:</strong><br>&nbsp; ", ""));
        commands.put("\\version", new CommandDescription(EndsOn.PAR, "<strong>Version:</strong><br>&nbsp; ", ""));
    }

    private static final class DocCandidate {
        private final String text;
        private final CppTokenId kind;

        public DocCandidate(String text, CppTokenId kind) {
            this.text = text;
            this.kind = kind;
        }
    }

    public static final class CompletionDocumentationImpl
    implements CompletionDocumentation {
        private final String text;
        private final CppTokenId kind;

        public CompletionDocumentationImpl(String text, CppTokenId kind) {
            this.kind = kind;
            this.text = text;
        }

        public CppTokenId getKind() {
            return this.kind;
        }

        public String getText() {
            return this.text;
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    static enum TokenId {
        COMMAND,
        WHITESPACE,
        PAR_END,
        LINE_END,
        WORD;

    }

    static class Token {
        final TokenId id;
        final String image;

        public Token(TokenId id, String image) {
            this.id = id;
            this.image = image;
        }

        public String toString() {
            return (Object)((Object)this.id) + ":" + this.image;
        }
    }

    static enum EndsOn {
        WORD,
        LINE,
        PAR,
        NONE;

    }

    static final class CommandDescription {
        final EndsOn end;
        final String htmlStart;
        final String htmlEnd;

        public CommandDescription(EndsOn end, String htmlStart, String htmlEnd) {
            this.end = end;
            this.htmlStart = htmlStart;
            this.htmlEnd = htmlEnd;
        }
    }
}

