/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java.support;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.saas.model.WadlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlServiceProxyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class LibrariesHelper {
    public static final String PATH_LIBRARIES = "lib";
    public static final String WEBSERVICE_CLIENTS_SUB_DIR = "webservice_clients";

    public static void addDefaultJaxWsClientJars(Project project, FileObject targetSource, WsdlSaas saas) {
        List<String> jarPaths = LibrariesHelper.getDefaultJaxWsClientJars(saas, "proxy");
        LibrariesHelper.addArchiveRefsToProject(project, targetSource, jarPaths, "classpath/compile");
    }

    public static void addDefaultJaxRpcClientJars(Project project, FileObject targetSource, WsdlSaas saas) {
        List<String> jarPaths = LibrariesHelper.getDefaultJaxRpcClientJars(saas, "proxy");
        LibrariesHelper.addArchiveRefsToProject(project, targetSource, jarPaths, "classpath/compile");
    }

    public static void addClientJars(Project project, FileObject targetSource, WadlSaas saas) {
        LibrariesHelper.addArchivesToProject(project, targetSource, saas.getLibraryJars(), "classpath/compile");
    }

    public static void addArchiveRefsToProject(Project project, FileObject targetSource, List<String> jars) {
        LibrariesHelper.addArchiveRefsToProject(project, targetSource, jars, "classpath/compile");
    }

    public static void addArchiveRefsToProject(Project project, FileObject targetSource, List<String> jars, String classPathType) {
        ArrayList<FileObject> jarFiles = new ArrayList<FileObject>();
        for (String jarPath : jars) {
            FileObject jarFO = FileUtil.toFileObject((File)new File(jarPath));
            if (jarFO == null) continue;
            jarFiles.add(jarFO);
        }
        LibrariesHelper.addArchivesToProject(project, targetSource, jarFiles, classPathType);
    }

    public static void addArchivesToProject(Project project, FileObject targetSource, List<FileObject> jars) {
        LibrariesHelper.addArchivesToProject(project, targetSource, jars, "classpath/compile");
    }

    public static void addArchivesToProject(Project project, FileObject targetSource, List<FileObject> jars, String classPathType) {
        ClassPath classPath;
        if (targetSource == null) {
            targetSource = LibrariesHelper.getSourceRoot(project);
        }
        if ((classPath = ClassPath.getClassPath((FileObject)targetSource, (String)classPathType)) != null) {
            try {
                FileObject wsClientsSubDir = LibrariesHelper.getWebServiceClientLibraryDir(project);
                ArrayList<URL> archiveJars = new ArrayList<URL>();
                for (FileObject jarFO : jars) {
                    try {
                        FileObject destJar = wsClientsSubDir.getFileObject(jarFO.getNameExt());
                        if (destJar == null) {
                            destJar = FileUtil.copyFile((FileObject)jarFO, (FileObject)wsClientsSubDir, (String)jarFO.getName());
                        }
                        if (classPath.contains(destJar)) continue;
                        archiveJars.add(new URL(destJar.getURL().toExternalForm() + "/"));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    URL[] archiveURLs = archiveJars.toArray(new URL[archiveJars.size()]);
                    ProjectClassPathModifier.addRoots((URL[])archiveURLs, (FileObject)targetSource, (String)classPathType);
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    public static FileObject getProjectLibraryDirectory(Project project) throws IOException {
        FileObject projRoot = project.getProjectDirectory();
        FileObject libRoot = projRoot.getFileObject(PATH_LIBRARIES);
        if (libRoot == null) {
            libRoot = FileUtil.createFolder((FileObject)projRoot, (String)PATH_LIBRARIES);
        }
        return libRoot;
    }

    public static FileObject getWebServiceClientLibraryDir(Project project) throws IOException {
        FileObject projectLibDir = LibrariesHelper.getProjectLibraryDirectory(project);
        FileObject wsClientsSubDir = projectLibDir.getFileObject(WEBSERVICE_CLIENTS_SUB_DIR);
        if (wsClientsSubDir == null) {
            wsClientsSubDir = projectLibDir.createFolder(WEBSERVICE_CLIENTS_SUB_DIR);
        }
        return wsClientsSubDir;
    }

    public static List<String> getDefaultJaxWsClientJars(WsdlSaas saas, String jarType) {
        WsdlData data = saas.getWsdlData();
        ArrayList<String> jarPaths = new ArrayList<String>();
        File basePath = data.getJaxWsDescriptor().getXmlDescriptorFile().getParentFile();
        for (WsdlServiceProxyDescriptor.JarEntry jar : data.getJaxWsDescriptor().getJars()) {
            if (!jar.getType().equals(jarType)) continue;
            File jarPath = new File(basePath, jar.getName());
            jarPaths.add(jarPath.getAbsolutePath());
        }
        return jarPaths;
    }

    public static List<String> getDefaultJaxRpcClientJars(WsdlSaas saas, String jarType) {
        WsdlData data = saas.getWsdlData();
        ArrayList<String> jarPaths = new ArrayList<String>();
        File basePath = data.getJaxRpcDescriptor().getXmlDescriptorFile().getParentFile();
        for (WsdlServiceProxyDescriptor.JarEntry jar : data.getJaxRpcDescriptor().getJars()) {
            if (!jar.getType().equals(jarType)) continue;
            File jarPath = new File(basePath, jar.getName());
            jarPaths.add(jarPath.getAbsolutePath());
        }
        return jarPaths;
    }

    public static FileObject getSourceRoot(Project project) {
        if (project == null) {
            return null;
        }
        Sources src = ProjectUtils.getSources((Project)project);
        SourceGroup[] grp = src.getSourceGroups("java");
        for (int i = 0; i < grp.length; ++i) {
            if (!"${src.dir}".equals(grp[i].getName())) continue;
            return grp[i].getRootFolder();
        }
        if (grp.length != 0) {
            return grp[0].getRootFolder();
        }
        return null;
    }
}

