/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.completion.delegate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.cnd.refactoring.completion.delegate.PopupDelegateCompletionItem;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class PopupDelegateCompletionProvider
implements CompletionProvider {
    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if ((queryType & 1) != 0) {
            int dot = component.getCaret().getDot();
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(dot, component), component);
        }
        return null;
    }

    private static final class Query
    extends AsyncCompletionQuery {
        private final int creationCaretOffset;
        private final JTextComponent component;
        private Collection<CompletionItem> results;
        private int queryAnchorOffset;
        private String filterPrefix;

        Query(int caretOffset, JTextComponent component) {
            this.creationCaretOffset = caretOffset;
            this.queryAnchorOffset = -1;
            this.component = component;
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            Collection<CompletionItem> items = this.getItems((BaseDocument)doc, caretOffset);
            if (this.queryAnchorOffset >= 0) {
                if (items != null && items.size() > 0) {
                    this.results = items;
                    items = this.getFilteredData(items, this.filterPrefix);
                    resultSet.estimateItems(items.size(), -1);
                    resultSet.addAllItems(items);
                    resultSet.setAnchorOffset(this.queryAnchorOffset);
                }
                resultSet.setHasAdditionalItems(false);
            }
            resultSet.finish();
        }

        protected boolean canFilter(JTextComponent component) {
            int caretOffset = component.getCaretPosition();
            this.filterPrefix = null;
            if (this.queryAnchorOffset > -1 && caretOffset >= this.queryAnchorOffset) {
                Document doc = component.getDocument();
                try {
                    this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                }
                catch (BadLocationException ex) {
                    Completion.get().hideCompletion();
                }
            } else {
                Completion.get().hideCompletion();
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet resultSet) {
            if (this.filterPrefix != null && this.results != null) {
                resultSet.setAnchorOffset(this.queryAnchorOffset);
                Collection<CompletionItem> items = this.getFilteredData(this.results, this.filterPrefix);
                resultSet.estimateItems(items.size(), -1);
                resultSet.addAllItems(items);
            }
            resultSet.setHasAdditionalItems(false);
            resultSet.finish();
        }

        private Collection<CompletionItem> getItems(BaseDocument doc, int caretOffset) {
            PopupDelegateCompletionItem item;
            List<CsmObject> path;
            CsmObject last;
            CsmClass enclosingClass;
            CsmContext context;
            ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
            if (this.init(doc, caretOffset) && (context = CsmContext.create((Document)doc, caretOffset, caretOffset, caretOffset)) != null && (enclosingClass = context.getEnclosingClass()) != null && (CsmKindUtilities.isClass((CsmObject)(last = (path = context.getPath()).get(path.size() - 1))) || CsmKindUtilities.isField((CsmObject)last)) && (item = PopupDelegateCompletionItem.createImplementItem(caretOffset, this.component)) != null) {
                items.add(item);
            }
            return items;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean init(BaseDocument doc, int caretOffset) {
            this.filterPrefix = "";
            this.queryAnchorOffset = caretOffset;
            if (doc != null) {
                doc.readLock();
                try {
                    TokenId id;
                    TokenItem tok = CndTokenUtilities.getTokenCheckPrev((Document)doc, (int)caretOffset);
                    if (tok != null && (id = tok.id()) instanceof CppTokenId && !"whitespace".equals(id.primaryCategory())) {
                        this.queryAnchorOffset = tok.offset();
                        this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    doc.readUnlock();
                }
            }
            return this.queryAnchorOffset >= 0;
        }

        private Collection<CompletionItem> getFilteredData(Collection<CompletionItem> data, String prefix) {
            if (prefix == null || prefix.isEmpty()) {
                return data;
            }
            return Collections.emptyList();
        }
    }
}

