/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file DocSum_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'esummary.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef esummary__OBJTOOLS_EUTILS_ESUMMARY_DOCSUM_BASE_HPP
#define esummary__OBJTOOLS_EUTILS_ESUMMARY_DOCSUM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_esummary_SCOPE
#  define BEGIN_esummary_SCOPE BEGIN_SCOPE(esummary)
#  define END_esummary_SCOPE END_SCOPE(esummary)
#endif
BEGIN_esummary_SCOPE // namespace esummary::


// forward declarations
class CItem;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CDocSum_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CDocSum_Base(void);
    // destructor
    virtual ~CDocSum_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::string TId;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CItem > > TItem;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Id,
        e_Item
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// \d+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(const TId& value);
    void SetId(TId&& value);
    TId& SetId(void);

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CItem > > TItem
    ///  Check whether the Item data member has been assigned a value.
    bool IsSetItem(void) const;
    /// Check whether it is safe or not to call GetItem method.
    bool CanGetItem(void) const;
    void ResetItem(void);
    const TItem& GetItem(void) const;
    TItem& SetItem(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CDocSum_Base(const CDocSum_Base&);
    CDocSum_Base& operator=(const CDocSum_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::string m_Id;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CItem > > m_Item;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CDocSum_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CDocSum_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
const CDocSum_Base::TId& CDocSum_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CDocSum_Base::SetId(const CDocSum_Base::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CDocSum_Base::SetId(CDocSum_Base::TId&& value)
{
    m_Id = std::forward<CDocSum_Base::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CDocSum_Base::TId& CDocSum_Base::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CDocSum_Base::IsSetItem(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CDocSum_Base::CanGetItem(void) const
{
    return true;
}

inline
const CDocSum_Base::TItem& CDocSum_Base::GetItem(void) const
{
    return m_Item;
}

inline
CDocSum_Base::TItem& CDocSum_Base::SetItem(void)
{
    m_set_State[0] |= 0x4;
    return m_Item;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_esummary_SCOPE // namespace esummary::


#endif // esummary__OBJTOOLS_EUTILS_ESUMMARY_DOCSUM_BASE_HPP
