/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PubMedPubDate_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_PUBMEDPUBDATE_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_PUBMEDPUBDATE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CDay;
class CHour;
class CMinute;
class CMonth;
class CSecond;
class CYear;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CPubMedPubDate_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CPubMedPubDate_Base(void);
    // destructor
    virtual ~CPubMedPubDate_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_PubStatus {
            eAttlist_PubStatus_received     =  1,
            eAttlist_PubStatus_accepted     =  2,
            eAttlist_PubStatus_epublish     =  3,
            eAttlist_PubStatus_ppublish     =  4,
            eAttlist_PubStatus_revised      =  5,
            eAttlist_PubStatus_aheadofprint =  6,
            eAttlist_PubStatus_retracted    =  7,
            eAttlist_PubStatus_ecollection  =  8,
            eAttlist_PubStatus_pmc          =  9,
            eAttlist_PubStatus_pmcr         = 10,
            eAttlist_PubStatus_pubmed       = 11,
            eAttlist_PubStatus_pubmedr      = 12,
            eAttlist_PubStatus_premedline   = 13,
            eAttlist_PubStatus_medline      = 14,
            eAttlist_PubStatus_medliner     = 15,
            eAttlist_PubStatus_entrez       = 16,
            eAttlist_PubStatus_pmc_release  = 17
        };
        
        /// Access to EAttlist_PubStatus's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_PubStatus)(void);
        
        // types
        typedef EAttlist_PubStatus TPubStatus;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_PubStatus
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef EAttlist_PubStatus TPubStatus
        ///  Check whether the PubStatus data member has been assigned a value.
        bool IsSetPubStatus(void) const;
        /// Check whether it is safe or not to call GetPubStatus method.
        bool CanGetPubStatus(void) const;
        void ResetPubStatus(void);
        TPubStatus GetPubStatus(void) const;
        void SetPubStatus(TPubStatus value);
        TPubStatus& SetPubStatus(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_PubStatus m_PubStatus;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_HM : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_HM(void);
        // destructor
        ~C_HM(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class C_MS : public NCBI_NS_NCBI::CSerialObject
        {
            typedef NCBI_NS_NCBI::CSerialObject Tparent;
        public:
            // constructor
            C_MS(void);
            // destructor
            ~C_MS(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef CMinute TMinute;
            typedef CSecond TSecond;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_Minute,
                e_Second
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            /// mandatory
            /// typedef CMinute TMinute
            ///  Check whether the Minute data member has been assigned a value.
            bool IsSetMinute(void) const;
            /// Check whether it is safe or not to call GetMinute method.
            bool CanGetMinute(void) const;
            void ResetMinute(void);
            const TMinute& GetMinute(void) const;
            void SetMinute(TMinute& value);
            TMinute& SetMinute(void);
        
            /// optional
            /// typedef CSecond TSecond
            ///  Check whether the Second data member has been assigned a value.
            bool IsSetSecond(void) const;
            /// Check whether it is safe or not to call GetSecond method.
            bool CanGetSecond(void) const;
            void ResetSecond(void);
            const TSecond& GetSecond(void) const;
            void SetSecond(TSecond& value);
            TSecond& SetSecond(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_MS(const C_MS&);
            C_MS& operator=(const C_MS&);
        
            // data
            Uint4 m_set_State[1];
            NCBI_NS_NCBI::CRef< TMinute > m_Minute;
            NCBI_NS_NCBI::CRef< TSecond > m_Second;
        };
        // types
        typedef CHour THour;
        typedef C_MS TMS;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_Hour,
            e_MS
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef CHour THour
        ///  Check whether the Hour data member has been assigned a value.
        bool IsSetHour(void) const;
        /// Check whether it is safe or not to call GetHour method.
        bool CanGetHour(void) const;
        void ResetHour(void);
        const THour& GetHour(void) const;
        void SetHour(THour& value);
        THour& SetHour(void);
    
        /// optional
        /// typedef C_MS TMS
        ///  Check whether the MS data member has been assigned a value.
        bool IsSetMS(void) const;
        /// Check whether it is safe or not to call GetMS method.
        bool CanGetMS(void) const;
        void ResetMS(void);
        const TMS& GetMS(void) const;
        void SetMS(TMS& value);
        TMS& SetMS(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_HM(const C_HM&);
        C_HM& operator=(const C_HM&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_NCBI::CRef< THour > m_Hour;
        NCBI_NS_NCBI::CRef< TMS > m_MS;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef CYear TYear;
    typedef CMonth TMonth;
    typedef CDay TDay;
    typedef C_HM THM;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_Year,
        e_Month,
        e_Day,
        e_HM
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef CYear TYear
    ///  Check whether the Year data member has been assigned a value.
    bool IsSetYear(void) const;
    /// Check whether it is safe or not to call GetYear method.
    bool CanGetYear(void) const;
    void ResetYear(void);
    const TYear& GetYear(void) const;
    void SetYear(TYear& value);
    TYear& SetYear(void);

    /// mandatory
    /// typedef CMonth TMonth
    ///  Check whether the Month data member has been assigned a value.
    bool IsSetMonth(void) const;
    /// Check whether it is safe or not to call GetMonth method.
    bool CanGetMonth(void) const;
    void ResetMonth(void);
    const TMonth& GetMonth(void) const;
    void SetMonth(TMonth& value);
    TMonth& SetMonth(void);

    /// mandatory
    /// typedef CDay TDay
    ///  Check whether the Day data member has been assigned a value.
    bool IsSetDay(void) const;
    /// Check whether it is safe or not to call GetDay method.
    bool CanGetDay(void) const;
    void ResetDay(void);
    const TDay& GetDay(void) const;
    void SetDay(TDay& value);
    TDay& SetDay(void);

    /// optional
    /// typedef C_HM THM
    ///  Check whether the HM data member has been assigned a value.
    bool IsSetHM(void) const;
    /// Check whether it is safe or not to call GetHM method.
    bool CanGetHM(void) const;
    void ResetHM(void);
    const THM& GetHM(void) const;
    void SetHM(THM& value);
    THM& SetHM(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPubMedPubDate_Base(const CPubMedPubDate_Base&);
    CPubMedPubDate_Base& operator=(const CPubMedPubDate_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CRef< TYear > m_Year;
    NCBI_NS_NCBI::CRef< TMonth > m_Month;
    NCBI_NS_NCBI::CRef< TDay > m_Day;
    NCBI_NS_NCBI::CRef< THM > m_HM;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPubMedPubDate_Base::C_Attlist::IsSetPubStatus(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPubMedPubDate_Base::C_Attlist::CanGetPubStatus(void) const
{
    return IsSetPubStatus();
}

inline
void CPubMedPubDate_Base::C_Attlist::ResetPubStatus(void)
{
    m_PubStatus = (EAttlist_PubStatus)(0);
    m_set_State[0] &= ~0x3;
}

inline
CPubMedPubDate_Base::C_Attlist::TPubStatus CPubMedPubDate_Base::C_Attlist::GetPubStatus(void) const
{
    if (!CanGetPubStatus()) {
        ThrowUnassigned(0);
    }
    return m_PubStatus;
}

inline
void CPubMedPubDate_Base::C_Attlist::SetPubStatus(CPubMedPubDate_Base::C_Attlist::TPubStatus value)
{
    m_PubStatus = value;
    m_set_State[0] |= 0x3;
}

inline
CPubMedPubDate_Base::C_Attlist::TPubStatus& CPubMedPubDate_Base::C_Attlist::SetPubStatus(void)
{
#ifdef _DEBUG
    if (!IsSetPubStatus()) {
        memset(&m_PubStatus,UnassignedByte(),sizeof(m_PubStatus));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_PubStatus;
}

inline
bool CPubMedPubDate_Base::C_HM::C_MS::IsSetMinute(void) const
{
    return m_Minute.NotEmpty();
}

inline
bool CPubMedPubDate_Base::C_HM::C_MS::CanGetMinute(void) const
{
    return true;
}

inline
const CPubMedPubDate_Base::C_HM::C_MS::TMinute& CPubMedPubDate_Base::C_HM::C_MS::GetMinute(void) const
{
    if ( !m_Minute ) {
        const_cast<C_MS*>(this)->ResetMinute();
    }
    return (*m_Minute);
}

inline
CPubMedPubDate_Base::C_HM::C_MS::TMinute& CPubMedPubDate_Base::C_HM::C_MS::SetMinute(void)
{
    if ( !m_Minute ) {
        ResetMinute();
    }
    return (*m_Minute);
}

inline
bool CPubMedPubDate_Base::C_HM::C_MS::IsSetSecond(void) const
{
    return m_Second.NotEmpty();
}

inline
bool CPubMedPubDate_Base::C_HM::C_MS::CanGetSecond(void) const
{
    return IsSetSecond();
}

inline
const CPubMedPubDate_Base::C_HM::C_MS::TSecond& CPubMedPubDate_Base::C_HM::C_MS::GetSecond(void) const
{
    if (!CanGetSecond()) {
        ThrowUnassigned(1);
    }
    return (*m_Second);
}

inline
bool CPubMedPubDate_Base::C_HM::IsSetHour(void) const
{
    return m_Hour.NotEmpty();
}

inline
bool CPubMedPubDate_Base::C_HM::CanGetHour(void) const
{
    return true;
}

inline
const CPubMedPubDate_Base::C_HM::THour& CPubMedPubDate_Base::C_HM::GetHour(void) const
{
    if ( !m_Hour ) {
        const_cast<C_HM*>(this)->ResetHour();
    }
    return (*m_Hour);
}

inline
CPubMedPubDate_Base::C_HM::THour& CPubMedPubDate_Base::C_HM::SetHour(void)
{
    if ( !m_Hour ) {
        ResetHour();
    }
    return (*m_Hour);
}

inline
bool CPubMedPubDate_Base::C_HM::IsSetMS(void) const
{
    return m_MS.NotEmpty();
}

inline
bool CPubMedPubDate_Base::C_HM::CanGetMS(void) const
{
    return IsSetMS();
}

inline
const CPubMedPubDate_Base::C_HM::TMS& CPubMedPubDate_Base::C_HM::GetMS(void) const
{
    if (!CanGetMS()) {
        ThrowUnassigned(1);
    }
    return (*m_MS);
}

inline
bool CPubMedPubDate_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CPubMedPubDate_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CPubMedPubDate_Base::TAttlist& CPubMedPubDate_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CPubMedPubDate_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CPubMedPubDate_Base::TAttlist& CPubMedPubDate_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CPubMedPubDate_Base::IsSetYear(void) const
{
    return m_Year.NotEmpty();
}

inline
bool CPubMedPubDate_Base::CanGetYear(void) const
{
    return true;
}

inline
const CPubMedPubDate_Base::TYear& CPubMedPubDate_Base::GetYear(void) const
{
    if ( !m_Year ) {
        const_cast<CPubMedPubDate_Base*>(this)->ResetYear();
    }
    return (*m_Year);
}

inline
CPubMedPubDate_Base::TYear& CPubMedPubDate_Base::SetYear(void)
{
    if ( !m_Year ) {
        ResetYear();
    }
    return (*m_Year);
}

inline
bool CPubMedPubDate_Base::IsSetMonth(void) const
{
    return m_Month.NotEmpty();
}

inline
bool CPubMedPubDate_Base::CanGetMonth(void) const
{
    return true;
}

inline
const CPubMedPubDate_Base::TMonth& CPubMedPubDate_Base::GetMonth(void) const
{
    if ( !m_Month ) {
        const_cast<CPubMedPubDate_Base*>(this)->ResetMonth();
    }
    return (*m_Month);
}

inline
CPubMedPubDate_Base::TMonth& CPubMedPubDate_Base::SetMonth(void)
{
    if ( !m_Month ) {
        ResetMonth();
    }
    return (*m_Month);
}

inline
bool CPubMedPubDate_Base::IsSetDay(void) const
{
    return m_Day.NotEmpty();
}

inline
bool CPubMedPubDate_Base::CanGetDay(void) const
{
    return true;
}

inline
const CPubMedPubDate_Base::TDay& CPubMedPubDate_Base::GetDay(void) const
{
    if ( !m_Day ) {
        const_cast<CPubMedPubDate_Base*>(this)->ResetDay();
    }
    return (*m_Day);
}

inline
CPubMedPubDate_Base::TDay& CPubMedPubDate_Base::SetDay(void)
{
    if ( !m_Day ) {
        ResetDay();
    }
    return (*m_Day);
}

inline
bool CPubMedPubDate_Base::IsSetHM(void) const
{
    return m_HM.NotEmpty();
}

inline
bool CPubMedPubDate_Base::CanGetHM(void) const
{
    return IsSetHM();
}

inline
const CPubMedPubDate_Base::THM& CPubMedPubDate_Base::GetHM(void) const
{
    if (!CanGetHM()) {
        ThrowUnassigned(4);
    }
    return (*m_HM);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_PUBMEDPUBDATE_BASE_HPP
