/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MedlineJournalInfo_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MEDLINEJOURNALINFO_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MEDLINEJOURNALINFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CCountry;
class CISSNLinking;
class CMedlineTA;
class CNlmUniqueID;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMedlineJournalInfo_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMedlineJournalInfo_Base(void);
    // destructor
    virtual ~CMedlineJournalInfo_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CCountry TCountry;
    typedef CMedlineTA TMedlineTA;
    typedef CNlmUniqueID TNlmUniqueID;
    typedef CISSNLinking TISSNLinking;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Country,
        e_MedlineTA,
        e_NlmUniqueID,
        e_ISSNLinking
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CCountry TCountry
    ///  Check whether the Country data member has been assigned a value.
    bool IsSetCountry(void) const;
    /// Check whether it is safe or not to call GetCountry method.
    bool CanGetCountry(void) const;
    void ResetCountry(void);
    const TCountry& GetCountry(void) const;
    void SetCountry(TCountry& value);
    TCountry& SetCountry(void);

    /// mandatory
    /// typedef CMedlineTA TMedlineTA
    ///  Check whether the MedlineTA data member has been assigned a value.
    bool IsSetMedlineTA(void) const;
    /// Check whether it is safe or not to call GetMedlineTA method.
    bool CanGetMedlineTA(void) const;
    void ResetMedlineTA(void);
    const TMedlineTA& GetMedlineTA(void) const;
    void SetMedlineTA(TMedlineTA& value);
    TMedlineTA& SetMedlineTA(void);

    /// optional
    /// typedef CNlmUniqueID TNlmUniqueID
    ///  Check whether the NlmUniqueID data member has been assigned a value.
    bool IsSetNlmUniqueID(void) const;
    /// Check whether it is safe or not to call GetNlmUniqueID method.
    bool CanGetNlmUniqueID(void) const;
    void ResetNlmUniqueID(void);
    const TNlmUniqueID& GetNlmUniqueID(void) const;
    void SetNlmUniqueID(TNlmUniqueID& value);
    TNlmUniqueID& SetNlmUniqueID(void);

    /// optional
    /// typedef CISSNLinking TISSNLinking
    ///  Check whether the ISSNLinking data member has been assigned a value.
    bool IsSetISSNLinking(void) const;
    /// Check whether it is safe or not to call GetISSNLinking method.
    bool CanGetISSNLinking(void) const;
    void ResetISSNLinking(void);
    const TISSNLinking& GetISSNLinking(void) const;
    void SetISSNLinking(TISSNLinking& value);
    TISSNLinking& SetISSNLinking(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMedlineJournalInfo_Base(const CMedlineJournalInfo_Base&);
    CMedlineJournalInfo_Base& operator=(const CMedlineJournalInfo_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TCountry > m_Country;
    NCBI_NS_NCBI::CRef< TMedlineTA > m_MedlineTA;
    NCBI_NS_NCBI::CRef< TNlmUniqueID > m_NlmUniqueID;
    NCBI_NS_NCBI::CRef< TISSNLinking > m_ISSNLinking;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMedlineJournalInfo_Base::IsSetCountry(void) const
{
    return m_Country.NotEmpty();
}

inline
bool CMedlineJournalInfo_Base::CanGetCountry(void) const
{
    return IsSetCountry();
}

inline
const CMedlineJournalInfo_Base::TCountry& CMedlineJournalInfo_Base::GetCountry(void) const
{
    if (!CanGetCountry()) {
        ThrowUnassigned(0);
    }
    return (*m_Country);
}

inline
bool CMedlineJournalInfo_Base::IsSetMedlineTA(void) const
{
    return m_MedlineTA.NotEmpty();
}

inline
bool CMedlineJournalInfo_Base::CanGetMedlineTA(void) const
{
    return true;
}

inline
const CMedlineJournalInfo_Base::TMedlineTA& CMedlineJournalInfo_Base::GetMedlineTA(void) const
{
    if ( !m_MedlineTA ) {
        const_cast<CMedlineJournalInfo_Base*>(this)->ResetMedlineTA();
    }
    return (*m_MedlineTA);
}

inline
CMedlineJournalInfo_Base::TMedlineTA& CMedlineJournalInfo_Base::SetMedlineTA(void)
{
    if ( !m_MedlineTA ) {
        ResetMedlineTA();
    }
    return (*m_MedlineTA);
}

inline
bool CMedlineJournalInfo_Base::IsSetNlmUniqueID(void) const
{
    return m_NlmUniqueID.NotEmpty();
}

inline
bool CMedlineJournalInfo_Base::CanGetNlmUniqueID(void) const
{
    return IsSetNlmUniqueID();
}

inline
const CMedlineJournalInfo_Base::TNlmUniqueID& CMedlineJournalInfo_Base::GetNlmUniqueID(void) const
{
    if (!CanGetNlmUniqueID()) {
        ThrowUnassigned(2);
    }
    return (*m_NlmUniqueID);
}

inline
bool CMedlineJournalInfo_Base::IsSetISSNLinking(void) const
{
    return m_ISSNLinking.NotEmpty();
}

inline
bool CMedlineJournalInfo_Base::CanGetISSNLinking(void) const
{
    return IsSetISSNLinking();
}

inline
const CMedlineJournalInfo_Base::TISSNLinking& CMedlineJournalInfo_Base::GetISSNLinking(void) const
{
    if (!CanGetISSNLinking()) {
        ThrowUnassigned(3);
    }
    return (*m_ISSNLinking);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MEDLINEJOURNALINFO_BASE_HPP
