/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file InvestigatorList_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_INVESTIGATORLIST_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_INVESTIGATORLIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CInvestigator;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CInvestigatorList_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CInvestigatorList_Base(void);
    // destructor
    virtual ~CInvestigatorList_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CInvestigator C_E;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CInvestigator > > TInvestigator;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Investigator
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CInvestigator > > TInvestigator
    ///  Check whether the Investigator data member has been assigned a value.
    bool IsSetInvestigator(void) const;
    /// Check whether it is safe or not to call GetInvestigator method.
    bool CanGetInvestigator(void) const;
    void ResetInvestigator(void);
    const TInvestigator& GetInvestigator(void) const;
    TInvestigator& SetInvestigator(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CInvestigatorList_Base(const CInvestigatorList_Base&);
    CInvestigatorList_Base& operator=(const CInvestigatorList_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CInvestigator > > m_Investigator;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CInvestigatorList_Base::IsSetInvestigator(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CInvestigatorList_Base::CanGetInvestigator(void) const
{
    return true;
}

inline
const CInvestigatorList_Base::TInvestigator& CInvestigatorList_Base::GetInvestigator(void) const
{
    return m_Investigator;
}

inline
CInvestigatorList_Base::TInvestigator& CInvestigatorList_Base::SetInvestigator(void)
{
    m_set_State[0] |= 0x1;
    return m_Investigator;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_INVESTIGATORLIST_BASE_HPP
