/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GeneralNote_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_GENERALNOTE_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_GENERALNOTE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CGeneralNote_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CGeneralNote_Base(void);
    // destructor
    virtual ~CGeneralNote_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_Owner {
            eAttlist_Owner_NLM  = 1,
            eAttlist_Owner_NASA = 2,
            eAttlist_Owner_PIP  = 3,
            eAttlist_Owner_KIE  = 4,
            eAttlist_Owner_HSR  = 5,
            eAttlist_Owner_HMD  = 6
        };
        
        /// Access to EAttlist_Owner's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_Owner)(void);
        
        // types
        typedef EAttlist_Owner TOwner;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_Owner
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional with default eAttlist_Owner_NLM
        /// typedef EAttlist_Owner TOwner
        ///  Check whether the Owner data member has been assigned a value.
        bool IsSetOwner(void) const;
        /// Check whether it is safe or not to call GetOwner method.
        bool CanGetOwner(void) const;
        void ResetOwner(void);
        void SetDefaultOwner(void);
        TOwner GetOwner(void) const;
        void SetOwner(TOwner value);
        TOwner& SetOwner(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_Owner m_Owner;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::string TGeneralNote;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_GeneralNote
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::string TGeneralNote
    ///  Check whether the GeneralNote data member has been assigned a value.
    bool IsSetGeneralNote(void) const;
    /// Check whether it is safe or not to call GetGeneralNote method.
    bool CanGetGeneralNote(void) const;
    void ResetGeneralNote(void);
    const TGeneralNote& GetGeneralNote(void) const;
    void SetGeneralNote(const TGeneralNote& value);
    void SetGeneralNote(TGeneralNote&& value);
    TGeneralNote& SetGeneralNote(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGeneralNote_Base(const CGeneralNote_Base&);
    CGeneralNote_Base& operator=(const CGeneralNote_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::string m_GeneralNote;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGeneralNote_Base::C_Attlist::IsSetOwner(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGeneralNote_Base::C_Attlist::CanGetOwner(void) const
{
    return true;
}

inline
void CGeneralNote_Base::C_Attlist::ResetOwner(void)
{
    m_Owner = eAttlist_Owner_NLM;
    m_set_State[0] &= ~0x3;
}

inline
void CGeneralNote_Base::C_Attlist::SetDefaultOwner(void)
{
    ResetOwner();
    m_set_State[0] |= 0x1;
}

inline
CGeneralNote_Base::C_Attlist::TOwner CGeneralNote_Base::C_Attlist::GetOwner(void) const
{
    return m_Owner;
}

inline
void CGeneralNote_Base::C_Attlist::SetOwner(CGeneralNote_Base::C_Attlist::TOwner value)
{
    m_Owner = value;
    m_set_State[0] |= 0x3;
}

inline
CGeneralNote_Base::C_Attlist::TOwner& CGeneralNote_Base::C_Attlist::SetOwner(void)
{
#ifdef _DEBUG
    if (!IsSetOwner()) {
        memset(&m_Owner,UnassignedByte(),sizeof(m_Owner));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Owner;
}

inline
bool CGeneralNote_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CGeneralNote_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CGeneralNote_Base::TAttlist& CGeneralNote_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CGeneralNote_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CGeneralNote_Base::TAttlist& CGeneralNote_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CGeneralNote_Base::IsSetGeneralNote(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGeneralNote_Base::CanGetGeneralNote(void) const
{
    return IsSetGeneralNote();
}

inline
const CGeneralNote_Base::TGeneralNote& CGeneralNote_Base::GetGeneralNote(void) const
{
    if (!CanGetGeneralNote()) {
        ThrowUnassigned(1);
    }
    return m_GeneralNote;
}

inline
void CGeneralNote_Base::SetGeneralNote(const CGeneralNote_Base::TGeneralNote& value)
{
    m_GeneralNote = value;
    m_set_State[0] |= 0xc;
}

inline
void CGeneralNote_Base::SetGeneralNote(CGeneralNote_Base::TGeneralNote&& value)
{
    m_GeneralNote = std::forward<CGeneralNote_Base::TGeneralNote>(value);
    m_set_State[0] |= 0xc;
}

inline
CGeneralNote_Base::TGeneralNote& CGeneralNote_Base::SetGeneralNote(void)
{
#ifdef _DEBUG
    if (!IsSetGeneralNote()) {
        m_GeneralNote = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_GeneralNote;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_GENERALNOTE_BASE_HPP
