/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file BookDocument_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_BOOKDOCUMENT_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_BOOKDOCUMENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CAbstract;
class CArticleIdList;
class CArticleTitle;
class CAuthorList;
class CBook;
class CContributionDate;
class CDateRevised;
class CGrantList;
class CInvestigatorList;
class CItemList;
class CKeywordList;
class CLanguage;
class CLocationLabel;
class CPMID;
class CPagination;
class CPublicationType;
class CReferenceList;
class CSections;
class CVernacularTitle;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CBookDocument_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CBookDocument_Base(void);
    // destructor
    virtual ~CBookDocument_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CPMID TPMID;
    typedef CArticleIdList TArticleIdList;
    typedef CBook TBook;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLocationLabel > > TLocationLabel;
    typedef CArticleTitle TArticleTitle;
    typedef CVernacularTitle TVernacularTitle;
    typedef CPagination TPagination;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLanguage > > TLanguage;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAuthorList > > TAuthorList;
    typedef CInvestigatorList TInvestigatorList;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CPublicationType > > TPublicationType;
    typedef CAbstract TAbstract;
    typedef CSections TSections;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CKeywordList > > TKeywordList;
    typedef CContributionDate TContributionDate;
    typedef CDateRevised TDateRevised;
    typedef CGrantList TGrantList;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CItemList > > TItemList;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CReferenceList > > TReferenceList;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_PMID,
        e_ArticleIdList,
        e_Book,
        e_LocationLabel,
        e_ArticleTitle,
        e_VernacularTitle,
        e_Pagination,
        e_Language,
        e_AuthorList,
        e_InvestigatorList,
        e_PublicationType,
        e_Abstract,
        e_Sections,
        e_KeywordList,
        e_ContributionDate,
        e_DateRevised,
        e_GrantList,
        e_ItemList,
        e_ReferenceList
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 20> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CPMID TPMID
    ///  Check whether the PMID data member has been assigned a value.
    bool IsSetPMID(void) const;
    /// Check whether it is safe or not to call GetPMID method.
    bool CanGetPMID(void) const;
    void ResetPMID(void);
    const TPMID& GetPMID(void) const;
    void SetPMID(TPMID& value);
    TPMID& SetPMID(void);
    void SetPMID(const NCBI_NS_STD::string& value);

    /// mandatory
    /// typedef CArticleIdList TArticleIdList
    ///  Check whether the ArticleIdList data member has been assigned a value.
    bool IsSetArticleIdList(void) const;
    /// Check whether it is safe or not to call GetArticleIdList method.
    bool CanGetArticleIdList(void) const;
    void ResetArticleIdList(void);
    const TArticleIdList& GetArticleIdList(void) const;
    void SetArticleIdList(TArticleIdList& value);
    TArticleIdList& SetArticleIdList(void);

    /// mandatory
    /// typedef CBook TBook
    ///  Check whether the Book data member has been assigned a value.
    bool IsSetBook(void) const;
    /// Check whether it is safe or not to call GetBook method.
    bool CanGetBook(void) const;
    void ResetBook(void);
    const TBook& GetBook(void) const;
    void SetBook(TBook& value);
    TBook& SetBook(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLocationLabel > > TLocationLabel
    ///  Check whether the LocationLabel data member has been assigned a value.
    bool IsSetLocationLabel(void) const;
    /// Check whether it is safe or not to call GetLocationLabel method.
    bool CanGetLocationLabel(void) const;
    void ResetLocationLabel(void);
    const TLocationLabel& GetLocationLabel(void) const;
    TLocationLabel& SetLocationLabel(void);

    /// optional
    /// typedef CArticleTitle TArticleTitle
    ///  Check whether the ArticleTitle data member has been assigned a value.
    bool IsSetArticleTitle(void) const;
    /// Check whether it is safe or not to call GetArticleTitle method.
    bool CanGetArticleTitle(void) const;
    void ResetArticleTitle(void);
    const TArticleTitle& GetArticleTitle(void) const;
    void SetArticleTitle(TArticleTitle& value);
    TArticleTitle& SetArticleTitle(void);

    /// optional
    /// typedef CVernacularTitle TVernacularTitle
    ///  Check whether the VernacularTitle data member has been assigned a value.
    bool IsSetVernacularTitle(void) const;
    /// Check whether it is safe or not to call GetVernacularTitle method.
    bool CanGetVernacularTitle(void) const;
    void ResetVernacularTitle(void);
    const TVernacularTitle& GetVernacularTitle(void) const;
    void SetVernacularTitle(TVernacularTitle& value);
    TVernacularTitle& SetVernacularTitle(void);

    /// optional
    /// typedef CPagination TPagination
    ///  Check whether the Pagination data member has been assigned a value.
    bool IsSetPagination(void) const;
    /// Check whether it is safe or not to call GetPagination method.
    bool CanGetPagination(void) const;
    void ResetPagination(void);
    const TPagination& GetPagination(void) const;
    void SetPagination(TPagination& value);
    TPagination& SetPagination(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLanguage > > TLanguage
    ///  Check whether the Language data member has been assigned a value.
    bool IsSetLanguage(void) const;
    /// Check whether it is safe or not to call GetLanguage method.
    bool CanGetLanguage(void) const;
    void ResetLanguage(void);
    const TLanguage& GetLanguage(void) const;
    TLanguage& SetLanguage(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAuthorList > > TAuthorList
    ///  Check whether the AuthorList data member has been assigned a value.
    bool IsSetAuthorList(void) const;
    /// Check whether it is safe or not to call GetAuthorList method.
    bool CanGetAuthorList(void) const;
    void ResetAuthorList(void);
    const TAuthorList& GetAuthorList(void) const;
    TAuthorList& SetAuthorList(void);

    /// optional
    /// typedef CInvestigatorList TInvestigatorList
    ///  Check whether the InvestigatorList data member has been assigned a value.
    bool IsSetInvestigatorList(void) const;
    /// Check whether it is safe or not to call GetInvestigatorList method.
    bool CanGetInvestigatorList(void) const;
    void ResetInvestigatorList(void);
    const TInvestigatorList& GetInvestigatorList(void) const;
    void SetInvestigatorList(TInvestigatorList& value);
    TInvestigatorList& SetInvestigatorList(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CPublicationType > > TPublicationType
    ///  Check whether the PublicationType data member has been assigned a value.
    bool IsSetPublicationType(void) const;
    /// Check whether it is safe or not to call GetPublicationType method.
    bool CanGetPublicationType(void) const;
    void ResetPublicationType(void);
    const TPublicationType& GetPublicationType(void) const;
    TPublicationType& SetPublicationType(void);

    /// optional
    /// typedef CAbstract TAbstract
    ///  Check whether the Abstract data member has been assigned a value.
    bool IsSetAbstract(void) const;
    /// Check whether it is safe or not to call GetAbstract method.
    bool CanGetAbstract(void) const;
    void ResetAbstract(void);
    const TAbstract& GetAbstract(void) const;
    void SetAbstract(TAbstract& value);
    TAbstract& SetAbstract(void);

    /// optional
    /// typedef CSections TSections
    ///  Check whether the Sections data member has been assigned a value.
    bool IsSetSections(void) const;
    /// Check whether it is safe or not to call GetSections method.
    bool CanGetSections(void) const;
    void ResetSections(void);
    const TSections& GetSections(void) const;
    void SetSections(TSections& value);
    TSections& SetSections(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CKeywordList > > TKeywordList
    ///  Check whether the KeywordList data member has been assigned a value.
    bool IsSetKeywordList(void) const;
    /// Check whether it is safe or not to call GetKeywordList method.
    bool CanGetKeywordList(void) const;
    void ResetKeywordList(void);
    const TKeywordList& GetKeywordList(void) const;
    TKeywordList& SetKeywordList(void);

    /// optional
    /// typedef CContributionDate TContributionDate
    ///  Check whether the ContributionDate data member has been assigned a value.
    bool IsSetContributionDate(void) const;
    /// Check whether it is safe or not to call GetContributionDate method.
    bool CanGetContributionDate(void) const;
    void ResetContributionDate(void);
    const TContributionDate& GetContributionDate(void) const;
    void SetContributionDate(TContributionDate& value);
    TContributionDate& SetContributionDate(void);

    /// optional
    /// typedef CDateRevised TDateRevised
    ///  Check whether the DateRevised data member has been assigned a value.
    bool IsSetDateRevised(void) const;
    /// Check whether it is safe or not to call GetDateRevised method.
    bool CanGetDateRevised(void) const;
    void ResetDateRevised(void);
    const TDateRevised& GetDateRevised(void) const;
    void SetDateRevised(TDateRevised& value);
    TDateRevised& SetDateRevised(void);

    /// optional
    /// typedef CGrantList TGrantList
    ///  Check whether the GrantList data member has been assigned a value.
    bool IsSetGrantList(void) const;
    /// Check whether it is safe or not to call GetGrantList method.
    bool CanGetGrantList(void) const;
    void ResetGrantList(void);
    const TGrantList& GetGrantList(void) const;
    void SetGrantList(TGrantList& value);
    TGrantList& SetGrantList(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CItemList > > TItemList
    ///  Check whether the ItemList data member has been assigned a value.
    bool IsSetItemList(void) const;
    /// Check whether it is safe or not to call GetItemList method.
    bool CanGetItemList(void) const;
    void ResetItemList(void);
    const TItemList& GetItemList(void) const;
    TItemList& SetItemList(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CReferenceList > > TReferenceList
    ///  Check whether the ReferenceList data member has been assigned a value.
    bool IsSetReferenceList(void) const;
    /// Check whether it is safe or not to call GetReferenceList method.
    bool CanGetReferenceList(void) const;
    void ResetReferenceList(void);
    const TReferenceList& GetReferenceList(void) const;
    TReferenceList& SetReferenceList(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBookDocument_Base(const CBookDocument_Base&);
    CBookDocument_Base& operator=(const CBookDocument_Base&);

    // data
    Uint4 m_set_State[2];
    NCBI_NS_NCBI::CRef< TPMID > m_PMID;
    NCBI_NS_NCBI::CRef< TArticleIdList > m_ArticleIdList;
    NCBI_NS_NCBI::CRef< TBook > m_Book;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLocationLabel > > m_LocationLabel;
    NCBI_NS_NCBI::CRef< TArticleTitle > m_ArticleTitle;
    NCBI_NS_NCBI::CRef< TVernacularTitle > m_VernacularTitle;
    NCBI_NS_NCBI::CRef< TPagination > m_Pagination;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLanguage > > m_Language;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAuthorList > > m_AuthorList;
    NCBI_NS_NCBI::CRef< TInvestigatorList > m_InvestigatorList;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CPublicationType > > m_PublicationType;
    NCBI_NS_NCBI::CRef< TAbstract > m_Abstract;
    NCBI_NS_NCBI::CRef< TSections > m_Sections;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CKeywordList > > m_KeywordList;
    NCBI_NS_NCBI::CRef< TContributionDate > m_ContributionDate;
    NCBI_NS_NCBI::CRef< TDateRevised > m_DateRevised;
    NCBI_NS_NCBI::CRef< TGrantList > m_GrantList;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CItemList > > m_ItemList;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CReferenceList > > m_ReferenceList;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBookDocument_Base::IsSetPMID(void) const
{
    return m_PMID.NotEmpty();
}

inline
bool CBookDocument_Base::CanGetPMID(void) const
{
    return true;
}

inline
const CBookDocument_Base::TPMID& CBookDocument_Base::GetPMID(void) const
{
    if ( !m_PMID ) {
        const_cast<CBookDocument_Base*>(this)->ResetPMID();
    }
    return (*m_PMID);
}

inline
CBookDocument_Base::TPMID& CBookDocument_Base::SetPMID(void)
{
    if ( !m_PMID ) {
        ResetPMID();
    }
    return (*m_PMID);
}

inline
bool CBookDocument_Base::IsSetArticleIdList(void) const
{
    return m_ArticleIdList.NotEmpty();
}

inline
bool CBookDocument_Base::CanGetArticleIdList(void) const
{
    return true;
}

inline
const CBookDocument_Base::TArticleIdList& CBookDocument_Base::GetArticleIdList(void) const
{
    if ( !m_ArticleIdList ) {
        const_cast<CBookDocument_Base*>(this)->ResetArticleIdList();
    }
    return (*m_ArticleIdList);
}

inline
CBookDocument_Base::TArticleIdList& CBookDocument_Base::SetArticleIdList(void)
{
    if ( !m_ArticleIdList ) {
        ResetArticleIdList();
    }
    return (*m_ArticleIdList);
}

inline
bool CBookDocument_Base::IsSetBook(void) const
{
    return m_Book.NotEmpty();
}

inline
bool CBookDocument_Base::CanGetBook(void) const
{
    return true;
}

inline
const CBookDocument_Base::TBook& CBookDocument_Base::GetBook(void) const
{
    if ( !m_Book ) {
        const_cast<CBookDocument_Base*>(this)->ResetBook();
    }
    return (*m_Book);
}

inline
CBookDocument_Base::TBook& CBookDocument_Base::SetBook(void)
{
    if ( !m_Book ) {
        ResetBook();
    }
    return (*m_Book);
}

inline
bool CBookDocument_Base::IsSetLocationLabel(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CBookDocument_Base::CanGetLocationLabel(void) const
{
    return true;
}

inline
const CBookDocument_Base::TLocationLabel& CBookDocument_Base::GetLocationLabel(void) const
{
    return m_LocationLabel;
}

inline
CBookDocument_Base::TLocationLabel& CBookDocument_Base::SetLocationLabel(void)
{
    m_set_State[0] |= 0x40;
    return m_LocationLabel;
}

inline
bool CBookDocument_Base::IsSetArticleTitle(void) const
{
    return m_ArticleTitle.NotEmpty();
}

inline
bool CBookDocument_Base::CanGetArticleTitle(void) const
{
    return IsSetArticleTitle();
}

inline
const CBookDocument_Base::TArticleTitle& CBookDocument_Base::GetArticleTitle(void) const
{
    if (!CanGetArticleTitle()) {
        ThrowUnassigned(4);
    }
    return (*m_ArticleTitle);
}

inline
bool CBookDocument_Base::IsSetVernacularTitle(void) const
{
    return m_VernacularTitle.NotEmpty();
}

inline
bool CBookDocument_Base::CanGetVernacularTitle(void) const
{
    return IsSetVernacularTitle();
}

inline
const CBookDocument_Base::TVernacularTitle& CBookDocument_Base::GetVernacularTitle(void) const
{
    if (!CanGetVernacularTitle()) {
        ThrowUnassigned(5);
    }
    return (*m_VernacularTitle);
}

inline
bool CBookDocument_Base::IsSetPagination(void) const
{
    return m_Pagination.NotEmpty();
}

inline
bool CBookDocument_Base::CanGetPagination(void) const
{
    return IsSetPagination();
}

inline
const CBookDocument_Base::TPagination& CBookDocument_Base::GetPagination(void) const
{
    if (!CanGetPagination()) {
        ThrowUnassigned(6);
    }
    return (*m_Pagination);
}

inline
bool CBookDocument_Base::IsSetLanguage(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CBookDocument_Base::CanGetLanguage(void) const
{
    return true;
}

inline
const CBookDocument_Base::TLanguage& CBookDocument_Base::GetLanguage(void) const
{
    return m_Language;
}

inline
CBookDocument_Base::TLanguage& CBookDocument_Base::SetLanguage(void)
{
    m_set_State[0] |= 0x4000;
    return m_Language;
}

inline
bool CBookDocument_Base::IsSetAuthorList(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CBookDocument_Base::CanGetAuthorList(void) const
{
    return true;
}

inline
const CBookDocument_Base::TAuthorList& CBookDocument_Base::GetAuthorList(void) const
{
    return m_AuthorList;
}

inline
CBookDocument_Base::TAuthorList& CBookDocument_Base::SetAuthorList(void)
{
    m_set_State[0] |= 0x10000;
    return m_AuthorList;
}

inline
bool CBookDocument_Base::IsSetInvestigatorList(void) const
{
    return m_InvestigatorList.NotEmpty();
}

inline
bool CBookDocument_Base::CanGetInvestigatorList(void) const
{
    return IsSetInvestigatorList();
}

inline
const CBookDocument_Base::TInvestigatorList& CBookDocument_Base::GetInvestigatorList(void) const
{
    if (!CanGetInvestigatorList()) {
        ThrowUnassigned(9);
    }
    return (*m_InvestigatorList);
}

inline
bool CBookDocument_Base::IsSetPublicationType(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CBookDocument_Base::CanGetPublicationType(void) const
{
    return true;
}

inline
const CBookDocument_Base::TPublicationType& CBookDocument_Base::GetPublicationType(void) const
{
    return m_PublicationType;
}

inline
CBookDocument_Base::TPublicationType& CBookDocument_Base::SetPublicationType(void)
{
    m_set_State[0] |= 0x100000;
    return m_PublicationType;
}

inline
bool CBookDocument_Base::IsSetAbstract(void) const
{
    return m_Abstract.NotEmpty();
}

inline
bool CBookDocument_Base::CanGetAbstract(void) const
{
    return IsSetAbstract();
}

inline
const CBookDocument_Base::TAbstract& CBookDocument_Base::GetAbstract(void) const
{
    if (!CanGetAbstract()) {
        ThrowUnassigned(11);
    }
    return (*m_Abstract);
}

inline
bool CBookDocument_Base::IsSetSections(void) const
{
    return m_Sections.NotEmpty();
}

inline
bool CBookDocument_Base::CanGetSections(void) const
{
    return IsSetSections();
}

inline
const CBookDocument_Base::TSections& CBookDocument_Base::GetSections(void) const
{
    if (!CanGetSections()) {
        ThrowUnassigned(12);
    }
    return (*m_Sections);
}

inline
bool CBookDocument_Base::IsSetKeywordList(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CBookDocument_Base::CanGetKeywordList(void) const
{
    return true;
}

inline
const CBookDocument_Base::TKeywordList& CBookDocument_Base::GetKeywordList(void) const
{
    return m_KeywordList;
}

inline
CBookDocument_Base::TKeywordList& CBookDocument_Base::SetKeywordList(void)
{
    m_set_State[0] |= 0x4000000;
    return m_KeywordList;
}

inline
bool CBookDocument_Base::IsSetContributionDate(void) const
{
    return m_ContributionDate.NotEmpty();
}

inline
bool CBookDocument_Base::CanGetContributionDate(void) const
{
    return IsSetContributionDate();
}

inline
const CBookDocument_Base::TContributionDate& CBookDocument_Base::GetContributionDate(void) const
{
    if (!CanGetContributionDate()) {
        ThrowUnassigned(14);
    }
    return (*m_ContributionDate);
}

inline
bool CBookDocument_Base::IsSetDateRevised(void) const
{
    return m_DateRevised.NotEmpty();
}

inline
bool CBookDocument_Base::CanGetDateRevised(void) const
{
    return IsSetDateRevised();
}

inline
const CBookDocument_Base::TDateRevised& CBookDocument_Base::GetDateRevised(void) const
{
    if (!CanGetDateRevised()) {
        ThrowUnassigned(15);
    }
    return (*m_DateRevised);
}

inline
bool CBookDocument_Base::IsSetGrantList(void) const
{
    return m_GrantList.NotEmpty();
}

inline
bool CBookDocument_Base::CanGetGrantList(void) const
{
    return IsSetGrantList();
}

inline
const CBookDocument_Base::TGrantList& CBookDocument_Base::GetGrantList(void) const
{
    if (!CanGetGrantList()) {
        ThrowUnassigned(16);
    }
    return (*m_GrantList);
}

inline
bool CBookDocument_Base::IsSetItemList(void) const
{
    return ((m_set_State[1] & 0xc) != 0);
}

inline
bool CBookDocument_Base::CanGetItemList(void) const
{
    return true;
}

inline
const CBookDocument_Base::TItemList& CBookDocument_Base::GetItemList(void) const
{
    return m_ItemList;
}

inline
CBookDocument_Base::TItemList& CBookDocument_Base::SetItemList(void)
{
    m_set_State[1] |= 0x4;
    return m_ItemList;
}

inline
bool CBookDocument_Base::IsSetReferenceList(void) const
{
    return ((m_set_State[1] & 0x30) != 0);
}

inline
bool CBookDocument_Base::CanGetReferenceList(void) const
{
    return true;
}

inline
const CBookDocument_Base::TReferenceList& CBookDocument_Base::GetReferenceList(void) const
{
    return m_ReferenceList;
}

inline
CBookDocument_Base::TReferenceList& CBookDocument_Base::SetReferenceList(void)
{
    m_set_State[1] |= 0x10;
    return m_ReferenceList;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_BOOKDOCUMENT_BASE_HPP
