/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Abstract_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_ABSTRACT_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_ABSTRACT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CAbstractText;
class CCopyrightInformation;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// ================================================================= 
/// Everything else in alphabetical order 
/// ================================================================= 
class CAbstract_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CAbstract_Base(void);
    // destructor
    virtual ~CAbstract_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAbstractText > > TAbstractText;
    typedef CCopyrightInformation TCopyrightInformation;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_AbstractText,
        e_CopyrightInformation
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAbstractText > > TAbstractText
    ///  Check whether the AbstractText data member has been assigned a value.
    bool IsSetAbstractText(void) const;
    /// Check whether it is safe or not to call GetAbstractText method.
    bool CanGetAbstractText(void) const;
    void ResetAbstractText(void);
    const TAbstractText& GetAbstractText(void) const;
    TAbstractText& SetAbstractText(void);

    /// optional
    /// typedef CCopyrightInformation TCopyrightInformation
    ///  Check whether the CopyrightInformation data member has been assigned a value.
    bool IsSetCopyrightInformation(void) const;
    /// Check whether it is safe or not to call GetCopyrightInformation method.
    bool CanGetCopyrightInformation(void) const;
    void ResetCopyrightInformation(void);
    const TCopyrightInformation& GetCopyrightInformation(void) const;
    void SetCopyrightInformation(TCopyrightInformation& value);
    TCopyrightInformation& SetCopyrightInformation(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAbstract_Base(const CAbstract_Base&);
    CAbstract_Base& operator=(const CAbstract_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAbstractText > > m_AbstractText;
    NCBI_NS_NCBI::CRef< TCopyrightInformation > m_CopyrightInformation;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAbstract_Base::IsSetAbstractText(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAbstract_Base::CanGetAbstractText(void) const
{
    return true;
}

inline
const CAbstract_Base::TAbstractText& CAbstract_Base::GetAbstractText(void) const
{
    return m_AbstractText;
}

inline
CAbstract_Base::TAbstractText& CAbstract_Base::SetAbstractText(void)
{
    m_set_State[0] |= 0x1;
    return m_AbstractText;
}

inline
bool CAbstract_Base::IsSetCopyrightInformation(void) const
{
    return m_CopyrightInformation.NotEmpty();
}

inline
bool CAbstract_Base::CanGetCopyrightInformation(void) const
{
    return IsSetCopyrightInformation();
}

inline
const CAbstract_Base::TCopyrightInformation& CAbstract_Base::GetCopyrightInformation(void) const
{
    if (!CanGetCopyrightInformation()) {
        ThrowUnassigned(1);
    }
    return (*m_CopyrightInformation);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_ABSTRACT_BASE_HPP
