/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_RetrieveTracksetReque_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_RETRIEVETRACKSETREQUE_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_RETRIEVETRACKSETREQUE_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_GenomeContext;
class CTMgr_Identity;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_RetrieveTracksetRequest_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_RetrieveTracksetRequest_Base(void);
    // destructor
    virtual ~CTMgr_RetrieveTracksetRequest_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CTMgr_GenomeContext TGenome_context;
    typedef CTMgr_Identity TIdentity;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_genome_context,
        e_identity
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CTMgr_GenomeContext TGenome_context
    ///  Check whether the Genome_context data member has been assigned a value.
    bool IsSetGenome_context(void) const;
    /// Check whether it is safe or not to call GetGenome_context method.
    bool CanGetGenome_context(void) const;
    void ResetGenome_context(void);
    const TGenome_context& GetGenome_context(void) const;
    void SetGenome_context(TGenome_context& value);
    TGenome_context& SetGenome_context(void);

    /// optional
    /// typedef CTMgr_Identity TIdentity
    ///  Check whether the Identity data member has been assigned a value.
    bool IsSetIdentity(void) const;
    /// Check whether it is safe or not to call GetIdentity method.
    bool CanGetIdentity(void) const;
    void ResetIdentity(void);
    const TIdentity& GetIdentity(void) const;
    void SetIdentity(TIdentity& value);
    TIdentity& SetIdentity(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_RetrieveTracksetRequest_Base(const CTMgr_RetrieveTracksetRequest_Base&);
    CTMgr_RetrieveTracksetRequest_Base& operator=(const CTMgr_RetrieveTracksetRequest_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TGenome_context > m_Genome_context;
    CRef< TIdentity > m_Identity;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_RetrieveTracksetRequest_Base::IsSetGenome_context(void) const
{
    return m_Genome_context.NotEmpty();
}

inline
bool CTMgr_RetrieveTracksetRequest_Base::CanGetGenome_context(void) const
{
    return true;
}

inline
const CTMgr_RetrieveTracksetRequest_Base::TGenome_context& CTMgr_RetrieveTracksetRequest_Base::GetGenome_context(void) const
{
    if ( !m_Genome_context ) {
        const_cast<CTMgr_RetrieveTracksetRequest_Base*>(this)->ResetGenome_context();
    }
    return (*m_Genome_context);
}

inline
CTMgr_RetrieveTracksetRequest_Base::TGenome_context& CTMgr_RetrieveTracksetRequest_Base::SetGenome_context(void)
{
    if ( !m_Genome_context ) {
        ResetGenome_context();
    }
    return (*m_Genome_context);
}

inline
bool CTMgr_RetrieveTracksetRequest_Base::IsSetIdentity(void) const
{
    return m_Identity.NotEmpty();
}

inline
bool CTMgr_RetrieveTracksetRequest_Base::CanGetIdentity(void) const
{
    return IsSetIdentity();
}

inline
const CTMgr_RetrieveTracksetRequest_Base::TIdentity& CTMgr_RetrieveTracksetRequest_Base::GetIdentity(void) const
{
    if (!CanGetIdentity()) {
        ThrowUnassigned(1);
    }
    return (*m_Identity);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_RETRIEVETRACKSETREQUE_BASE_HPP
