/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_DisplayTrackReply_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_DISPLAYTRACKREPLY_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_DISPLAYTRACKREPLY_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_BlastRIDDetail;
class CTMgr_DisplayTrack;
class CTMgr_Message;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_DisplayTrackReply_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_DisplayTrackReply_Base(void);
    // destructor
    virtual ~CTMgr_DisplayTrackReply_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CTMgr_Message > > TMessages;
    typedef list< CRef< CTMgr_DisplayTrack > > TDisplay_tracks;
    typedef list< CRef< CTMgr_BlastRIDDetail > > TBlast_tracks;
    typedef list< CRef< CTMgr_DisplayTrack > > TUser_tracks;
    typedef list< CRef< CTMgr_DisplayTrack > > TRemote_tracks;
    typedef list< CRef< CTMgr_DisplayTrack > > THubs;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_messages,
        e_display_tracks,
        e_blast_tracks,
        e_user_tracks,
        e_remote_tracks,
        e_hubs
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef list< CRef< CTMgr_Message > > TMessages
    ///  Check whether the Messages data member has been assigned a value.
    bool IsSetMessages(void) const;
    /// Check whether it is safe or not to call GetMessages method.
    bool CanGetMessages(void) const;
    void ResetMessages(void);
    const TMessages& GetMessages(void) const;
    TMessages& SetMessages(void);

    /// optional
    /// typedef list< CRef< CTMgr_DisplayTrack > > TDisplay_tracks
    ///  Check whether the Display_tracks data member has been assigned a value.
    bool IsSetDisplay_tracks(void) const;
    /// Check whether it is safe or not to call GetDisplay_tracks method.
    bool CanGetDisplay_tracks(void) const;
    void ResetDisplay_tracks(void);
    const TDisplay_tracks& GetDisplay_tracks(void) const;
    TDisplay_tracks& SetDisplay_tracks(void);

    /// optional
    /// typedef list< CRef< CTMgr_BlastRIDDetail > > TBlast_tracks
    ///  Check whether the Blast_tracks data member has been assigned a value.
    bool IsSetBlast_tracks(void) const;
    /// Check whether it is safe or not to call GetBlast_tracks method.
    bool CanGetBlast_tracks(void) const;
    void ResetBlast_tracks(void);
    const TBlast_tracks& GetBlast_tracks(void) const;
    TBlast_tracks& SetBlast_tracks(void);

    /// optional
    /// typedef list< CRef< CTMgr_DisplayTrack > > TUser_tracks
    ///  Check whether the User_tracks data member has been assigned a value.
    bool IsSetUser_tracks(void) const;
    /// Check whether it is safe or not to call GetUser_tracks method.
    bool CanGetUser_tracks(void) const;
    void ResetUser_tracks(void);
    const TUser_tracks& GetUser_tracks(void) const;
    TUser_tracks& SetUser_tracks(void);

    /// optional
    /// typedef list< CRef< CTMgr_DisplayTrack > > TRemote_tracks
    ///  Check whether the Remote_tracks data member has been assigned a value.
    bool IsSetRemote_tracks(void) const;
    /// Check whether it is safe or not to call GetRemote_tracks method.
    bool CanGetRemote_tracks(void) const;
    void ResetRemote_tracks(void);
    const TRemote_tracks& GetRemote_tracks(void) const;
    TRemote_tracks& SetRemote_tracks(void);

    /// optional
    /// typedef list< CRef< CTMgr_DisplayTrack > > THubs
    ///  Check whether the Hubs data member has been assigned a value.
    bool IsSetHubs(void) const;
    /// Check whether it is safe or not to call GetHubs method.
    bool CanGetHubs(void) const;
    void ResetHubs(void);
    const THubs& GetHubs(void) const;
    THubs& SetHubs(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_DisplayTrackReply_Base(const CTMgr_DisplayTrackReply_Base&);
    CTMgr_DisplayTrackReply_Base& operator=(const CTMgr_DisplayTrackReply_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CTMgr_Message > > m_Messages;
    list< CRef< CTMgr_DisplayTrack > > m_Display_tracks;
    list< CRef< CTMgr_BlastRIDDetail > > m_Blast_tracks;
    list< CRef< CTMgr_DisplayTrack > > m_User_tracks;
    list< CRef< CTMgr_DisplayTrack > > m_Remote_tracks;
    list< CRef< CTMgr_DisplayTrack > > m_Hubs;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_DisplayTrackReply_Base::IsSetMessages(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_DisplayTrackReply_Base::CanGetMessages(void) const
{
    return true;
}

inline
const CTMgr_DisplayTrackReply_Base::TMessages& CTMgr_DisplayTrackReply_Base::GetMessages(void) const
{
    return m_Messages;
}

inline
CTMgr_DisplayTrackReply_Base::TMessages& CTMgr_DisplayTrackReply_Base::SetMessages(void)
{
    m_set_State[0] |= 0x1;
    return m_Messages;
}

inline
bool CTMgr_DisplayTrackReply_Base::IsSetDisplay_tracks(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_DisplayTrackReply_Base::CanGetDisplay_tracks(void) const
{
    return true;
}

inline
const CTMgr_DisplayTrackReply_Base::TDisplay_tracks& CTMgr_DisplayTrackReply_Base::GetDisplay_tracks(void) const
{
    return m_Display_tracks;
}

inline
CTMgr_DisplayTrackReply_Base::TDisplay_tracks& CTMgr_DisplayTrackReply_Base::SetDisplay_tracks(void)
{
    m_set_State[0] |= 0x4;
    return m_Display_tracks;
}

inline
bool CTMgr_DisplayTrackReply_Base::IsSetBlast_tracks(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTMgr_DisplayTrackReply_Base::CanGetBlast_tracks(void) const
{
    return true;
}

inline
const CTMgr_DisplayTrackReply_Base::TBlast_tracks& CTMgr_DisplayTrackReply_Base::GetBlast_tracks(void) const
{
    return m_Blast_tracks;
}

inline
CTMgr_DisplayTrackReply_Base::TBlast_tracks& CTMgr_DisplayTrackReply_Base::SetBlast_tracks(void)
{
    m_set_State[0] |= 0x10;
    return m_Blast_tracks;
}

inline
bool CTMgr_DisplayTrackReply_Base::IsSetUser_tracks(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CTMgr_DisplayTrackReply_Base::CanGetUser_tracks(void) const
{
    return true;
}

inline
const CTMgr_DisplayTrackReply_Base::TUser_tracks& CTMgr_DisplayTrackReply_Base::GetUser_tracks(void) const
{
    return m_User_tracks;
}

inline
CTMgr_DisplayTrackReply_Base::TUser_tracks& CTMgr_DisplayTrackReply_Base::SetUser_tracks(void)
{
    m_set_State[0] |= 0x40;
    return m_User_tracks;
}

inline
bool CTMgr_DisplayTrackReply_Base::IsSetRemote_tracks(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CTMgr_DisplayTrackReply_Base::CanGetRemote_tracks(void) const
{
    return true;
}

inline
const CTMgr_DisplayTrackReply_Base::TRemote_tracks& CTMgr_DisplayTrackReply_Base::GetRemote_tracks(void) const
{
    return m_Remote_tracks;
}

inline
CTMgr_DisplayTrackReply_Base::TRemote_tracks& CTMgr_DisplayTrackReply_Base::SetRemote_tracks(void)
{
    m_set_State[0] |= 0x100;
    return m_Remote_tracks;
}

inline
bool CTMgr_DisplayTrackReply_Base::IsSetHubs(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CTMgr_DisplayTrackReply_Base::CanGetHubs(void) const
{
    return true;
}

inline
const CTMgr_DisplayTrackReply_Base::THubs& CTMgr_DisplayTrackReply_Base::GetHubs(void) const
{
    return m_Hubs;
}

inline
CTMgr_DisplayTrackReply_Base::THubs& CTMgr_DisplayTrackReply_Base::SetHubs(void)
{
    m_set_State[0] |= 0x400;
    return m_Hubs;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_DISPLAYTRACKREPLY_BASE_HPP
