/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_AttrValueReply_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_ATTRVALUEREPLY_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_ATTRVALUEREPLY_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_AttrValueReply_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_AttrValueReply_Base(void);
    // destructor
    virtual ~CTMgr_AttrValueReply_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TAttr_name;
    typedef list< string > TValue_list;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_attr_name,
        e_value_list
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TAttr_name
    ///  Check whether the Attr_name data member has been assigned a value.
    bool IsSetAttr_name(void) const;
    /// Check whether it is safe or not to call GetAttr_name method.
    bool CanGetAttr_name(void) const;
    void ResetAttr_name(void);
    const TAttr_name& GetAttr_name(void) const;
    void SetAttr_name(const TAttr_name& value);
    void SetAttr_name(TAttr_name&& value);
    TAttr_name& SetAttr_name(void);

    /// mandatory
    /// typedef list< string > TValue_list
    ///  Check whether the Value_list data member has been assigned a value.
    bool IsSetValue_list(void) const;
    /// Check whether it is safe or not to call GetValue_list method.
    bool CanGetValue_list(void) const;
    void ResetValue_list(void);
    const TValue_list& GetValue_list(void) const;
    TValue_list& SetValue_list(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_AttrValueReply_Base(const CTMgr_AttrValueReply_Base&);
    CTMgr_AttrValueReply_Base& operator=(const CTMgr_AttrValueReply_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Attr_name;
    list< string > m_Value_list;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_AttrValueReply_Base::IsSetAttr_name(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_AttrValueReply_Base::CanGetAttr_name(void) const
{
    return IsSetAttr_name();
}

inline
const CTMgr_AttrValueReply_Base::TAttr_name& CTMgr_AttrValueReply_Base::GetAttr_name(void) const
{
    if (!CanGetAttr_name()) {
        ThrowUnassigned(0);
    }
    return m_Attr_name;
}

inline
void CTMgr_AttrValueReply_Base::SetAttr_name(const CTMgr_AttrValueReply_Base::TAttr_name& value)
{
    m_Attr_name = value;
    m_set_State[0] |= 0x3;
}

inline
void CTMgr_AttrValueReply_Base::SetAttr_name(CTMgr_AttrValueReply_Base::TAttr_name&& value)
{
    m_Attr_name = std::forward<CTMgr_AttrValueReply_Base::TAttr_name>(value);
    m_set_State[0] |= 0x3;
}

inline
CTMgr_AttrValueReply_Base::TAttr_name& CTMgr_AttrValueReply_Base::SetAttr_name(void)
{
#ifdef _DEBUG
    if (!IsSetAttr_name()) {
        m_Attr_name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Attr_name;
}

inline
bool CTMgr_AttrValueReply_Base::IsSetValue_list(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_AttrValueReply_Base::CanGetValue_list(void) const
{
    return true;
}

inline
const CTMgr_AttrValueReply_Base::TValue_list& CTMgr_AttrValueReply_Base::GetValue_list(void) const
{
    return m_Value_list;
}

inline
CTMgr_AttrValueReply_Base::TValue_list& CTMgr_AttrValueReply_Base::SetValue_list(void)
{
    m_set_State[0] |= 0x4;
    return m_Value_list;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_ATTRVALUEREPLY_BASE_HPP
