/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_bond_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqloc.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQLOC_SEQ_BOND_BASE_HPP
#define OBJECTS_SEQLOC_SEQ_BOND_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_point;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// bond between residues
class NCBI_SEQLOC_EXPORT CSeq_bond_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_bond_Base(void);
    // destructor
    virtual ~CSeq_bond_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSeq_point TA;
    typedef CSeq_point TB;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_a,
        e_b
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// connection to a least one residue
    /// mandatory
    /// typedef CSeq_point TA
    ///  Check whether the A data member has been assigned a value.
    bool IsSetA(void) const;
    /// Check whether it is safe or not to call GetA method.
    bool CanGetA(void) const;
    void ResetA(void);
    const TA& GetA(void) const;
    void SetA(TA& value);
    TA& SetA(void);

    /// other end may not be available
    /// optional
    /// typedef CSeq_point TB
    ///  Check whether the B data member has been assigned a value.
    bool IsSetB(void) const;
    /// Check whether it is safe or not to call GetB method.
    bool CanGetB(void) const;
    void ResetB(void);
    const TB& GetB(void) const;
    void SetB(TB& value);
    TB& SetB(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeq_bond_Base(const CSeq_bond_Base&);
    CSeq_bond_Base& operator=(const CSeq_bond_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TA > m_A;
    CRef< TB > m_B;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeq_bond_Base::IsSetA(void) const
{
    return m_A.NotEmpty();
}

inline
bool CSeq_bond_Base::CanGetA(void) const
{
    return true;
}

inline
const CSeq_bond_Base::TA& CSeq_bond_Base::GetA(void) const
{
    if ( !m_A ) {
        const_cast<CSeq_bond_Base*>(this)->ResetA();
    }
    return (*m_A);
}

inline
CSeq_bond_Base::TA& CSeq_bond_Base::SetA(void)
{
    if ( !m_A ) {
        ResetA();
    }
    return (*m_A);
}

inline
bool CSeq_bond_Base::IsSetB(void) const
{
    return m_B.NotEmpty();
}

inline
bool CSeq_bond_Base::CanGetB(void) const
{
    return IsSetB();
}

inline
const CSeq_bond_Base::TB& CSeq_bond_Base::GetB(void) const
{
    if (!CanGetB()) {
        ThrowUnassigned(1);
    }
    return (*m_B);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQLOC_SEQ_BOND_BASE_HPP
