/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file OrgMod_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_ORGMOD_BASE_HPP
#define OBJECTS_SEQFEAT_ORGMOD_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT COrgMod_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    COrgMod_Base(void);
    // destructor
    virtual ~COrgMod_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum ESubtype {
        eSubtype_strain             =   2,
        eSubtype_substrain          =   3,
        eSubtype_type               =   4,
        eSubtype_subtype            =   5,
        eSubtype_variety            =   6,
        eSubtype_serotype           =   7,
        eSubtype_serogroup          =   8,
        eSubtype_serovar            =   9,
        eSubtype_cultivar           =  10,
        eSubtype_pathovar           =  11,
        eSubtype_chemovar           =  12,
        eSubtype_biovar             =  13,
        eSubtype_biotype            =  14,
        eSubtype_group              =  15,
        eSubtype_subgroup           =  16,
        eSubtype_isolate            =  17,
        eSubtype_common             =  18,
        eSubtype_acronym            =  19,
        eSubtype_dosage             =  20,  ///< chromosome dosage of hybrid
        eSubtype_nat_host           =  21,  ///< natural host of this specimen
        eSubtype_sub_species        =  22,
        eSubtype_specimen_voucher   =  23,
        eSubtype_authority          =  24,
        eSubtype_forma              =  25,
        eSubtype_forma_specialis    =  26,
        eSubtype_ecotype            =  27,
        eSubtype_synonym            =  28,
        eSubtype_anamorph           =  29,
        eSubtype_teleomorph         =  30,
        eSubtype_breed              =  31,
        eSubtype_gb_acronym         =  32,  ///< used by taxonomy database
        eSubtype_gb_anamorph        =  33,  ///< used by taxonomy database
        eSubtype_gb_synonym         =  34,  ///< used by taxonomy database
        eSubtype_culture_collection =  35,
        eSubtype_bio_material       =  36,
        eSubtype_metagenome_source  =  37,
        eSubtype_type_material      =  38,
        eSubtype_nomenclature       =  39,  ///< code of nomenclature in subname (B,P,V,Z or combination)
        eSubtype_old_lineage        = 253,
        eSubtype_old_name           = 254,
        eSubtype_other              = 255  ///< ASN5: old-name (254) will be added to next spec
    };
    
    /// Access to ESubtype's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESubtype)(void);
    
    // types
    typedef int TSubtype;
    typedef string TSubname;
    typedef string TAttrib;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_subtype,
        e_subname,
        e_attrib
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TSubtype
    ///  Check whether the Subtype data member has been assigned a value.
    bool IsSetSubtype(void) const;
    /// Check whether it is safe or not to call GetSubtype method.
    bool CanGetSubtype(void) const;
    void ResetSubtype(void);
    TSubtype GetSubtype(void) const;
    void SetSubtype(TSubtype value);
    TSubtype& SetSubtype(void);

    /// mandatory
    /// typedef string TSubname
    ///  Check whether the Subname data member has been assigned a value.
    bool IsSetSubname(void) const;
    /// Check whether it is safe or not to call GetSubname method.
    bool CanGetSubname(void) const;
    void ResetSubname(void);
    const TSubname& GetSubname(void) const;
    void SetSubname(const TSubname& value);
    void SetSubname(TSubname&& value);
    TSubname& SetSubname(void);

    /// attribution/source of name
    /// optional
    /// typedef string TAttrib
    ///  Check whether the Attrib data member has been assigned a value.
    bool IsSetAttrib(void) const;
    /// Check whether it is safe or not to call GetAttrib method.
    bool CanGetAttrib(void) const;
    void ResetAttrib(void);
    const TAttrib& GetAttrib(void) const;
    void SetAttrib(const TAttrib& value);
    void SetAttrib(TAttrib&& value);
    TAttrib& SetAttrib(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    COrgMod_Base(const COrgMod_Base&);
    COrgMod_Base& operator=(const COrgMod_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Subtype;
    string m_Subname;
    string m_Attrib;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool COrgMod_Base::IsSetSubtype(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool COrgMod_Base::CanGetSubtype(void) const
{
    return IsSetSubtype();
}

inline
void COrgMod_Base::ResetSubtype(void)
{
    m_Subtype = (ESubtype)(0);
    m_set_State[0] &= ~0x3;
}

inline
COrgMod_Base::TSubtype COrgMod_Base::GetSubtype(void) const
{
    if (!CanGetSubtype()) {
        ThrowUnassigned(0);
    }
    return m_Subtype;
}

inline
void COrgMod_Base::SetSubtype(COrgMod_Base::TSubtype value)
{
    m_Subtype = value;
    m_set_State[0] |= 0x3;
}

inline
COrgMod_Base::TSubtype& COrgMod_Base::SetSubtype(void)
{
#ifdef _DEBUG
    if (!IsSetSubtype()) {
        memset(&m_Subtype,UnassignedByte(),sizeof(m_Subtype));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Subtype;
}

inline
bool COrgMod_Base::IsSetSubname(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool COrgMod_Base::CanGetSubname(void) const
{
    return IsSetSubname();
}

inline
const COrgMod_Base::TSubname& COrgMod_Base::GetSubname(void) const
{
    if (!CanGetSubname()) {
        ThrowUnassigned(1);
    }
    return m_Subname;
}

inline
void COrgMod_Base::SetSubname(const COrgMod_Base::TSubname& value)
{
    m_Subname = value;
    m_set_State[0] |= 0xc;
}

inline
void COrgMod_Base::SetSubname(COrgMod_Base::TSubname&& value)
{
    m_Subname = std::forward<COrgMod_Base::TSubname>(value);
    m_set_State[0] |= 0xc;
}

inline
COrgMod_Base::TSubname& COrgMod_Base::SetSubname(void)
{
#ifdef _DEBUG
    if (!IsSetSubname()) {
        m_Subname = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Subname;
}

inline
bool COrgMod_Base::IsSetAttrib(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool COrgMod_Base::CanGetAttrib(void) const
{
    return IsSetAttrib();
}

inline
const COrgMod_Base::TAttrib& COrgMod_Base::GetAttrib(void) const
{
    if (!CanGetAttrib()) {
        ThrowUnassigned(2);
    }
    return m_Attrib;
}

inline
void COrgMod_Base::SetAttrib(const COrgMod_Base::TAttrib& value)
{
    m_Attrib = value;
    m_set_State[0] |= 0x30;
}

inline
void COrgMod_Base::SetAttrib(COrgMod_Base::TAttrib&& value)
{
    m_Attrib = std::forward<COrgMod_Base::TAttrib>(value);
    m_set_State[0] |= 0x30;
}

inline
COrgMod_Base::TAttrib& COrgMod_Base::SetAttrib(void)
{
#ifdef _DEBUG
    if (!IsSetAttrib()) {
        m_Attrib = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Attrib;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_ORGMOD_BASE_HPP
