/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file BinomialOrgName_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_BINOMIALORGNAME_BASE_HPP
#define OBJECTS_SEQFEAT_BINOMIALORGNAME_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CBinomialOrgName_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBinomialOrgName_Base(void);
    // destructor
    virtual ~CBinomialOrgName_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TGenus;
    typedef string TSpecies;
    typedef string TSubspecies;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_genus,
        e_species,
        e_subspecies
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// required
    /// mandatory
    /// typedef string TGenus
    ///  Check whether the Genus data member has been assigned a value.
    bool IsSetGenus(void) const;
    /// Check whether it is safe or not to call GetGenus method.
    bool CanGetGenus(void) const;
    void ResetGenus(void);
    const TGenus& GetGenus(void) const;
    void SetGenus(const TGenus& value);
    void SetGenus(TGenus&& value);
    TGenus& SetGenus(void);

    /// species required if subspecies used
    /// optional
    /// typedef string TSpecies
    ///  Check whether the Species data member has been assigned a value.
    bool IsSetSpecies(void) const;
    /// Check whether it is safe or not to call GetSpecies method.
    bool CanGetSpecies(void) const;
    void ResetSpecies(void);
    const TSpecies& GetSpecies(void) const;
    void SetSpecies(const TSpecies& value);
    void SetSpecies(TSpecies&& value);
    TSpecies& SetSpecies(void);

    /// optional
    /// typedef string TSubspecies
    ///  Check whether the Subspecies data member has been assigned a value.
    bool IsSetSubspecies(void) const;
    /// Check whether it is safe or not to call GetSubspecies method.
    bool CanGetSubspecies(void) const;
    void ResetSubspecies(void);
    const TSubspecies& GetSubspecies(void) const;
    void SetSubspecies(const TSubspecies& value);
    void SetSubspecies(TSubspecies&& value);
    TSubspecies& SetSubspecies(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBinomialOrgName_Base(const CBinomialOrgName_Base&);
    CBinomialOrgName_Base& operator=(const CBinomialOrgName_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Genus;
    string m_Species;
    string m_Subspecies;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBinomialOrgName_Base::IsSetGenus(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBinomialOrgName_Base::CanGetGenus(void) const
{
    return IsSetGenus();
}

inline
const CBinomialOrgName_Base::TGenus& CBinomialOrgName_Base::GetGenus(void) const
{
    if (!CanGetGenus()) {
        ThrowUnassigned(0);
    }
    return m_Genus;
}

inline
void CBinomialOrgName_Base::SetGenus(const CBinomialOrgName_Base::TGenus& value)
{
    m_Genus = value;
    m_set_State[0] |= 0x3;
}

inline
void CBinomialOrgName_Base::SetGenus(CBinomialOrgName_Base::TGenus&& value)
{
    m_Genus = std::forward<CBinomialOrgName_Base::TGenus>(value);
    m_set_State[0] |= 0x3;
}

inline
CBinomialOrgName_Base::TGenus& CBinomialOrgName_Base::SetGenus(void)
{
#ifdef _DEBUG
    if (!IsSetGenus()) {
        m_Genus = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Genus;
}

inline
bool CBinomialOrgName_Base::IsSetSpecies(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBinomialOrgName_Base::CanGetSpecies(void) const
{
    return IsSetSpecies();
}

inline
const CBinomialOrgName_Base::TSpecies& CBinomialOrgName_Base::GetSpecies(void) const
{
    if (!CanGetSpecies()) {
        ThrowUnassigned(1);
    }
    return m_Species;
}

inline
void CBinomialOrgName_Base::SetSpecies(const CBinomialOrgName_Base::TSpecies& value)
{
    m_Species = value;
    m_set_State[0] |= 0xc;
}

inline
void CBinomialOrgName_Base::SetSpecies(CBinomialOrgName_Base::TSpecies&& value)
{
    m_Species = std::forward<CBinomialOrgName_Base::TSpecies>(value);
    m_set_State[0] |= 0xc;
}

inline
CBinomialOrgName_Base::TSpecies& CBinomialOrgName_Base::SetSpecies(void)
{
#ifdef _DEBUG
    if (!IsSetSpecies()) {
        m_Species = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Species;
}

inline
bool CBinomialOrgName_Base::IsSetSubspecies(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBinomialOrgName_Base::CanGetSubspecies(void) const
{
    return IsSetSubspecies();
}

inline
const CBinomialOrgName_Base::TSubspecies& CBinomialOrgName_Base::GetSubspecies(void) const
{
    if (!CanGetSubspecies()) {
        ThrowUnassigned(2);
    }
    return m_Subspecies;
}

inline
void CBinomialOrgName_Base::SetSubspecies(const CBinomialOrgName_Base::TSubspecies& value)
{
    m_Subspecies = value;
    m_set_State[0] |= 0x30;
}

inline
void CBinomialOrgName_Base::SetSubspecies(CBinomialOrgName_Base::TSubspecies&& value)
{
    m_Subspecies = std::forward<CBinomialOrgName_Base::TSubspecies>(value);
    m_set_State[0] |= 0x30;
}

inline
CBinomialOrgName_Base::TSubspecies& CBinomialOrgName_Base::SetSubspecies(void)
{
#ifdef _DEBUG
    if (!IsSetSubspecies()) {
        m_Subspecies = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Subspecies;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_BINOMIALORGNAME_BASE_HPP
