/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqEdit_Cmd_AttachSeqEntry_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqedit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQEDIT_SEQEDIT_CMD_ATTACHSEQENTRY_BASE_HPP
#define OBJECTS_SEQEDIT_SEQEDIT_CMD_ATTACHSEQENTRY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeqEdit_Id;
class CSeq_entry;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///***************************************************************
/// Attach a seq entry to bioseq-set
class NCBI_SEQEDIT_EXPORT CSeqEdit_Cmd_AttachSeqEntry_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeqEdit_Cmd_AttachSeqEntry_Base(void);
    // destructor
    virtual ~CSeqEdit_Cmd_AttachSeqEntry_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSeqEdit_Id TId;
    typedef CSeq_entry TSeq_entry;
    typedef int TIndex;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_seq_entry,
        e_index
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// Bioseq_set id
    /// mandatory
    /// typedef CSeqEdit_Id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// set entry
    /// optional
    /// typedef CSeq_entry TSeq_entry
    ///  Check whether the Seq_entry data member has been assigned a value.
    bool IsSetSeq_entry(void) const;
    /// Check whether it is safe or not to call GetSeq_entry method.
    bool CanGetSeq_entry(void) const;
    void ResetSeq_entry(void);
    const TSeq_entry& GetSeq_entry(void) const;
    void SetSeq_entry(TSeq_entry& value);
    TSeq_entry& SetSeq_entry(void);

    /// index
    /// mandatory
    /// typedef int TIndex
    ///  Check whether the Index data member has been assigned a value.
    bool IsSetIndex(void) const;
    /// Check whether it is safe or not to call GetIndex method.
    bool CanGetIndex(void) const;
    void ResetIndex(void);
    TIndex GetIndex(void) const;
    void SetIndex(TIndex value);
    TIndex& SetIndex(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeqEdit_Cmd_AttachSeqEntry_Base(const CSeqEdit_Cmd_AttachSeqEntry_Base&);
    CSeqEdit_Cmd_AttachSeqEntry_Base& operator=(const CSeqEdit_Cmd_AttachSeqEntry_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TId > m_Id;
    CRef< TSeq_entry > m_Seq_entry;
    int m_Index;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeqEdit_Cmd_AttachSeqEntry_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CSeqEdit_Cmd_AttachSeqEntry_Base::CanGetId(void) const
{
    return true;
}

inline
const CSeqEdit_Cmd_AttachSeqEntry_Base::TId& CSeqEdit_Cmd_AttachSeqEntry_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CSeqEdit_Cmd_AttachSeqEntry_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CSeqEdit_Cmd_AttachSeqEntry_Base::TId& CSeqEdit_Cmd_AttachSeqEntry_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CSeqEdit_Cmd_AttachSeqEntry_Base::IsSetSeq_entry(void) const
{
    return m_Seq_entry.NotEmpty();
}

inline
bool CSeqEdit_Cmd_AttachSeqEntry_Base::CanGetSeq_entry(void) const
{
    return IsSetSeq_entry();
}

inline
const CSeqEdit_Cmd_AttachSeqEntry_Base::TSeq_entry& CSeqEdit_Cmd_AttachSeqEntry_Base::GetSeq_entry(void) const
{
    if (!CanGetSeq_entry()) {
        ThrowUnassigned(1);
    }
    return (*m_Seq_entry);
}

inline
bool CSeqEdit_Cmd_AttachSeqEntry_Base::IsSetIndex(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSeqEdit_Cmd_AttachSeqEntry_Base::CanGetIndex(void) const
{
    return IsSetIndex();
}

inline
void CSeqEdit_Cmd_AttachSeqEntry_Base::ResetIndex(void)
{
    m_Index = 0;
    m_set_State[0] &= ~0x30;
}

inline
CSeqEdit_Cmd_AttachSeqEntry_Base::TIndex CSeqEdit_Cmd_AttachSeqEntry_Base::GetIndex(void) const
{
    if (!CanGetIndex()) {
        ThrowUnassigned(2);
    }
    return m_Index;
}

inline
void CSeqEdit_Cmd_AttachSeqEntry_Base::SetIndex(CSeqEdit_Cmd_AttachSeqEntry_Base::TIndex value)
{
    m_Index = value;
    m_set_State[0] |= 0x30;
}

inline
CSeqEdit_Cmd_AttachSeqEntry_Base::TIndex& CSeqEdit_Cmd_AttachSeqEntry_Base::SetIndex(void)
{
#ifdef _DEBUG
    if (!IsSetIndex()) {
        memset(&m_Index,UnassignedByte(),sizeof(m_Index));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Index;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQEDIT_SEQEDIT_CMD_ATTACHSEQENTRY_BASE_HPP
