/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PDB_replace_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqblock.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQBLOCK_PDB_REPLACE_BASE_HPP
#define OBJECTS_SEQBLOCK_PDB_REPLACE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDate;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQBLOCK_EXPORT CPDB_replace_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPDB_replace_Base(void);
    // destructor
    virtual ~CPDB_replace_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CDate TDate;
    typedef list< string > TIds;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_date,
        e_ids
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CDate TDate
    ///  Check whether the Date data member has been assigned a value.
    bool IsSetDate(void) const;
    /// Check whether it is safe or not to call GetDate method.
    bool CanGetDate(void) const;
    void ResetDate(void);
    const TDate& GetDate(void) const;
    void SetDate(TDate& value);
    TDate& SetDate(void);

    /// entry ids replace by this one
    /// mandatory
    /// typedef list< string > TIds
    ///  Check whether the Ids data member has been assigned a value.
    bool IsSetIds(void) const;
    /// Check whether it is safe or not to call GetIds method.
    bool CanGetIds(void) const;
    void ResetIds(void);
    const TIds& GetIds(void) const;
    TIds& SetIds(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPDB_replace_Base(const CPDB_replace_Base&);
    CPDB_replace_Base& operator=(const CPDB_replace_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TDate > m_Date;
    list< string > m_Ids;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPDB_replace_Base::IsSetDate(void) const
{
    return m_Date.NotEmpty();
}

inline
bool CPDB_replace_Base::CanGetDate(void) const
{
    return true;
}

inline
const CPDB_replace_Base::TDate& CPDB_replace_Base::GetDate(void) const
{
    if ( !m_Date ) {
        const_cast<CPDB_replace_Base*>(this)->ResetDate();
    }
    return (*m_Date);
}

inline
CPDB_replace_Base::TDate& CPDB_replace_Base::SetDate(void)
{
    if ( !m_Date ) {
        ResetDate();
    }
    return (*m_Date);
}

inline
bool CPDB_replace_Base::IsSetIds(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPDB_replace_Base::CanGetIds(void) const
{
    return true;
}

inline
const CPDB_replace_Base::TIds& CPDB_replace_Base::GetIds(void) const
{
    return m_Ids;
}

inline
CPDB_replace_Base::TIds& CPDB_replace_Base::SetIds(void)
{
    m_set_State[0] |= 0x4;
    return m_Ids;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQBLOCK_PDB_REPLACE_BASE_HPP
