/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Spliced_seg_modifier_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqalign.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQALIGN_SPLICED_SEG_MODIFIER_BASE_HPP
#define OBJECTS_SEQALIGN_SPLICED_SEG_MODIFIER_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQALIGN_EXPORT CSpliced_seg_modifier_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSpliced_seg_modifier_Base(void);
    // destructor
    virtual ~CSpliced_seg_modifier_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,        ///< No variant selected
        e_Start_codon_found,  ///< protein aligns from the start and the first codon   on both product and genomic is start codon
        e_Stop_codon_found    ///< protein aligns to it's end and there is stop codon   on the genomic right after the alignment
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 3 ///< == e_Stop_codon_found+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef bool TStart_codon_found;
    typedef bool TStop_codon_found;

    // getters
    // setters

    // typedef bool TStart_codon_found
    bool IsStart_codon_found(void) const;
    TStart_codon_found GetStart_codon_found(void) const;
    TStart_codon_found& SetStart_codon_found(void);
    void SetStart_codon_found(TStart_codon_found value);

    // typedef bool TStop_codon_found
    bool IsStop_codon_found(void) const;
    TStop_codon_found GetStop_codon_found(void) const;
    TStop_codon_found& SetStop_codon_found(void);
    void SetStop_codon_found(TStop_codon_found value);


private:
    // copy constructor and assignment operator
    CSpliced_seg_modifier_Base(const CSpliced_seg_modifier_Base& );
    CSpliced_seg_modifier_Base& operator=(const CSpliced_seg_modifier_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TStart_codon_found m_Start_codon_found;
        TStop_codon_found m_Stop_codon_found;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSpliced_seg_modifier_Base::E_Choice CSpliced_seg_modifier_Base::Which(void) const
{
    return m_choice;
}

inline
void CSpliced_seg_modifier_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSpliced_seg_modifier_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSpliced_seg_modifier_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSpliced_seg_modifier_Base::IsStart_codon_found(void) const
{
    return m_choice == e_Start_codon_found;
}

inline
CSpliced_seg_modifier_Base::TStart_codon_found CSpliced_seg_modifier_Base::GetStart_codon_found(void) const
{
    CheckSelected(e_Start_codon_found);
    return m_Start_codon_found;
}

inline
CSpliced_seg_modifier_Base::TStart_codon_found& CSpliced_seg_modifier_Base::SetStart_codon_found(void)
{
    Select(e_Start_codon_found, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Start_codon_found;
}

inline
void CSpliced_seg_modifier_Base::SetStart_codon_found(CSpliced_seg_modifier_Base::TStart_codon_found value)
{
    Select(e_Start_codon_found, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Start_codon_found = value;
}

inline
bool CSpliced_seg_modifier_Base::IsStop_codon_found(void) const
{
    return m_choice == e_Stop_codon_found;
}

inline
CSpliced_seg_modifier_Base::TStop_codon_found CSpliced_seg_modifier_Base::GetStop_codon_found(void) const
{
    CheckSelected(e_Stop_codon_found);
    return m_Stop_codon_found;
}

inline
CSpliced_seg_modifier_Base::TStop_codon_found& CSpliced_seg_modifier_Base::SetStop_codon_found(void)
{
    Select(e_Stop_codon_found, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Stop_codon_found;
}

inline
void CSpliced_seg_modifier_Base::SetStop_codon_found(CSpliced_seg_modifier_Base::TStop_codon_found value)
{
    Select(e_Stop_codon_found, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Stop_codon_found = value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQALIGN_SPLICED_SEG_MODIFIER_BASE_HPP
