/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Score_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqalign.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQALIGN_SCORE_BASE_HPP
#define OBJECTS_SEQALIGN_SCORE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CObject_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// use of Score is discouraged for external ASN.1 specifications
class NCBI_SEQALIGN_EXPORT CScore_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CScore_Base(void);
    // destructor
    virtual ~CScore_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_SEQALIGN_EXPORT C_Value : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Value(void);
        // destructor
        ~C_Value(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Real,
            e_Int
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Int+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef double TReal;
        typedef int TInt;
    
        // getters
        // setters
    
        // typedef double TReal
        bool IsReal(void) const;
        TReal GetReal(void) const;
        TReal& SetReal(void);
        void SetReal(TReal value);
    
        // typedef int TInt
        bool IsInt(void) const;
        TInt GetInt(void) const;
        TInt& SetInt(void);
        void SetInt(TInt value);
    
    
    private:
        // copy constructor and assignment operator
        C_Value(const C_Value& );
        C_Value& operator=(const C_Value& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            TReal m_Real;
            TInt m_Int;
        };
    };
    // types
    typedef CObject_id TId;
    typedef C_Value TValue;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_value
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CObject_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// mandatory
    /// typedef C_Value TValue
    ///  Check whether the Value data member has been assigned a value.
    bool IsSetValue(void) const;
    /// Check whether it is safe or not to call GetValue method.
    bool CanGetValue(void) const;
    void ResetValue(void);
    const TValue& GetValue(void) const;
    TValue& SetValue(void);

    /// Reset the whole object
    virtual void Reset(void);

    virtual void DoNotDeleteThisObject(void);


private:
    // Prohibit copy constructor and assignment operator
    CScore_Base(const CScore_Base&);
    CScore_Base& operator=(const CScore_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TId > m_Id;
    C_Value m_Value;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CScore_Base::C_Value::E_Choice CScore_Base::C_Value::Which(void) const
{
    return m_choice;
}

inline
void CScore_Base::C_Value::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CScore_Base::C_Value::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CScore_Base::C_Value::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CScore_Base::C_Value::IsReal(void) const
{
    return m_choice == e_Real;
}

inline
CScore_Base::C_Value::TReal CScore_Base::C_Value::GetReal(void) const
{
    CheckSelected(e_Real);
    return m_Real;
}

inline
CScore_Base::C_Value::TReal& CScore_Base::C_Value::SetReal(void)
{
    Select(e_Real, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Real;
}

inline
void CScore_Base::C_Value::SetReal(CScore_Base::C_Value::TReal value)
{
    Select(e_Real, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Real = value;
}

inline
bool CScore_Base::C_Value::IsInt(void) const
{
    return m_choice == e_Int;
}

inline
CScore_Base::C_Value::TInt CScore_Base::C_Value::GetInt(void) const
{
    CheckSelected(e_Int);
    return m_Int;
}

inline
CScore_Base::C_Value::TInt& CScore_Base::C_Value::SetInt(void)
{
    Select(e_Int, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Int;
}

inline
void CScore_Base::C_Value::SetInt(CScore_Base::C_Value::TInt value)
{
    Select(e_Int, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Int = value;
}

inline
bool CScore_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CScore_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
const CScore_Base::TId& CScore_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return (*m_Id);
}

inline
bool CScore_Base::IsSetValue(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CScore_Base::CanGetValue(void) const
{
    return IsSetValue();
}

inline
const CScore_Base::TValue& CScore_Base::GetValue(void) const
{
    if (!CanGetValue()) {
        ThrowUnassigned(1);
    }
    return m_Value;
}

inline
CScore_Base::TValue& CScore_Base::SetValue(void)
{
    m_set_State[0] |= 0x4;
    return m_Value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQALIGN_SCORE_BASE_HPP
