/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_data_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_SEQ_DATA_BASE_HPP
#define OBJECTS_SEQ_SEQ_DATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/seq/IUPACaa.hpp>
#include <objects/seq/IUPACna.hpp>
#include <objects/seq/NCBI2na.hpp>
#include <objects/seq/NCBI4na.hpp>
#include <objects/seq/NCBI8aa.hpp>
#include <objects/seq/NCBI8na.hpp>
#include <objects/seq/NCBIeaa.hpp>
#include <objects/seq/NCBIpaa.hpp>
#include <objects/seq/NCBIpna.hpp>
#include <objects/seq/NCBIstdaa.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_gap;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///*** Various internal sequence representations ************
///*      all are controlled, fixed length forms
/// sequence representations
class NCBI_SEQ_EXPORT CSeq_data_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_data_Base(void);
    // destructor
    virtual ~CSeq_data_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Iupacna,      ///< IUPAC 1 letter nuc acid code
        e_Iupacaa,      ///< IUPAC 1 letter amino acid code
        e_Ncbi2na,      ///< 2 bit nucleic acid code
        e_Ncbi4na,      ///< 4 bit nucleic acid code
        e_Ncbi8na,      ///< 8 bit extended nucleic acid code
        e_Ncbipna,      ///< nucleic acid probabilities
        e_Ncbi8aa,      ///< 8 bit extended amino acid codes
        e_Ncbieaa,      ///< extended ASCII 1 letter aa codes
        e_Ncbipaa,      ///< amino acid probabilities
        e_Ncbistdaa,    ///< consecutive codes for std aas
        e_Gap           ///< gap types
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 12 ///< == e_Gap+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CIUPACna TIupacna;
    typedef CIUPACaa TIupacaa;
    typedef CNCBI2na TNcbi2na;
    typedef CNCBI4na TNcbi4na;
    typedef CNCBI8na TNcbi8na;
    typedef CNCBIpna TNcbipna;
    typedef CNCBI8aa TNcbi8aa;
    typedef CNCBIeaa TNcbieaa;
    typedef CNCBIpaa TNcbipaa;
    typedef CNCBIstdaa TNcbistdaa;
    typedef CSeq_gap TGap;

    // getters
    // setters

    // typedef CIUPACna TIupacna
    bool IsIupacna(void) const;
    const TIupacna& GetIupacna(void) const;
    TIupacna& SetIupacna(void);
    void SetIupacna(const TIupacna& value);

    // typedef CIUPACaa TIupacaa
    bool IsIupacaa(void) const;
    const TIupacaa& GetIupacaa(void) const;
    TIupacaa& SetIupacaa(void);
    void SetIupacaa(const TIupacaa& value);

    // typedef CNCBI2na TNcbi2na
    bool IsNcbi2na(void) const;
    const TNcbi2na& GetNcbi2na(void) const;
    TNcbi2na& SetNcbi2na(void);

    // typedef CNCBI4na TNcbi4na
    bool IsNcbi4na(void) const;
    const TNcbi4na& GetNcbi4na(void) const;
    TNcbi4na& SetNcbi4na(void);

    // typedef CNCBI8na TNcbi8na
    bool IsNcbi8na(void) const;
    const TNcbi8na& GetNcbi8na(void) const;
    TNcbi8na& SetNcbi8na(void);

    // typedef CNCBIpna TNcbipna
    bool IsNcbipna(void) const;
    const TNcbipna& GetNcbipna(void) const;
    TNcbipna& SetNcbipna(void);

    // typedef CNCBI8aa TNcbi8aa
    bool IsNcbi8aa(void) const;
    const TNcbi8aa& GetNcbi8aa(void) const;
    TNcbi8aa& SetNcbi8aa(void);

    // typedef CNCBIeaa TNcbieaa
    bool IsNcbieaa(void) const;
    const TNcbieaa& GetNcbieaa(void) const;
    TNcbieaa& SetNcbieaa(void);
    void SetNcbieaa(const TNcbieaa& value);

    // typedef CNCBIpaa TNcbipaa
    bool IsNcbipaa(void) const;
    const TNcbipaa& GetNcbipaa(void) const;
    TNcbipaa& SetNcbipaa(void);

    // typedef CNCBIstdaa TNcbistdaa
    bool IsNcbistdaa(void) const;
    const TNcbistdaa& GetNcbistdaa(void) const;
    TNcbistdaa& SetNcbistdaa(void);

    // typedef CSeq_gap TGap
    bool IsGap(void) const;
    const TGap& GetGap(void) const;
    TGap& SetGap(void);
    void SetGap(TGap& value);


private:
    // copy constructor and assignment operator
    CSeq_data_Base(const CSeq_data_Base& );
    CSeq_data_Base& operator=(const CSeq_data_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<TIupacna> m_Iupacna;
        NCBI_NS_NCBI::CUnionBuffer<TIupacaa> m_Iupacaa;
        NCBI_NS_NCBI::CUnionBuffer<TNcbi2na> m_Ncbi2na;
        NCBI_NS_NCBI::CUnionBuffer<TNcbi4na> m_Ncbi4na;
        NCBI_NS_NCBI::CUnionBuffer<TNcbi8na> m_Ncbi8na;
        NCBI_NS_NCBI::CUnionBuffer<TNcbipna> m_Ncbipna;
        NCBI_NS_NCBI::CUnionBuffer<TNcbi8aa> m_Ncbi8aa;
        NCBI_NS_NCBI::CUnionBuffer<TNcbieaa> m_Ncbieaa;
        NCBI_NS_NCBI::CUnionBuffer<TNcbipaa> m_Ncbipaa;
        NCBI_NS_NCBI::CUnionBuffer<TNcbistdaa> m_Ncbistdaa;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSeq_data_Base::E_Choice CSeq_data_Base::Which(void) const
{
    return m_choice;
}

inline
void CSeq_data_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSeq_data_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSeq_data_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSeq_data_Base::IsIupacna(void) const
{
    return m_choice == e_Iupacna;
}

inline
const CSeq_data_Base::TIupacna& CSeq_data_Base::GetIupacna(void) const
{
    CheckSelected(e_Iupacna);
    return *m_Iupacna;
}

inline
CSeq_data_Base::TIupacna& CSeq_data_Base::SetIupacna(void)
{
    Select(e_Iupacna, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Iupacna;
}

inline
bool CSeq_data_Base::IsIupacaa(void) const
{
    return m_choice == e_Iupacaa;
}

inline
const CSeq_data_Base::TIupacaa& CSeq_data_Base::GetIupacaa(void) const
{
    CheckSelected(e_Iupacaa);
    return *m_Iupacaa;
}

inline
CSeq_data_Base::TIupacaa& CSeq_data_Base::SetIupacaa(void)
{
    Select(e_Iupacaa, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Iupacaa;
}

inline
bool CSeq_data_Base::IsNcbi2na(void) const
{
    return m_choice == e_Ncbi2na;
}

inline
const CSeq_data_Base::TNcbi2na& CSeq_data_Base::GetNcbi2na(void) const
{
    CheckSelected(e_Ncbi2na);
    return *m_Ncbi2na;
}

inline
CSeq_data_Base::TNcbi2na& CSeq_data_Base::SetNcbi2na(void)
{
    Select(e_Ncbi2na, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Ncbi2na;
}

inline
bool CSeq_data_Base::IsNcbi4na(void) const
{
    return m_choice == e_Ncbi4na;
}

inline
const CSeq_data_Base::TNcbi4na& CSeq_data_Base::GetNcbi4na(void) const
{
    CheckSelected(e_Ncbi4na);
    return *m_Ncbi4na;
}

inline
CSeq_data_Base::TNcbi4na& CSeq_data_Base::SetNcbi4na(void)
{
    Select(e_Ncbi4na, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Ncbi4na;
}

inline
bool CSeq_data_Base::IsNcbi8na(void) const
{
    return m_choice == e_Ncbi8na;
}

inline
const CSeq_data_Base::TNcbi8na& CSeq_data_Base::GetNcbi8na(void) const
{
    CheckSelected(e_Ncbi8na);
    return *m_Ncbi8na;
}

inline
CSeq_data_Base::TNcbi8na& CSeq_data_Base::SetNcbi8na(void)
{
    Select(e_Ncbi8na, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Ncbi8na;
}

inline
bool CSeq_data_Base::IsNcbipna(void) const
{
    return m_choice == e_Ncbipna;
}

inline
const CSeq_data_Base::TNcbipna& CSeq_data_Base::GetNcbipna(void) const
{
    CheckSelected(e_Ncbipna);
    return *m_Ncbipna;
}

inline
CSeq_data_Base::TNcbipna& CSeq_data_Base::SetNcbipna(void)
{
    Select(e_Ncbipna, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Ncbipna;
}

inline
bool CSeq_data_Base::IsNcbi8aa(void) const
{
    return m_choice == e_Ncbi8aa;
}

inline
const CSeq_data_Base::TNcbi8aa& CSeq_data_Base::GetNcbi8aa(void) const
{
    CheckSelected(e_Ncbi8aa);
    return *m_Ncbi8aa;
}

inline
CSeq_data_Base::TNcbi8aa& CSeq_data_Base::SetNcbi8aa(void)
{
    Select(e_Ncbi8aa, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Ncbi8aa;
}

inline
bool CSeq_data_Base::IsNcbieaa(void) const
{
    return m_choice == e_Ncbieaa;
}

inline
const CSeq_data_Base::TNcbieaa& CSeq_data_Base::GetNcbieaa(void) const
{
    CheckSelected(e_Ncbieaa);
    return *m_Ncbieaa;
}

inline
CSeq_data_Base::TNcbieaa& CSeq_data_Base::SetNcbieaa(void)
{
    Select(e_Ncbieaa, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Ncbieaa;
}

inline
bool CSeq_data_Base::IsNcbipaa(void) const
{
    return m_choice == e_Ncbipaa;
}

inline
const CSeq_data_Base::TNcbipaa& CSeq_data_Base::GetNcbipaa(void) const
{
    CheckSelected(e_Ncbipaa);
    return *m_Ncbipaa;
}

inline
CSeq_data_Base::TNcbipaa& CSeq_data_Base::SetNcbipaa(void)
{
    Select(e_Ncbipaa, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Ncbipaa;
}

inline
bool CSeq_data_Base::IsNcbistdaa(void) const
{
    return m_choice == e_Ncbistdaa;
}

inline
const CSeq_data_Base::TNcbistdaa& CSeq_data_Base::GetNcbistdaa(void) const
{
    CheckSelected(e_Ncbistdaa);
    return *m_Ncbistdaa;
}

inline
CSeq_data_Base::TNcbistdaa& CSeq_data_Base::SetNcbistdaa(void)
{
    Select(e_Ncbistdaa, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Ncbistdaa;
}

inline
bool CSeq_data_Base::IsGap(void) const
{
    return m_choice == e_Gap;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_SEQ_DATA_BASE_HPP
