/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Annotdesc_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_ANNOTDESC_BASE_HPP
#define OBJECTS_SEQ_ANNOTDESC_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAlign_def;
class CDate;
class CPubdesc;
class CSeq_id;
class CSeq_loc;
class CUser_object;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CAnnotdesc_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAnnotdesc_Base(void);
    // destructor
    virtual ~CAnnotdesc_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Name,         ///< a short name for this collection
        e_Title,        ///< a title for this collection
        e_Comment,      ///< a more extensive comment
        e_Pub,          ///< a reference to the publication
        e_User,         ///< user defined object
        e_Create_date,  ///< date entry first created/released
        e_Update_date,  ///< date of last update
        e_Src,          ///< source sequence from which annot came
        e_Align,        ///< definition of the SeqAligns
        e_Region        ///< all contents cover this region
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 11 ///< == e_Region+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef string TName;
    typedef string TTitle;
    typedef string TComment;
    typedef CPubdesc TPub;
    typedef CUser_object TUser;
    typedef CDate TCreate_date;
    typedef CDate TUpdate_date;
    typedef CSeq_id TSrc;
    typedef CAlign_def TAlign;
    typedef CSeq_loc TRegion;

    // getters
    // setters

    // typedef string TName
    bool IsName(void) const;
    const TName& GetName(void) const;
    TName& SetName(void);
    void SetName(const TName& value);

    // typedef string TTitle
    bool IsTitle(void) const;
    const TTitle& GetTitle(void) const;
    TTitle& SetTitle(void);
    void SetTitle(const TTitle& value);

    // typedef string TComment
    bool IsComment(void) const;
    const TComment& GetComment(void) const;
    TComment& SetComment(void);
    void SetComment(const TComment& value);

    // typedef CPubdesc TPub
    bool IsPub(void) const;
    const TPub& GetPub(void) const;
    TPub& SetPub(void);
    void SetPub(TPub& value);

    // typedef CUser_object TUser
    bool IsUser(void) const;
    const TUser& GetUser(void) const;
    TUser& SetUser(void);
    void SetUser(TUser& value);

    // typedef CDate TCreate_date
    bool IsCreate_date(void) const;
    const TCreate_date& GetCreate_date(void) const;
    TCreate_date& SetCreate_date(void);
    void SetCreate_date(TCreate_date& value);

    // typedef CDate TUpdate_date
    bool IsUpdate_date(void) const;
    const TUpdate_date& GetUpdate_date(void) const;
    TUpdate_date& SetUpdate_date(void);
    void SetUpdate_date(TUpdate_date& value);

    // typedef CSeq_id TSrc
    bool IsSrc(void) const;
    const TSrc& GetSrc(void) const;
    TSrc& SetSrc(void);
    void SetSrc(TSrc& value);

    // typedef CAlign_def TAlign
    bool IsAlign(void) const;
    const TAlign& GetAlign(void) const;
    TAlign& SetAlign(void);
    void SetAlign(TAlign& value);

    // typedef CSeq_loc TRegion
    bool IsRegion(void) const;
    const TRegion& GetRegion(void) const;
    TRegion& SetRegion(void);
    void SetRegion(TRegion& value);


private:
    // copy constructor and assignment operator
    CAnnotdesc_Base(const CAnnotdesc_Base& );
    CAnnotdesc_Base& operator=(const CAnnotdesc_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CAnnotdesc_Base::E_Choice CAnnotdesc_Base::Which(void) const
{
    return m_choice;
}

inline
void CAnnotdesc_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CAnnotdesc_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CAnnotdesc_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CAnnotdesc_Base::IsName(void) const
{
    return m_choice == e_Name;
}

inline
const CAnnotdesc_Base::TName& CAnnotdesc_Base::GetName(void) const
{
    CheckSelected(e_Name);
    return *m_string;
}

inline
CAnnotdesc_Base::TName& CAnnotdesc_Base::SetName(void)
{
    Select(e_Name, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CAnnotdesc_Base::IsTitle(void) const
{
    return m_choice == e_Title;
}

inline
const CAnnotdesc_Base::TTitle& CAnnotdesc_Base::GetTitle(void) const
{
    CheckSelected(e_Title);
    return *m_string;
}

inline
CAnnotdesc_Base::TTitle& CAnnotdesc_Base::SetTitle(void)
{
    Select(e_Title, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CAnnotdesc_Base::IsComment(void) const
{
    return m_choice == e_Comment;
}

inline
const CAnnotdesc_Base::TComment& CAnnotdesc_Base::GetComment(void) const
{
    CheckSelected(e_Comment);
    return *m_string;
}

inline
CAnnotdesc_Base::TComment& CAnnotdesc_Base::SetComment(void)
{
    Select(e_Comment, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CAnnotdesc_Base::IsPub(void) const
{
    return m_choice == e_Pub;
}

inline
bool CAnnotdesc_Base::IsUser(void) const
{
    return m_choice == e_User;
}

inline
bool CAnnotdesc_Base::IsCreate_date(void) const
{
    return m_choice == e_Create_date;
}

inline
bool CAnnotdesc_Base::IsUpdate_date(void) const
{
    return m_choice == e_Update_date;
}

inline
bool CAnnotdesc_Base::IsSrc(void) const
{
    return m_choice == e_Src;
}

inline
bool CAnnotdesc_Base::IsAlign(void) const
{
    return m_choice == e_Align;
}

inline
bool CAnnotdesc_Base::IsRegion(void) const
{
    return m_choice == e_Region;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_ANNOTDESC_BASE_HPP
