/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Project_item_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'proj.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PROJ_PROJECT_ITEM_BASE_HPP
#define OBJECTS_PROJ_PROJECT_ITEM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/biblio/PubMedId.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CProject;
class CPubmed_entry;
class CSeq_annot;
class CSeq_entry;
class CSeq_id;
class CSeq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_PROJ_EXPORT CProject_item_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CProject_item_Base(void);
    // destructor
    virtual ~CProject_item_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Pmuid,
        e_Protuid,
        e_Nucuid,
        e_Sequid,
        e_Genomeuid,
        e_Structuid,
        e_Pmid,
        e_Protid,
        e_Nucid,
        e_Seqid,
        e_Genomeid,
        e_Structid,
        e_Pment,
        e_Protent,
        e_Nucent,
        e_Seqent,
        e_Genomeent,
        e_Structent,
        e_Seqannot,
        e_Loc,
        e_Proj
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 22 ///< == e_Proj+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef list< int > TPmuid;
    typedef list< int > TProtuid;
    typedef list< int > TNucuid;
    typedef list< int > TSequid;
    typedef list< int > TGenomeuid;
    typedef list< int > TStructuid;
    typedef list< CPubMedId > TPmid;
    typedef list< CRef< CSeq_id > > TProtid;
    typedef list< CRef< CSeq_id > > TNucid;
    typedef list< CRef< CSeq_id > > TSeqid;
    typedef list< CRef< CSeq_id > > TGenomeid;
    typedef list< CRef< CPubmed_entry > > TPment;
    typedef list< CRef< CSeq_entry > > TProtent;
    typedef list< CRef< CSeq_entry > > TNucent;
    typedef list< CRef< CSeq_entry > > TSeqent;
    typedef list< CRef< CSeq_entry > > TGenomeent;
    typedef list< CRef< CSeq_annot > > TSeqannot;
    typedef list< CRef< CSeq_loc > > TLoc;
    typedef list< CRef< CProject > > TProj;

    // getters
    // setters

    // typedef list< int > TPmuid
    bool IsPmuid(void) const;
    const TPmuid& GetPmuid(void) const;
    TPmuid& SetPmuid(void);

    // typedef list< int > TProtuid
    bool IsProtuid(void) const;
    const TProtuid& GetProtuid(void) const;
    TProtuid& SetProtuid(void);

    // typedef list< int > TNucuid
    bool IsNucuid(void) const;
    const TNucuid& GetNucuid(void) const;
    TNucuid& SetNucuid(void);

    // typedef list< int > TSequid
    bool IsSequid(void) const;
    const TSequid& GetSequid(void) const;
    TSequid& SetSequid(void);

    // typedef list< int > TGenomeuid
    bool IsGenomeuid(void) const;
    const TGenomeuid& GetGenomeuid(void) const;
    TGenomeuid& SetGenomeuid(void);

    // typedef list< int > TStructuid
    bool IsStructuid(void) const;
    const TStructuid& GetStructuid(void) const;
    TStructuid& SetStructuid(void);

    // typedef list< CPubMedId > TPmid
    bool IsPmid(void) const;
    const TPmid& GetPmid(void) const;
    TPmid& SetPmid(void);

    // typedef list< CRef< CSeq_id > > TProtid
    bool IsProtid(void) const;
    const TProtid& GetProtid(void) const;
    TProtid& SetProtid(void);

    // typedef list< CRef< CSeq_id > > TNucid
    bool IsNucid(void) const;
    const TNucid& GetNucid(void) const;
    TNucid& SetNucid(void);

    // typedef list< CRef< CSeq_id > > TSeqid
    bool IsSeqid(void) const;
    const TSeqid& GetSeqid(void) const;
    TSeqid& SetSeqid(void);

    // typedef list< CRef< CSeq_id > > TGenomeid
    bool IsGenomeid(void) const;
    const TGenomeid& GetGenomeid(void) const;
    TGenomeid& SetGenomeid(void);


    bool IsStructid(void) const;
    void SetStructid(void);

    // typedef list< CRef< CPubmed_entry > > TPment
    bool IsPment(void) const;
    const TPment& GetPment(void) const;
    TPment& SetPment(void);

    // typedef list< CRef< CSeq_entry > > TProtent
    bool IsProtent(void) const;
    const TProtent& GetProtent(void) const;
    TProtent& SetProtent(void);

    // typedef list< CRef< CSeq_entry > > TNucent
    bool IsNucent(void) const;
    const TNucent& GetNucent(void) const;
    TNucent& SetNucent(void);

    // typedef list< CRef< CSeq_entry > > TSeqent
    bool IsSeqent(void) const;
    const TSeqent& GetSeqent(void) const;
    TSeqent& SetSeqent(void);

    // typedef list< CRef< CSeq_entry > > TGenomeent
    bool IsGenomeent(void) const;
    const TGenomeent& GetGenomeent(void) const;
    TGenomeent& SetGenomeent(void);


    bool IsStructent(void) const;
    void SetStructent(void);

    // typedef list< CRef< CSeq_annot > > TSeqannot
    bool IsSeqannot(void) const;
    const TSeqannot& GetSeqannot(void) const;
    TSeqannot& SetSeqannot(void);

    // typedef list< CRef< CSeq_loc > > TLoc
    bool IsLoc(void) const;
    const TLoc& GetLoc(void) const;
    TLoc& SetLoc(void);

    // typedef list< CRef< CProject > > TProj
    bool IsProj(void) const;
    const TProj& GetProj(void) const;
    TProj& SetProj(void);


private:
    // copy constructor and assignment operator
    CProject_item_Base(const CProject_item_Base& );
    CProject_item_Base& operator=(const CProject_item_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<TPmuid> m_Pmuid;
        NCBI_NS_NCBI::CUnionBuffer<TProtuid> m_Protuid;
        NCBI_NS_NCBI::CUnionBuffer<TNucuid> m_Nucuid;
        NCBI_NS_NCBI::CUnionBuffer<TSequid> m_Sequid;
        NCBI_NS_NCBI::CUnionBuffer<TGenomeuid> m_Genomeuid;
        NCBI_NS_NCBI::CUnionBuffer<TStructuid> m_Structuid;
        NCBI_NS_NCBI::CUnionBuffer<TPmid> m_Pmid;
        NCBI_NS_NCBI::CUnionBuffer<TProtid> m_Protid;
        NCBI_NS_NCBI::CUnionBuffer<TNucid> m_Nucid;
        NCBI_NS_NCBI::CUnionBuffer<TSeqid> m_Seqid;
        NCBI_NS_NCBI::CUnionBuffer<TGenomeid> m_Genomeid;
        NCBI_NS_NCBI::CUnionBuffer<TPment> m_Pment;
        NCBI_NS_NCBI::CUnionBuffer<TProtent> m_Protent;
        NCBI_NS_NCBI::CUnionBuffer<TNucent> m_Nucent;
        NCBI_NS_NCBI::CUnionBuffer<TSeqent> m_Seqent;
        NCBI_NS_NCBI::CUnionBuffer<TGenomeent> m_Genomeent;
        NCBI_NS_NCBI::CUnionBuffer<TSeqannot> m_Seqannot;
        NCBI_NS_NCBI::CUnionBuffer<TLoc> m_Loc;
        NCBI_NS_NCBI::CUnionBuffer<TProj> m_Proj;
        void* m_dummy_pointer_for_alignment;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CProject_item_Base::E_Choice CProject_item_Base::Which(void) const
{
    return m_choice;
}

inline
void CProject_item_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CProject_item_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CProject_item_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CProject_item_Base::IsPmuid(void) const
{
    return m_choice == e_Pmuid;
}

inline
const CProject_item_Base::TPmuid& CProject_item_Base::GetPmuid(void) const
{
    CheckSelected(e_Pmuid);
    return *m_Pmuid;
}

inline
CProject_item_Base::TPmuid& CProject_item_Base::SetPmuid(void)
{
    Select(e_Pmuid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Pmuid;
}

inline
bool CProject_item_Base::IsProtuid(void) const
{
    return m_choice == e_Protuid;
}

inline
const CProject_item_Base::TProtuid& CProject_item_Base::GetProtuid(void) const
{
    CheckSelected(e_Protuid);
    return *m_Protuid;
}

inline
CProject_item_Base::TProtuid& CProject_item_Base::SetProtuid(void)
{
    Select(e_Protuid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Protuid;
}

inline
bool CProject_item_Base::IsNucuid(void) const
{
    return m_choice == e_Nucuid;
}

inline
const CProject_item_Base::TNucuid& CProject_item_Base::GetNucuid(void) const
{
    CheckSelected(e_Nucuid);
    return *m_Nucuid;
}

inline
CProject_item_Base::TNucuid& CProject_item_Base::SetNucuid(void)
{
    Select(e_Nucuid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Nucuid;
}

inline
bool CProject_item_Base::IsSequid(void) const
{
    return m_choice == e_Sequid;
}

inline
const CProject_item_Base::TSequid& CProject_item_Base::GetSequid(void) const
{
    CheckSelected(e_Sequid);
    return *m_Sequid;
}

inline
CProject_item_Base::TSequid& CProject_item_Base::SetSequid(void)
{
    Select(e_Sequid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Sequid;
}

inline
bool CProject_item_Base::IsGenomeuid(void) const
{
    return m_choice == e_Genomeuid;
}

inline
const CProject_item_Base::TGenomeuid& CProject_item_Base::GetGenomeuid(void) const
{
    CheckSelected(e_Genomeuid);
    return *m_Genomeuid;
}

inline
CProject_item_Base::TGenomeuid& CProject_item_Base::SetGenomeuid(void)
{
    Select(e_Genomeuid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Genomeuid;
}

inline
bool CProject_item_Base::IsStructuid(void) const
{
    return m_choice == e_Structuid;
}

inline
const CProject_item_Base::TStructuid& CProject_item_Base::GetStructuid(void) const
{
    CheckSelected(e_Structuid);
    return *m_Structuid;
}

inline
CProject_item_Base::TStructuid& CProject_item_Base::SetStructuid(void)
{
    Select(e_Structuid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Structuid;
}

inline
bool CProject_item_Base::IsPmid(void) const
{
    return m_choice == e_Pmid;
}

inline
const CProject_item_Base::TPmid& CProject_item_Base::GetPmid(void) const
{
    CheckSelected(e_Pmid);
    return *m_Pmid;
}

inline
CProject_item_Base::TPmid& CProject_item_Base::SetPmid(void)
{
    Select(e_Pmid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Pmid;
}

inline
bool CProject_item_Base::IsProtid(void) const
{
    return m_choice == e_Protid;
}

inline
const CProject_item_Base::TProtid& CProject_item_Base::GetProtid(void) const
{
    CheckSelected(e_Protid);
    return *m_Protid;
}

inline
CProject_item_Base::TProtid& CProject_item_Base::SetProtid(void)
{
    Select(e_Protid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Protid;
}

inline
bool CProject_item_Base::IsNucid(void) const
{
    return m_choice == e_Nucid;
}

inline
const CProject_item_Base::TNucid& CProject_item_Base::GetNucid(void) const
{
    CheckSelected(e_Nucid);
    return *m_Nucid;
}

inline
CProject_item_Base::TNucid& CProject_item_Base::SetNucid(void)
{
    Select(e_Nucid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Nucid;
}

inline
bool CProject_item_Base::IsSeqid(void) const
{
    return m_choice == e_Seqid;
}

inline
const CProject_item_Base::TSeqid& CProject_item_Base::GetSeqid(void) const
{
    CheckSelected(e_Seqid);
    return *m_Seqid;
}

inline
CProject_item_Base::TSeqid& CProject_item_Base::SetSeqid(void)
{
    Select(e_Seqid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Seqid;
}

inline
bool CProject_item_Base::IsGenomeid(void) const
{
    return m_choice == e_Genomeid;
}

inline
const CProject_item_Base::TGenomeid& CProject_item_Base::GetGenomeid(void) const
{
    CheckSelected(e_Genomeid);
    return *m_Genomeid;
}

inline
CProject_item_Base::TGenomeid& CProject_item_Base::SetGenomeid(void)
{
    Select(e_Genomeid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Genomeid;
}

inline
bool CProject_item_Base::IsStructid(void) const
{
    return m_choice == e_Structid;
}

inline
void CProject_item_Base::SetStructid(void)
{
    Select(e_Structid, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CProject_item_Base::IsPment(void) const
{
    return m_choice == e_Pment;
}

inline
const CProject_item_Base::TPment& CProject_item_Base::GetPment(void) const
{
    CheckSelected(e_Pment);
    return *m_Pment;
}

inline
CProject_item_Base::TPment& CProject_item_Base::SetPment(void)
{
    Select(e_Pment, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Pment;
}

inline
bool CProject_item_Base::IsProtent(void) const
{
    return m_choice == e_Protent;
}

inline
const CProject_item_Base::TProtent& CProject_item_Base::GetProtent(void) const
{
    CheckSelected(e_Protent);
    return *m_Protent;
}

inline
CProject_item_Base::TProtent& CProject_item_Base::SetProtent(void)
{
    Select(e_Protent, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Protent;
}

inline
bool CProject_item_Base::IsNucent(void) const
{
    return m_choice == e_Nucent;
}

inline
const CProject_item_Base::TNucent& CProject_item_Base::GetNucent(void) const
{
    CheckSelected(e_Nucent);
    return *m_Nucent;
}

inline
CProject_item_Base::TNucent& CProject_item_Base::SetNucent(void)
{
    Select(e_Nucent, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Nucent;
}

inline
bool CProject_item_Base::IsSeqent(void) const
{
    return m_choice == e_Seqent;
}

inline
const CProject_item_Base::TSeqent& CProject_item_Base::GetSeqent(void) const
{
    CheckSelected(e_Seqent);
    return *m_Seqent;
}

inline
CProject_item_Base::TSeqent& CProject_item_Base::SetSeqent(void)
{
    Select(e_Seqent, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Seqent;
}

inline
bool CProject_item_Base::IsGenomeent(void) const
{
    return m_choice == e_Genomeent;
}

inline
const CProject_item_Base::TGenomeent& CProject_item_Base::GetGenomeent(void) const
{
    CheckSelected(e_Genomeent);
    return *m_Genomeent;
}

inline
CProject_item_Base::TGenomeent& CProject_item_Base::SetGenomeent(void)
{
    Select(e_Genomeent, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Genomeent;
}

inline
bool CProject_item_Base::IsStructent(void) const
{
    return m_choice == e_Structent;
}

inline
void CProject_item_Base::SetStructent(void)
{
    Select(e_Structent, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CProject_item_Base::IsSeqannot(void) const
{
    return m_choice == e_Seqannot;
}

inline
const CProject_item_Base::TSeqannot& CProject_item_Base::GetSeqannot(void) const
{
    CheckSelected(e_Seqannot);
    return *m_Seqannot;
}

inline
CProject_item_Base::TSeqannot& CProject_item_Base::SetSeqannot(void)
{
    Select(e_Seqannot, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Seqannot;
}

inline
bool CProject_item_Base::IsLoc(void) const
{
    return m_choice == e_Loc;
}

inline
const CProject_item_Base::TLoc& CProject_item_Base::GetLoc(void) const
{
    CheckSelected(e_Loc);
    return *m_Loc;
}

inline
CProject_item_Base::TLoc& CProject_item_Base::SetLoc(void)
{
    Select(e_Loc, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Loc;
}

inline
bool CProject_item_Base::IsProj(void) const
{
    return m_choice == e_Proj;
}

inline
const CProject_item_Base::TProj& CProject_item_Base::GetProj(void) const
{
    CheckSelected(e_Proj);
    return *m_Proj;
}

inline
CProject_item_Base::TProj& CProject_item_Base::SetProj(void)
{
    Select(e_Proj, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Proj;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PROJ_PROJECT_ITEM_BASE_HPP
