/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_Urn_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_URN_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_URN_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/pcsubstance/PC_UrnDataType.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Universal Resource Name
///    Provides explicit source information on derived or calculated data
class NCBI_PCSUBSTANCE_EXPORT CPC_Urn_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_Urn_Base(void);
    // destructor
    virtual ~CPC_Urn_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TLabel;
    typedef string TName;
    typedef int TDatatype;
    typedef string TParameters;
    typedef string TImplementation;
    typedef string TVersion;
    typedef string TSoftware;
    typedef string TSource;
    typedef string TRelease;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_label,
        e_name,
        e_datatype,
        e_parameters,
        e_implementation,
        e_version,
        e_software,
        e_source,
        e_release
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;

    // getters
    // setters

    /// Generic Name or Label for Display  [e.g., "Log P"]
    /// mandatory
    /// typedef string TLabel
    ///  Check whether the Label data member has been assigned a value.
    bool IsSetLabel(void) const;
    /// Check whether it is safe or not to call GetLabel method.
    bool CanGetLabel(void) const;
    void ResetLabel(void);
    const TLabel& GetLabel(void) const;
    void SetLabel(const TLabel& value);
    void SetLabel(TLabel&& value);
    TLabel& SetLabel(void);

    /// Qualified Name  [e.g., "XlogP"]
    /// optional
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// Specific Data Type of Value  [e.g., binary]
    /// optional
    /// typedef int TDatatype
    ///  Check whether the Datatype data member has been assigned a value.
    bool IsSetDatatype(void) const;
    /// Check whether it is safe or not to call GetDatatype method.
    bool CanGetDatatype(void) const;
    void ResetDatatype(void);
    TDatatype GetDatatype(void) const;
    void SetDatatype(TDatatype value);
    TDatatype& SetDatatype(void);

    /// Implementation Parameter  [e.g., "metal=0"]
    /// optional
    /// typedef string TParameters
    ///  Check whether the Parameters data member has been assigned a value.
    bool IsSetParameters(void) const;
    /// Check whether it is safe or not to call GetParameters method.
    bool CanGetParameters(void) const;
    void ResetParameters(void);
    const TParameters& GetParameters(void) const;
    void SetParameters(const TParameters& value);
    void SetParameters(TParameters&& value);
    TParameters& SetParameters(void);

    /// Implementation Name  [e.g., "E_XlogP"]
    /// optional
    /// typedef string TImplementation
    ///  Check whether the Implementation data member has been assigned a value.
    bool IsSetImplementation(void) const;
    /// Check whether it is safe or not to call GetImplementation method.
    bool CanGetImplementation(void) const;
    void ResetImplementation(void);
    const TImplementation& GetImplementation(void) const;
    void SetImplementation(const TImplementation& value);
    void SetImplementation(TImplementation&& value);
    TImplementation& SetImplementation(void);

    /// Implementation Version  [e.g., "3.317"]
    /// optional
    /// typedef string TVersion
    ///  Check whether the Version data member has been assigned a value.
    bool IsSetVersion(void) const;
    /// Check whether it is safe or not to call GetVersion method.
    bool CanGetVersion(void) const;
    void ResetVersion(void);
    const TVersion& GetVersion(void) const;
    void SetVersion(const TVersion& value);
    void SetVersion(TVersion&& value);
    TVersion& SetVersion(void);

    /// Implementation Software  [e.g., "Cactvs"]
    /// optional
    /// typedef string TSoftware
    ///  Check whether the Software data member has been assigned a value.
    bool IsSetSoftware(void) const;
    /// Check whether it is safe or not to call GetSoftware method.
    bool CanGetSoftware(void) const;
    void ResetSoftware(void);
    const TSoftware& GetSoftware(void) const;
    void SetSoftware(const TSoftware& value);
    void SetSoftware(TSoftware&& value);
    TSoftware& SetSoftware(void);

    /// Implementation Organization  [e.g., "xemistry.com"]
    /// optional
    /// typedef string TSource
    ///  Check whether the Source data member has been assigned a value.
    bool IsSetSource(void) const;
    /// Check whether it is safe or not to call GetSource method.
    bool CanGetSource(void) const;
    void ResetSource(void);
    const TSource& GetSource(void) const;
    void SetSource(const TSource& value);
    void SetSource(TSource&& value);
    TSource& SetSource(void);

    /// NCBI Implementation Release  [e.g., "10.25.2005"]
    /// optional
    /// typedef string TRelease
    ///  Check whether the Release data member has been assigned a value.
    bool IsSetRelease(void) const;
    /// Check whether it is safe or not to call GetRelease method.
    bool CanGetRelease(void) const;
    void ResetRelease(void);
    const TRelease& GetRelease(void) const;
    void SetRelease(const TRelease& value);
    void SetRelease(TRelease&& value);
    TRelease& SetRelease(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_Urn_Base(const CPC_Urn_Base&);
    CPC_Urn_Base& operator=(const CPC_Urn_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Label;
    string m_Name;
    int m_Datatype;
    string m_Parameters;
    string m_Implementation;
    string m_Version;
    string m_Software;
    string m_Source;
    string m_Release;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_Urn_Base::IsSetLabel(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_Urn_Base::CanGetLabel(void) const
{
    return IsSetLabel();
}

inline
const CPC_Urn_Base::TLabel& CPC_Urn_Base::GetLabel(void) const
{
    if (!CanGetLabel()) {
        ThrowUnassigned(0);
    }
    return m_Label;
}

inline
void CPC_Urn_Base::SetLabel(const CPC_Urn_Base::TLabel& value)
{
    m_Label = value;
    m_set_State[0] |= 0x3;
}

inline
void CPC_Urn_Base::SetLabel(CPC_Urn_Base::TLabel&& value)
{
    m_Label = std::forward<CPC_Urn_Base::TLabel>(value);
    m_set_State[0] |= 0x3;
}

inline
CPC_Urn_Base::TLabel& CPC_Urn_Base::SetLabel(void)
{
#ifdef _DEBUG
    if (!IsSetLabel()) {
        m_Label = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Label;
}

inline
bool CPC_Urn_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_Urn_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CPC_Urn_Base::TName& CPC_Urn_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(1);
    }
    return m_Name;
}

inline
void CPC_Urn_Base::SetName(const CPC_Urn_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0xc;
}

inline
void CPC_Urn_Base::SetName(CPC_Urn_Base::TName&& value)
{
    m_Name = std::forward<CPC_Urn_Base::TName>(value);
    m_set_State[0] |= 0xc;
}

inline
CPC_Urn_Base::TName& CPC_Urn_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Name;
}

inline
bool CPC_Urn_Base::IsSetDatatype(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_Urn_Base::CanGetDatatype(void) const
{
    return IsSetDatatype();
}

inline
void CPC_Urn_Base::ResetDatatype(void)
{
    m_Datatype = (int)(0);
    m_set_State[0] &= ~0x30;
}

inline
CPC_Urn_Base::TDatatype CPC_Urn_Base::GetDatatype(void) const
{
    if (!CanGetDatatype()) {
        ThrowUnassigned(2);
    }
    return m_Datatype;
}

inline
void CPC_Urn_Base::SetDatatype(CPC_Urn_Base::TDatatype value)
{
    m_Datatype = value;
    m_set_State[0] |= 0x30;
}

inline
CPC_Urn_Base::TDatatype& CPC_Urn_Base::SetDatatype(void)
{
#ifdef _DEBUG
    if (!IsSetDatatype()) {
        memset(&m_Datatype,UnassignedByte(),sizeof(m_Datatype));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Datatype;
}

inline
bool CPC_Urn_Base::IsSetParameters(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_Urn_Base::CanGetParameters(void) const
{
    return IsSetParameters();
}

inline
const CPC_Urn_Base::TParameters& CPC_Urn_Base::GetParameters(void) const
{
    if (!CanGetParameters()) {
        ThrowUnassigned(3);
    }
    return m_Parameters;
}

inline
void CPC_Urn_Base::SetParameters(const CPC_Urn_Base::TParameters& value)
{
    m_Parameters = value;
    m_set_State[0] |= 0xc0;
}

inline
void CPC_Urn_Base::SetParameters(CPC_Urn_Base::TParameters&& value)
{
    m_Parameters = std::forward<CPC_Urn_Base::TParameters>(value);
    m_set_State[0] |= 0xc0;
}

inline
CPC_Urn_Base::TParameters& CPC_Urn_Base::SetParameters(void)
{
#ifdef _DEBUG
    if (!IsSetParameters()) {
        m_Parameters = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Parameters;
}

inline
bool CPC_Urn_Base::IsSetImplementation(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPC_Urn_Base::CanGetImplementation(void) const
{
    return IsSetImplementation();
}

inline
const CPC_Urn_Base::TImplementation& CPC_Urn_Base::GetImplementation(void) const
{
    if (!CanGetImplementation()) {
        ThrowUnassigned(4);
    }
    return m_Implementation;
}

inline
void CPC_Urn_Base::SetImplementation(const CPC_Urn_Base::TImplementation& value)
{
    m_Implementation = value;
    m_set_State[0] |= 0x300;
}

inline
void CPC_Urn_Base::SetImplementation(CPC_Urn_Base::TImplementation&& value)
{
    m_Implementation = std::forward<CPC_Urn_Base::TImplementation>(value);
    m_set_State[0] |= 0x300;
}

inline
CPC_Urn_Base::TImplementation& CPC_Urn_Base::SetImplementation(void)
{
#ifdef _DEBUG
    if (!IsSetImplementation()) {
        m_Implementation = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Implementation;
}

inline
bool CPC_Urn_Base::IsSetVersion(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPC_Urn_Base::CanGetVersion(void) const
{
    return IsSetVersion();
}

inline
const CPC_Urn_Base::TVersion& CPC_Urn_Base::GetVersion(void) const
{
    if (!CanGetVersion()) {
        ThrowUnassigned(5);
    }
    return m_Version;
}

inline
void CPC_Urn_Base::SetVersion(const CPC_Urn_Base::TVersion& value)
{
    m_Version = value;
    m_set_State[0] |= 0xc00;
}

inline
void CPC_Urn_Base::SetVersion(CPC_Urn_Base::TVersion&& value)
{
    m_Version = std::forward<CPC_Urn_Base::TVersion>(value);
    m_set_State[0] |= 0xc00;
}

inline
CPC_Urn_Base::TVersion& CPC_Urn_Base::SetVersion(void)
{
#ifdef _DEBUG
    if (!IsSetVersion()) {
        m_Version = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Version;
}

inline
bool CPC_Urn_Base::IsSetSoftware(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CPC_Urn_Base::CanGetSoftware(void) const
{
    return IsSetSoftware();
}

inline
const CPC_Urn_Base::TSoftware& CPC_Urn_Base::GetSoftware(void) const
{
    if (!CanGetSoftware()) {
        ThrowUnassigned(6);
    }
    return m_Software;
}

inline
void CPC_Urn_Base::SetSoftware(const CPC_Urn_Base::TSoftware& value)
{
    m_Software = value;
    m_set_State[0] |= 0x3000;
}

inline
void CPC_Urn_Base::SetSoftware(CPC_Urn_Base::TSoftware&& value)
{
    m_Software = std::forward<CPC_Urn_Base::TSoftware>(value);
    m_set_State[0] |= 0x3000;
}

inline
CPC_Urn_Base::TSoftware& CPC_Urn_Base::SetSoftware(void)
{
#ifdef _DEBUG
    if (!IsSetSoftware()) {
        m_Software = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Software;
}

inline
bool CPC_Urn_Base::IsSetSource(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CPC_Urn_Base::CanGetSource(void) const
{
    return IsSetSource();
}

inline
const CPC_Urn_Base::TSource& CPC_Urn_Base::GetSource(void) const
{
    if (!CanGetSource()) {
        ThrowUnassigned(7);
    }
    return m_Source;
}

inline
void CPC_Urn_Base::SetSource(const CPC_Urn_Base::TSource& value)
{
    m_Source = value;
    m_set_State[0] |= 0xc000;
}

inline
void CPC_Urn_Base::SetSource(CPC_Urn_Base::TSource&& value)
{
    m_Source = std::forward<CPC_Urn_Base::TSource>(value);
    m_set_State[0] |= 0xc000;
}

inline
CPC_Urn_Base::TSource& CPC_Urn_Base::SetSource(void)
{
#ifdef _DEBUG
    if (!IsSetSource()) {
        m_Source = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Source;
}

inline
bool CPC_Urn_Base::IsSetRelease(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CPC_Urn_Base::CanGetRelease(void) const
{
    return IsSetRelease();
}

inline
const CPC_Urn_Base::TRelease& CPC_Urn_Base::GetRelease(void) const
{
    if (!CanGetRelease()) {
        ThrowUnassigned(8);
    }
    return m_Release;
}

inline
void CPC_Urn_Base::SetRelease(const CPC_Urn_Base::TRelease& value)
{
    m_Release = value;
    m_set_State[0] |= 0x30000;
}

inline
void CPC_Urn_Base::SetRelease(CPC_Urn_Base::TRelease&& value)
{
    m_Release = std::forward<CPC_Urn_Base::TRelease>(value);
    m_set_State[0] |= 0x30000;
}

inline
CPC_Urn_Base::TRelease& CPC_Urn_Base::SetRelease(void)
{
#ifdef _DEBUG
    if (!IsSetRelease()) {
        m_Release = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Release;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_URN_BASE_HPP
