/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_AssayData_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcassay2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCASSAY2_PC_ASSAYDATA_BASE_HPP
#define OBJECTS_PCASSAY2_PC_ASSAYDATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::

#ifndef BEGIN_pcassay2_SCOPE
#  define BEGIN_pcassay2_SCOPE BEGIN_SCOPE(pcassay2)
#  define END_pcassay2_SCOPE END_SCOPE(pcassay2)
#endif
BEGIN_pcassay2_SCOPE // namespace ncbi::objects::pcassay2::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Assay Readouts/Results for a Tested Substance
class CPC_AssayData_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_AssayData_Base(void);
    // destructor
    virtual ~CPC_AssayData_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    /// Assay Result, must be the same type as defined for TID
    class C_Value : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Value(void);
        // destructor
        ~C_Value(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Ival,
            e_Fval,
            e_Bval,
            e_Sval
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 5 ///< == e_Sval+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef int TIval;
        typedef double TFval;
        typedef bool TBval;
        typedef CStringUTF8 TSval;
    
        // getters
        // setters
    
        // typedef int TIval
        bool IsIval(void) const;
        TIval GetIval(void) const;
        TIval& SetIval(void);
        void SetIval(TIval value);
    
        // typedef double TFval
        bool IsFval(void) const;
        TFval GetFval(void) const;
        TFval& SetFval(void);
        void SetFval(TFval value);
    
        // typedef bool TBval
        bool IsBval(void) const;
        TBval GetBval(void) const;
        TBval& SetBval(void);
        void SetBval(TBval value);
    
        // typedef CStringUTF8 TSval
        bool IsSval(void) const;
        const TSval& GetSval(void) const;
        TSval& SetSval(void);
        void SetSval(const TSval& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Value(const C_Value& );
        C_Value& operator=(const C_Value& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            TIval m_Ival;
            TFval m_Fval;
            TBval m_Bval;
            NCBI_NS_NCBI::CUnionBuffer<CStringUTF8> m_string_utf8;
            void* m_dummy_pointer_for_alignment;
        };
    };
    // types
    typedef int TTid;
    typedef C_Value TValue;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_tid,
        e_value
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Assay Result Field Type ID (TID)
    ///   Note: Result Field ID's must be greater than "0"
    /// mandatory
    /// typedef int TTid
    ///  Check whether the Tid data member has been assigned a value.
    bool IsSetTid(void) const;
    /// Check whether it is safe or not to call GetTid method.
    bool CanGetTid(void) const;
    void ResetTid(void);
    TTid GetTid(void) const;
    void SetTid(TTid value);
    TTid& SetTid(void);

    /// mandatory
    /// typedef C_Value TValue
    ///  Check whether the Value data member has been assigned a value.
    bool IsSetValue(void) const;
    /// Check whether it is safe or not to call GetValue method.
    bool CanGetValue(void) const;
    void ResetValue(void);
    const TValue& GetValue(void) const;
    void SetValue(TValue& value);
    TValue& SetValue(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_AssayData_Base(const CPC_AssayData_Base&);
    CPC_AssayData_Base& operator=(const CPC_AssayData_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Tid;
    CRef< TValue > m_Value;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CPC_AssayData_Base::C_Value::E_Choice CPC_AssayData_Base::C_Value::Which(void) const
{
    return m_choice;
}

inline
void CPC_AssayData_Base::C_Value::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CPC_AssayData_Base::C_Value::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CPC_AssayData_Base::C_Value::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CPC_AssayData_Base::C_Value::IsIval(void) const
{
    return m_choice == e_Ival;
}

inline
CPC_AssayData_Base::C_Value::TIval CPC_AssayData_Base::C_Value::GetIval(void) const
{
    CheckSelected(e_Ival);
    return m_Ival;
}

inline
CPC_AssayData_Base::C_Value::TIval& CPC_AssayData_Base::C_Value::SetIval(void)
{
    Select(e_Ival, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Ival;
}

inline
void CPC_AssayData_Base::C_Value::SetIval(CPC_AssayData_Base::C_Value::TIval value)
{
    Select(e_Ival, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Ival = value;
}

inline
bool CPC_AssayData_Base::C_Value::IsFval(void) const
{
    return m_choice == e_Fval;
}

inline
CPC_AssayData_Base::C_Value::TFval CPC_AssayData_Base::C_Value::GetFval(void) const
{
    CheckSelected(e_Fval);
    return m_Fval;
}

inline
CPC_AssayData_Base::C_Value::TFval& CPC_AssayData_Base::C_Value::SetFval(void)
{
    Select(e_Fval, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Fval;
}

inline
void CPC_AssayData_Base::C_Value::SetFval(CPC_AssayData_Base::C_Value::TFval value)
{
    Select(e_Fval, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Fval = value;
}

inline
bool CPC_AssayData_Base::C_Value::IsBval(void) const
{
    return m_choice == e_Bval;
}

inline
CPC_AssayData_Base::C_Value::TBval CPC_AssayData_Base::C_Value::GetBval(void) const
{
    CheckSelected(e_Bval);
    return m_Bval;
}

inline
CPC_AssayData_Base::C_Value::TBval& CPC_AssayData_Base::C_Value::SetBval(void)
{
    Select(e_Bval, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Bval;
}

inline
void CPC_AssayData_Base::C_Value::SetBval(CPC_AssayData_Base::C_Value::TBval value)
{
    Select(e_Bval, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Bval = value;
}

inline
bool CPC_AssayData_Base::C_Value::IsSval(void) const
{
    return m_choice == e_Sval;
}

inline
const CPC_AssayData_Base::C_Value::TSval& CPC_AssayData_Base::C_Value::GetSval(void) const
{
    CheckSelected(e_Sval);
    return *m_string_utf8;
}

inline
CPC_AssayData_Base::C_Value::TSval& CPC_AssayData_Base::C_Value::SetSval(void)
{
    Select(e_Sval, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string_utf8;
}

inline
bool CPC_AssayData_Base::IsSetTid(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_AssayData_Base::CanGetTid(void) const
{
    return IsSetTid();
}

inline
void CPC_AssayData_Base::ResetTid(void)
{
    m_Tid = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_AssayData_Base::TTid CPC_AssayData_Base::GetTid(void) const
{
    if (!CanGetTid()) {
        ThrowUnassigned(0);
    }
    return m_Tid;
}

inline
void CPC_AssayData_Base::SetTid(CPC_AssayData_Base::TTid value)
{
    m_Tid = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_AssayData_Base::TTid& CPC_AssayData_Base::SetTid(void)
{
#ifdef _DEBUG
    if (!IsSetTid()) {
        memset(&m_Tid,UnassignedByte(),sizeof(m_Tid));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Tid;
}

inline
bool CPC_AssayData_Base::IsSetValue(void) const
{
    return m_Value.NotEmpty();
}

inline
bool CPC_AssayData_Base::CanGetValue(void) const
{
    return true;
}

inline
const CPC_AssayData_Base::TValue& CPC_AssayData_Base::GetValue(void) const
{
    if ( !m_Value ) {
        const_cast<CPC_AssayData_Base*>(this)->ResetValue();
    }
    return (*m_Value);
}

inline
CPC_AssayData_Base::TValue& CPC_AssayData_Base::SetValue(void)
{
    if ( !m_Value ) {
        ResetValue();
    }
    return (*m_Value);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_pcassay2_SCOPE // namespace ncbi::objects::pcassay2::

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCASSAY2_PC_ASSAYDATA_BASE_HPP
