/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSIonAnnot_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSIONANNOT_BASE_HPP
#define OBJECTS_OMSSA_MSIONANNOT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// annotated comments about the ion
class NCBI_OMSSA_EXPORT CMSIonAnnot_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMSIonAnnot_Base(void);
    // destructor
    virtual ~CMSIonAnnot_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef bool TSuspect;
    typedef double TMassdiff;
    typedef bool TMissingisotope;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_suspect,
        e_massdiff,
        e_missingisotope
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// is this peak suspect?
    /// optional
    /// typedef bool TSuspect
    ///  Check whether the Suspect data member has been assigned a value.
    bool IsSetSuspect(void) const;
    /// Check whether it is safe or not to call GetSuspect method.
    bool CanGetSuspect(void) const;
    void ResetSuspect(void);
    TSuspect GetSuspect(void) const;
    void SetSuspect(TSuspect value);
    TSuspect& SetSuspect(void);

    /// what is the difference in mass from library spectrum?
    /// optional
    /// typedef double TMassdiff
    ///  Check whether the Massdiff data member has been assigned a value.
    bool IsSetMassdiff(void) const;
    /// Check whether it is safe or not to call GetMassdiff method.
    bool CanGetMassdiff(void) const;
    void ResetMassdiff(void);
    TMassdiff GetMassdiff(void) const;
    void SetMassdiff(TMassdiff value);
    TMassdiff& SetMassdiff(void);

    /// are the lower mass peaks missing?
    /// optional
    /// typedef bool TMissingisotope
    ///  Check whether the Missingisotope data member has been assigned a value.
    bool IsSetMissingisotope(void) const;
    /// Check whether it is safe or not to call GetMissingisotope method.
    bool CanGetMissingisotope(void) const;
    void ResetMissingisotope(void);
    TMissingisotope GetMissingisotope(void) const;
    void SetMissingisotope(TMissingisotope value);
    TMissingisotope& SetMissingisotope(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMSIonAnnot_Base(const CMSIonAnnot_Base&);
    CMSIonAnnot_Base& operator=(const CMSIonAnnot_Base&);

    // data
    Uint4 m_set_State[1];
    bool m_Suspect;
    double m_Massdiff;
    bool m_Missingisotope;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMSIonAnnot_Base::IsSetSuspect(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMSIonAnnot_Base::CanGetSuspect(void) const
{
    return IsSetSuspect();
}

inline
void CMSIonAnnot_Base::ResetSuspect(void)
{
    m_Suspect = 0;
    m_set_State[0] &= ~0x3;
}

inline
CMSIonAnnot_Base::TSuspect CMSIonAnnot_Base::GetSuspect(void) const
{
    if (!CanGetSuspect()) {
        ThrowUnassigned(0);
    }
    return m_Suspect;
}

inline
void CMSIonAnnot_Base::SetSuspect(CMSIonAnnot_Base::TSuspect value)
{
    m_Suspect = value;
    m_set_State[0] |= 0x3;
}

inline
CMSIonAnnot_Base::TSuspect& CMSIonAnnot_Base::SetSuspect(void)
{
#ifdef _DEBUG
    if (!IsSetSuspect()) {
        memset(&m_Suspect,UnassignedByte(),sizeof(m_Suspect));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Suspect;
}

inline
bool CMSIonAnnot_Base::IsSetMassdiff(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMSIonAnnot_Base::CanGetMassdiff(void) const
{
    return IsSetMassdiff();
}

inline
void CMSIonAnnot_Base::ResetMassdiff(void)
{
    m_Massdiff = 0;
    m_set_State[0] &= ~0xc;
}

inline
CMSIonAnnot_Base::TMassdiff CMSIonAnnot_Base::GetMassdiff(void) const
{
    if (!CanGetMassdiff()) {
        ThrowUnassigned(1);
    }
    return m_Massdiff;
}

inline
void CMSIonAnnot_Base::SetMassdiff(CMSIonAnnot_Base::TMassdiff value)
{
    m_Massdiff = value;
    m_set_State[0] |= 0xc;
}

inline
CMSIonAnnot_Base::TMassdiff& CMSIonAnnot_Base::SetMassdiff(void)
{
#ifdef _DEBUG
    if (!IsSetMassdiff()) {
        memset(&m_Massdiff,UnassignedByte(),sizeof(m_Massdiff));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Massdiff;
}

inline
bool CMSIonAnnot_Base::IsSetMissingisotope(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMSIonAnnot_Base::CanGetMissingisotope(void) const
{
    return IsSetMissingisotope();
}

inline
void CMSIonAnnot_Base::ResetMissingisotope(void)
{
    m_Missingisotope = 0;
    m_set_State[0] &= ~0x30;
}

inline
CMSIonAnnot_Base::TMissingisotope CMSIonAnnot_Base::GetMissingisotope(void) const
{
    if (!CanGetMissingisotope()) {
        ThrowUnassigned(2);
    }
    return m_Missingisotope;
}

inline
void CMSIonAnnot_Base::SetMissingisotope(CMSIonAnnot_Base::TMissingisotope value)
{
    m_Missingisotope = value;
    m_set_State[0] |= 0x30;
}

inline
CMSIonAnnot_Base::TMissingisotope& CMSIonAnnot_Base::SetMissingisotope(void)
{
#ifdef _DEBUG
    if (!IsSetMissingisotope()) {
        memset(&m_Missingisotope,UnassignedByte(),sizeof(m_Missingisotope));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Missingisotope;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSIONANNOT_BASE_HPP
