/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Residue_interval_pntr_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_RESIDUE_INTERVAL_PNTR_BASE_HPP
#define OBJECTS_MMDB3_RESIDUE_INTERVAL_PNTR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/mmdb1/Molecule_id.hpp>
#include <objects/mmdb1/Residue_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MMDB3_EXPORT CResidue_interval_pntr_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CResidue_interval_pntr_Base(void);
    // destructor
    virtual ~CResidue_interval_pntr_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CMolecule_id TMolecule_id;
    typedef CResidue_id TFrom;
    typedef CResidue_id TTo;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_molecule_id,
        e_from,
        e_to
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CMolecule_id TMolecule_id
    ///  Check whether the Molecule_id data member has been assigned a value.
    bool IsSetMolecule_id(void) const;
    /// Check whether it is safe or not to call GetMolecule_id method.
    bool CanGetMolecule_id(void) const;
    void ResetMolecule_id(void);
    const TMolecule_id& GetMolecule_id(void) const;
    void SetMolecule_id(const TMolecule_id& value);
    TMolecule_id& SetMolecule_id(void);

    /// mandatory
    /// typedef CResidue_id TFrom
    ///  Check whether the From data member has been assigned a value.
    bool IsSetFrom(void) const;
    /// Check whether it is safe or not to call GetFrom method.
    bool CanGetFrom(void) const;
    void ResetFrom(void);
    const TFrom& GetFrom(void) const;
    void SetFrom(const TFrom& value);
    TFrom& SetFrom(void);

    /// mandatory
    /// typedef CResidue_id TTo
    ///  Check whether the To data member has been assigned a value.
    bool IsSetTo(void) const;
    /// Check whether it is safe or not to call GetTo method.
    bool CanGetTo(void) const;
    void ResetTo(void);
    const TTo& GetTo(void) const;
    void SetTo(const TTo& value);
    TTo& SetTo(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CResidue_interval_pntr_Base(const CResidue_interval_pntr_Base&);
    CResidue_interval_pntr_Base& operator=(const CResidue_interval_pntr_Base&);

    // data
    Uint4 m_set_State[1];
    CMolecule_id m_Molecule_id;
    CResidue_id m_From;
    CResidue_id m_To;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CResidue_interval_pntr_Base::IsSetMolecule_id(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CResidue_interval_pntr_Base::CanGetMolecule_id(void) const
{
    return IsSetMolecule_id();
}

inline
void CResidue_interval_pntr_Base::ResetMolecule_id(void)
{
    m_Molecule_id = CMolecule_id(0);
    m_set_State[0] &= ~0x3;
}

inline
const CResidue_interval_pntr_Base::TMolecule_id& CResidue_interval_pntr_Base::GetMolecule_id(void) const
{
    if (!CanGetMolecule_id()) {
        ThrowUnassigned(0);
    }
    return m_Molecule_id;
}

inline
void CResidue_interval_pntr_Base::SetMolecule_id(const CResidue_interval_pntr_Base::TMolecule_id& value)
{
    m_Molecule_id = value;
    m_set_State[0] |= 0x3;
}

inline
CResidue_interval_pntr_Base::TMolecule_id& CResidue_interval_pntr_Base::SetMolecule_id(void)
{
    m_set_State[0] |= 0x1;
    return m_Molecule_id;
}

inline
bool CResidue_interval_pntr_Base::IsSetFrom(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CResidue_interval_pntr_Base::CanGetFrom(void) const
{
    return IsSetFrom();
}

inline
void CResidue_interval_pntr_Base::ResetFrom(void)
{
    m_From = CResidue_id(0);
    m_set_State[0] &= ~0xc;
}

inline
const CResidue_interval_pntr_Base::TFrom& CResidue_interval_pntr_Base::GetFrom(void) const
{
    if (!CanGetFrom()) {
        ThrowUnassigned(1);
    }
    return m_From;
}

inline
void CResidue_interval_pntr_Base::SetFrom(const CResidue_interval_pntr_Base::TFrom& value)
{
    m_From = value;
    m_set_State[0] |= 0xc;
}

inline
CResidue_interval_pntr_Base::TFrom& CResidue_interval_pntr_Base::SetFrom(void)
{
    m_set_State[0] |= 0x4;
    return m_From;
}

inline
bool CResidue_interval_pntr_Base::IsSetTo(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CResidue_interval_pntr_Base::CanGetTo(void) const
{
    return IsSetTo();
}

inline
void CResidue_interval_pntr_Base::ResetTo(void)
{
    m_To = CResidue_id(0);
    m_set_State[0] &= ~0x30;
}

inline
const CResidue_interval_pntr_Base::TTo& CResidue_interval_pntr_Base::GetTo(void) const
{
    if (!CanGetTo()) {
        ThrowUnassigned(2);
    }
    return m_To;
}

inline
void CResidue_interval_pntr_Base::SetTo(const CResidue_interval_pntr_Base::TTo& value)
{
    m_To = value;
    m_set_State[0] |= 0x30;
}

inline
CResidue_interval_pntr_Base::TTo& CResidue_interval_pntr_Base::SetTo(void)
{
    m_set_State[0] |= 0x10;
    return m_To;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_RESIDUE_INTERVAL_PNTR_BASE_HPP
