/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Region_coordinates_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_REGION_COORDINATES_BASE_HPP
#define OBJECTS_MMDB3_REGION_COORDINATES_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/mmdb2/Model_coordinate_set_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Coordinate sites describe a region in space by reference to individual 
/// coordinates, in a particular model.  These coordinates may be either the
/// x, y and z values of atomic coordinates, the triangles of a surface mesh, 
/// or the grid points of a density model. All are addressed in the same manner,
/// as coordinate indices which give offsets from the beginning of the 
/// coordinate data arrays.  A coordinate-index of 5, for example, refers to 
/// the 5th x, y and z values of an atomic coordinate set, the 5th v1, v2, and v3
/// values of a triangle mesh, or the 5th value in a density grid.
/// PDB SITE and FTNOTE records refer to particular atomic coordinates, and they
/// are represented as a region motif with addresses of type Region-coordinates.
/// Any names or descriptions provided by PDB are thus associated with the
/// indicated sites, in the indicated model. 
class NCBI_MMDB3_EXPORT CRegion_coordinates_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CRegion_coordinates_Base(void);
    // destructor
    virtual ~CRegion_coordinates_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CModel_coordinate_set_id TModel_coord_set_id;
    typedef int TNumber_of_coords;
    typedef list< int > TCoordinate_indices;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_model_coord_set_id,
        e_number_of_coords,
        e_coordinate_indices
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CModel_coordinate_set_id TModel_coord_set_id
    ///  Check whether the Model_coord_set_id data member has been assigned a value.
    bool IsSetModel_coord_set_id(void) const;
    /// Check whether it is safe or not to call GetModel_coord_set_id method.
    bool CanGetModel_coord_set_id(void) const;
    void ResetModel_coord_set_id(void);
    const TModel_coord_set_id& GetModel_coord_set_id(void) const;
    void SetModel_coord_set_id(const TModel_coord_set_id& value);
    TModel_coord_set_id& SetModel_coord_set_id(void);

    /// optional
    /// typedef int TNumber_of_coords
    ///  Check whether the Number_of_coords data member has been assigned a value.
    bool IsSetNumber_of_coords(void) const;
    /// Check whether it is safe or not to call GetNumber_of_coords method.
    bool CanGetNumber_of_coords(void) const;
    void ResetNumber_of_coords(void);
    TNumber_of_coords GetNumber_of_coords(void) const;
    void SetNumber_of_coords(TNumber_of_coords value);
    TNumber_of_coords& SetNumber_of_coords(void);

    /// optional
    /// typedef list< int > TCoordinate_indices
    ///  Check whether the Coordinate_indices data member has been assigned a value.
    bool IsSetCoordinate_indices(void) const;
    /// Check whether it is safe or not to call GetCoordinate_indices method.
    bool CanGetCoordinate_indices(void) const;
    void ResetCoordinate_indices(void);
    const TCoordinate_indices& GetCoordinate_indices(void) const;
    TCoordinate_indices& SetCoordinate_indices(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CRegion_coordinates_Base(const CRegion_coordinates_Base&);
    CRegion_coordinates_Base& operator=(const CRegion_coordinates_Base&);

    // data
    Uint4 m_set_State[1];
    CModel_coordinate_set_id m_Model_coord_set_id;
    int m_Number_of_coords;
    list< int > m_Coordinate_indices;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CRegion_coordinates_Base::IsSetModel_coord_set_id(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRegion_coordinates_Base::CanGetModel_coord_set_id(void) const
{
    return IsSetModel_coord_set_id();
}

inline
void CRegion_coordinates_Base::ResetModel_coord_set_id(void)
{
    m_Model_coord_set_id = CModel_coordinate_set_id(0);
    m_set_State[0] &= ~0x3;
}

inline
const CRegion_coordinates_Base::TModel_coord_set_id& CRegion_coordinates_Base::GetModel_coord_set_id(void) const
{
    if (!CanGetModel_coord_set_id()) {
        ThrowUnassigned(0);
    }
    return m_Model_coord_set_id;
}

inline
void CRegion_coordinates_Base::SetModel_coord_set_id(const CRegion_coordinates_Base::TModel_coord_set_id& value)
{
    m_Model_coord_set_id = value;
    m_set_State[0] |= 0x3;
}

inline
CRegion_coordinates_Base::TModel_coord_set_id& CRegion_coordinates_Base::SetModel_coord_set_id(void)
{
    m_set_State[0] |= 0x1;
    return m_Model_coord_set_id;
}

inline
bool CRegion_coordinates_Base::IsSetNumber_of_coords(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRegion_coordinates_Base::CanGetNumber_of_coords(void) const
{
    return IsSetNumber_of_coords();
}

inline
void CRegion_coordinates_Base::ResetNumber_of_coords(void)
{
    m_Number_of_coords = 0;
    m_set_State[0] &= ~0xc;
}

inline
CRegion_coordinates_Base::TNumber_of_coords CRegion_coordinates_Base::GetNumber_of_coords(void) const
{
    if (!CanGetNumber_of_coords()) {
        ThrowUnassigned(1);
    }
    return m_Number_of_coords;
}

inline
void CRegion_coordinates_Base::SetNumber_of_coords(CRegion_coordinates_Base::TNumber_of_coords value)
{
    m_Number_of_coords = value;
    m_set_State[0] |= 0xc;
}

inline
CRegion_coordinates_Base::TNumber_of_coords& CRegion_coordinates_Base::SetNumber_of_coords(void)
{
#ifdef _DEBUG
    if (!IsSetNumber_of_coords()) {
        memset(&m_Number_of_coords,UnassignedByte(),sizeof(m_Number_of_coords));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Number_of_coords;
}

inline
bool CRegion_coordinates_Base::IsSetCoordinate_indices(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CRegion_coordinates_Base::CanGetCoordinate_indices(void) const
{
    return true;
}

inline
const CRegion_coordinates_Base::TCoordinate_indices& CRegion_coordinates_Base::GetCoordinate_indices(void) const
{
    return m_Coordinate_indices;
}

inline
CRegion_coordinates_Base::TCoordinate_indices& CRegion_coordinates_Base::SetCoordinate_indices(void)
{
    m_set_State[0] |= 0x10;
    return m_Coordinate_indices;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_REGION_COORDINATES_BASE_HPP
