/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Align_stats_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_ALIGN_STATS_BASE_HPP
#define OBJECTS_MMDB3_ALIGN_STATS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MMDB3_EXPORT CAlign_stats_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAlign_stats_Base(void);
    // destructor
    virtual ~CAlign_stats_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TDescr;
    typedef int TScale_factor;
    typedef int TVast_score;
    typedef int TVast_mlogp;
    typedef int TAlign_res;
    typedef int TRmsd;
    typedef int TBlast_score;
    typedef int TBlast_mlogp;
    typedef int TOther_score;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_descr,
        e_scale_factor,
        e_vast_score,
        e_vast_mlogp,
        e_align_res,
        e_rmsd,
        e_blast_score,
        e_blast_mlogp,
        e_other_score
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef string TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    void SetDescr(const TDescr& value);
    void SetDescr(TDescr&& value);
    TDescr& SetDescr(void);

    /// optional
    /// typedef int TScale_factor
    ///  Check whether the Scale_factor data member has been assigned a value.
    bool IsSetScale_factor(void) const;
    /// Check whether it is safe or not to call GetScale_factor method.
    bool CanGetScale_factor(void) const;
    void ResetScale_factor(void);
    TScale_factor GetScale_factor(void) const;
    void SetScale_factor(TScale_factor value);
    TScale_factor& SetScale_factor(void);

    /// optional
    /// typedef int TVast_score
    ///  Check whether the Vast_score data member has been assigned a value.
    bool IsSetVast_score(void) const;
    /// Check whether it is safe or not to call GetVast_score method.
    bool CanGetVast_score(void) const;
    void ResetVast_score(void);
    TVast_score GetVast_score(void) const;
    void SetVast_score(TVast_score value);
    TVast_score& SetVast_score(void);

    /// optional
    /// typedef int TVast_mlogp
    ///  Check whether the Vast_mlogp data member has been assigned a value.
    bool IsSetVast_mlogp(void) const;
    /// Check whether it is safe or not to call GetVast_mlogp method.
    bool CanGetVast_mlogp(void) const;
    void ResetVast_mlogp(void);
    TVast_mlogp GetVast_mlogp(void) const;
    void SetVast_mlogp(TVast_mlogp value);
    TVast_mlogp& SetVast_mlogp(void);

    /// optional
    /// typedef int TAlign_res
    ///  Check whether the Align_res data member has been assigned a value.
    bool IsSetAlign_res(void) const;
    /// Check whether it is safe or not to call GetAlign_res method.
    bool CanGetAlign_res(void) const;
    void ResetAlign_res(void);
    TAlign_res GetAlign_res(void) const;
    void SetAlign_res(TAlign_res value);
    TAlign_res& SetAlign_res(void);

    /// optional
    /// typedef int TRmsd
    ///  Check whether the Rmsd data member has been assigned a value.
    bool IsSetRmsd(void) const;
    /// Check whether it is safe or not to call GetRmsd method.
    bool CanGetRmsd(void) const;
    void ResetRmsd(void);
    TRmsd GetRmsd(void) const;
    void SetRmsd(TRmsd value);
    TRmsd& SetRmsd(void);

    /// optional
    /// typedef int TBlast_score
    ///  Check whether the Blast_score data member has been assigned a value.
    bool IsSetBlast_score(void) const;
    /// Check whether it is safe or not to call GetBlast_score method.
    bool CanGetBlast_score(void) const;
    void ResetBlast_score(void);
    TBlast_score GetBlast_score(void) const;
    void SetBlast_score(TBlast_score value);
    TBlast_score& SetBlast_score(void);

    /// optional
    /// typedef int TBlast_mlogp
    ///  Check whether the Blast_mlogp data member has been assigned a value.
    bool IsSetBlast_mlogp(void) const;
    /// Check whether it is safe or not to call GetBlast_mlogp method.
    bool CanGetBlast_mlogp(void) const;
    void ResetBlast_mlogp(void);
    TBlast_mlogp GetBlast_mlogp(void) const;
    void SetBlast_mlogp(TBlast_mlogp value);
    TBlast_mlogp& SetBlast_mlogp(void);

    /// optional
    /// typedef int TOther_score
    ///  Check whether the Other_score data member has been assigned a value.
    bool IsSetOther_score(void) const;
    /// Check whether it is safe or not to call GetOther_score method.
    bool CanGetOther_score(void) const;
    void ResetOther_score(void);
    TOther_score GetOther_score(void) const;
    void SetOther_score(TOther_score value);
    TOther_score& SetOther_score(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAlign_stats_Base(const CAlign_stats_Base&);
    CAlign_stats_Base& operator=(const CAlign_stats_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Descr;
    int m_Scale_factor;
    int m_Vast_score;
    int m_Vast_mlogp;
    int m_Align_res;
    int m_Rmsd;
    int m_Blast_score;
    int m_Blast_mlogp;
    int m_Other_score;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAlign_stats_Base::IsSetDescr(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAlign_stats_Base::CanGetDescr(void) const
{
    return IsSetDescr();
}

inline
const CAlign_stats_Base::TDescr& CAlign_stats_Base::GetDescr(void) const
{
    if (!CanGetDescr()) {
        ThrowUnassigned(0);
    }
    return m_Descr;
}

inline
void CAlign_stats_Base::SetDescr(const CAlign_stats_Base::TDescr& value)
{
    m_Descr = value;
    m_set_State[0] |= 0x3;
}

inline
void CAlign_stats_Base::SetDescr(CAlign_stats_Base::TDescr&& value)
{
    m_Descr = std::forward<CAlign_stats_Base::TDescr>(value);
    m_set_State[0] |= 0x3;
}

inline
CAlign_stats_Base::TDescr& CAlign_stats_Base::SetDescr(void)
{
#ifdef _DEBUG
    if (!IsSetDescr()) {
        m_Descr = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Descr;
}

inline
bool CAlign_stats_Base::IsSetScale_factor(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAlign_stats_Base::CanGetScale_factor(void) const
{
    return IsSetScale_factor();
}

inline
void CAlign_stats_Base::ResetScale_factor(void)
{
    m_Scale_factor = 0;
    m_set_State[0] &= ~0xc;
}

inline
CAlign_stats_Base::TScale_factor CAlign_stats_Base::GetScale_factor(void) const
{
    if (!CanGetScale_factor()) {
        ThrowUnassigned(1);
    }
    return m_Scale_factor;
}

inline
void CAlign_stats_Base::SetScale_factor(CAlign_stats_Base::TScale_factor value)
{
    m_Scale_factor = value;
    m_set_State[0] |= 0xc;
}

inline
CAlign_stats_Base::TScale_factor& CAlign_stats_Base::SetScale_factor(void)
{
#ifdef _DEBUG
    if (!IsSetScale_factor()) {
        memset(&m_Scale_factor,UnassignedByte(),sizeof(m_Scale_factor));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Scale_factor;
}

inline
bool CAlign_stats_Base::IsSetVast_score(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CAlign_stats_Base::CanGetVast_score(void) const
{
    return IsSetVast_score();
}

inline
void CAlign_stats_Base::ResetVast_score(void)
{
    m_Vast_score = 0;
    m_set_State[0] &= ~0x30;
}

inline
CAlign_stats_Base::TVast_score CAlign_stats_Base::GetVast_score(void) const
{
    if (!CanGetVast_score()) {
        ThrowUnassigned(2);
    }
    return m_Vast_score;
}

inline
void CAlign_stats_Base::SetVast_score(CAlign_stats_Base::TVast_score value)
{
    m_Vast_score = value;
    m_set_State[0] |= 0x30;
}

inline
CAlign_stats_Base::TVast_score& CAlign_stats_Base::SetVast_score(void)
{
#ifdef _DEBUG
    if (!IsSetVast_score()) {
        memset(&m_Vast_score,UnassignedByte(),sizeof(m_Vast_score));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Vast_score;
}

inline
bool CAlign_stats_Base::IsSetVast_mlogp(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CAlign_stats_Base::CanGetVast_mlogp(void) const
{
    return IsSetVast_mlogp();
}

inline
void CAlign_stats_Base::ResetVast_mlogp(void)
{
    m_Vast_mlogp = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CAlign_stats_Base::TVast_mlogp CAlign_stats_Base::GetVast_mlogp(void) const
{
    if (!CanGetVast_mlogp()) {
        ThrowUnassigned(3);
    }
    return m_Vast_mlogp;
}

inline
void CAlign_stats_Base::SetVast_mlogp(CAlign_stats_Base::TVast_mlogp value)
{
    m_Vast_mlogp = value;
    m_set_State[0] |= 0xc0;
}

inline
CAlign_stats_Base::TVast_mlogp& CAlign_stats_Base::SetVast_mlogp(void)
{
#ifdef _DEBUG
    if (!IsSetVast_mlogp()) {
        memset(&m_Vast_mlogp,UnassignedByte(),sizeof(m_Vast_mlogp));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Vast_mlogp;
}

inline
bool CAlign_stats_Base::IsSetAlign_res(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CAlign_stats_Base::CanGetAlign_res(void) const
{
    return IsSetAlign_res();
}

inline
void CAlign_stats_Base::ResetAlign_res(void)
{
    m_Align_res = 0;
    m_set_State[0] &= ~0x300;
}

inline
CAlign_stats_Base::TAlign_res CAlign_stats_Base::GetAlign_res(void) const
{
    if (!CanGetAlign_res()) {
        ThrowUnassigned(4);
    }
    return m_Align_res;
}

inline
void CAlign_stats_Base::SetAlign_res(CAlign_stats_Base::TAlign_res value)
{
    m_Align_res = value;
    m_set_State[0] |= 0x300;
}

inline
CAlign_stats_Base::TAlign_res& CAlign_stats_Base::SetAlign_res(void)
{
#ifdef _DEBUG
    if (!IsSetAlign_res()) {
        memset(&m_Align_res,UnassignedByte(),sizeof(m_Align_res));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Align_res;
}

inline
bool CAlign_stats_Base::IsSetRmsd(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CAlign_stats_Base::CanGetRmsd(void) const
{
    return IsSetRmsd();
}

inline
void CAlign_stats_Base::ResetRmsd(void)
{
    m_Rmsd = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CAlign_stats_Base::TRmsd CAlign_stats_Base::GetRmsd(void) const
{
    if (!CanGetRmsd()) {
        ThrowUnassigned(5);
    }
    return m_Rmsd;
}

inline
void CAlign_stats_Base::SetRmsd(CAlign_stats_Base::TRmsd value)
{
    m_Rmsd = value;
    m_set_State[0] |= 0xc00;
}

inline
CAlign_stats_Base::TRmsd& CAlign_stats_Base::SetRmsd(void)
{
#ifdef _DEBUG
    if (!IsSetRmsd()) {
        memset(&m_Rmsd,UnassignedByte(),sizeof(m_Rmsd));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Rmsd;
}

inline
bool CAlign_stats_Base::IsSetBlast_score(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CAlign_stats_Base::CanGetBlast_score(void) const
{
    return IsSetBlast_score();
}

inline
void CAlign_stats_Base::ResetBlast_score(void)
{
    m_Blast_score = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CAlign_stats_Base::TBlast_score CAlign_stats_Base::GetBlast_score(void) const
{
    if (!CanGetBlast_score()) {
        ThrowUnassigned(6);
    }
    return m_Blast_score;
}

inline
void CAlign_stats_Base::SetBlast_score(CAlign_stats_Base::TBlast_score value)
{
    m_Blast_score = value;
    m_set_State[0] |= 0x3000;
}

inline
CAlign_stats_Base::TBlast_score& CAlign_stats_Base::SetBlast_score(void)
{
#ifdef _DEBUG
    if (!IsSetBlast_score()) {
        memset(&m_Blast_score,UnassignedByte(),sizeof(m_Blast_score));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Blast_score;
}

inline
bool CAlign_stats_Base::IsSetBlast_mlogp(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CAlign_stats_Base::CanGetBlast_mlogp(void) const
{
    return IsSetBlast_mlogp();
}

inline
void CAlign_stats_Base::ResetBlast_mlogp(void)
{
    m_Blast_mlogp = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CAlign_stats_Base::TBlast_mlogp CAlign_stats_Base::GetBlast_mlogp(void) const
{
    if (!CanGetBlast_mlogp()) {
        ThrowUnassigned(7);
    }
    return m_Blast_mlogp;
}

inline
void CAlign_stats_Base::SetBlast_mlogp(CAlign_stats_Base::TBlast_mlogp value)
{
    m_Blast_mlogp = value;
    m_set_State[0] |= 0xc000;
}

inline
CAlign_stats_Base::TBlast_mlogp& CAlign_stats_Base::SetBlast_mlogp(void)
{
#ifdef _DEBUG
    if (!IsSetBlast_mlogp()) {
        memset(&m_Blast_mlogp,UnassignedByte(),sizeof(m_Blast_mlogp));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Blast_mlogp;
}

inline
bool CAlign_stats_Base::IsSetOther_score(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CAlign_stats_Base::CanGetOther_score(void) const
{
    return IsSetOther_score();
}

inline
void CAlign_stats_Base::ResetOther_score(void)
{
    m_Other_score = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CAlign_stats_Base::TOther_score CAlign_stats_Base::GetOther_score(void) const
{
    if (!CanGetOther_score()) {
        ThrowUnassigned(8);
    }
    return m_Other_score;
}

inline
void CAlign_stats_Base::SetOther_score(CAlign_stats_Base::TOther_score value)
{
    m_Other_score = value;
    m_set_State[0] |= 0x30000;
}

inline
CAlign_stats_Base::TOther_score& CAlign_stats_Base::SetOther_score(void)
{
#ifdef _DEBUG
    if (!IsSetOther_score()) {
        memset(&m_Other_score,UnassignedByte(),sizeof(m_Other_score));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Other_score;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_ALIGN_STATS_BASE_HPP
