/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file T_mesh_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB2_T_MESH_BASE_HPP
#define OBJECTS_MMDB2_T_MESH_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MMDB2_EXPORT CT_mesh_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CT_mesh_Base(void);
    // destructor
    virtual ~CT_mesh_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TNumber_of_points;
    typedef int TScale_factor;
    typedef list< bool > TSwap;
    typedef list< int > TX;
    typedef list< int > TY;
    typedef list< int > TZ;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_number_of_points,
        e_scale_factor,
        e_swap,
        e_x,
        e_y,
        e_z
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TNumber_of_points
    ///  Check whether the Number_of_points data member has been assigned a value.
    bool IsSetNumber_of_points(void) const;
    /// Check whether it is safe or not to call GetNumber_of_points method.
    bool CanGetNumber_of_points(void) const;
    void ResetNumber_of_points(void);
    TNumber_of_points GetNumber_of_points(void) const;
    void SetNumber_of_points(TNumber_of_points value);
    TNumber_of_points& SetNumber_of_points(void);

    /// mandatory
    /// typedef int TScale_factor
    ///  Check whether the Scale_factor data member has been assigned a value.
    bool IsSetScale_factor(void) const;
    /// Check whether it is safe or not to call GetScale_factor method.
    bool CanGetScale_factor(void) const;
    void ResetScale_factor(void);
    TScale_factor GetScale_factor(void) const;
    void SetScale_factor(TScale_factor value);
    TScale_factor& SetScale_factor(void);

    /// mandatory
    /// typedef list< bool > TSwap
    ///  Check whether the Swap data member has been assigned a value.
    bool IsSetSwap(void) const;
    /// Check whether it is safe or not to call GetSwap method.
    bool CanGetSwap(void) const;
    void ResetSwap(void);
    const TSwap& GetSwap(void) const;
    TSwap& SetSwap(void);

    /// mandatory
    /// typedef list< int > TX
    ///  Check whether the X data member has been assigned a value.
    bool IsSetX(void) const;
    /// Check whether it is safe or not to call GetX method.
    bool CanGetX(void) const;
    void ResetX(void);
    const TX& GetX(void) const;
    TX& SetX(void);

    /// mandatory
    /// typedef list< int > TY
    ///  Check whether the Y data member has been assigned a value.
    bool IsSetY(void) const;
    /// Check whether it is safe or not to call GetY method.
    bool CanGetY(void) const;
    void ResetY(void);
    const TY& GetY(void) const;
    TY& SetY(void);

    /// mandatory
    /// typedef list< int > TZ
    ///  Check whether the Z data member has been assigned a value.
    bool IsSetZ(void) const;
    /// Check whether it is safe or not to call GetZ method.
    bool CanGetZ(void) const;
    void ResetZ(void);
    const TZ& GetZ(void) const;
    TZ& SetZ(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CT_mesh_Base(const CT_mesh_Base&);
    CT_mesh_Base& operator=(const CT_mesh_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Number_of_points;
    int m_Scale_factor;
    list< bool > m_Swap;
    list< int > m_X;
    list< int > m_Y;
    list< int > m_Z;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CT_mesh_Base::IsSetNumber_of_points(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CT_mesh_Base::CanGetNumber_of_points(void) const
{
    return IsSetNumber_of_points();
}

inline
void CT_mesh_Base::ResetNumber_of_points(void)
{
    m_Number_of_points = 0;
    m_set_State[0] &= ~0x3;
}

inline
CT_mesh_Base::TNumber_of_points CT_mesh_Base::GetNumber_of_points(void) const
{
    if (!CanGetNumber_of_points()) {
        ThrowUnassigned(0);
    }
    return m_Number_of_points;
}

inline
void CT_mesh_Base::SetNumber_of_points(CT_mesh_Base::TNumber_of_points value)
{
    m_Number_of_points = value;
    m_set_State[0] |= 0x3;
}

inline
CT_mesh_Base::TNumber_of_points& CT_mesh_Base::SetNumber_of_points(void)
{
#ifdef _DEBUG
    if (!IsSetNumber_of_points()) {
        memset(&m_Number_of_points,UnassignedByte(),sizeof(m_Number_of_points));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Number_of_points;
}

inline
bool CT_mesh_Base::IsSetScale_factor(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CT_mesh_Base::CanGetScale_factor(void) const
{
    return IsSetScale_factor();
}

inline
void CT_mesh_Base::ResetScale_factor(void)
{
    m_Scale_factor = 0;
    m_set_State[0] &= ~0xc;
}

inline
CT_mesh_Base::TScale_factor CT_mesh_Base::GetScale_factor(void) const
{
    if (!CanGetScale_factor()) {
        ThrowUnassigned(1);
    }
    return m_Scale_factor;
}

inline
void CT_mesh_Base::SetScale_factor(CT_mesh_Base::TScale_factor value)
{
    m_Scale_factor = value;
    m_set_State[0] |= 0xc;
}

inline
CT_mesh_Base::TScale_factor& CT_mesh_Base::SetScale_factor(void)
{
#ifdef _DEBUG
    if (!IsSetScale_factor()) {
        memset(&m_Scale_factor,UnassignedByte(),sizeof(m_Scale_factor));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Scale_factor;
}

inline
bool CT_mesh_Base::IsSetSwap(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CT_mesh_Base::CanGetSwap(void) const
{
    return true;
}

inline
const CT_mesh_Base::TSwap& CT_mesh_Base::GetSwap(void) const
{
    return m_Swap;
}

inline
CT_mesh_Base::TSwap& CT_mesh_Base::SetSwap(void)
{
    m_set_State[0] |= 0x10;
    return m_Swap;
}

inline
bool CT_mesh_Base::IsSetX(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CT_mesh_Base::CanGetX(void) const
{
    return true;
}

inline
const CT_mesh_Base::TX& CT_mesh_Base::GetX(void) const
{
    return m_X;
}

inline
CT_mesh_Base::TX& CT_mesh_Base::SetX(void)
{
    m_set_State[0] |= 0x40;
    return m_X;
}

inline
bool CT_mesh_Base::IsSetY(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CT_mesh_Base::CanGetY(void) const
{
    return true;
}

inline
const CT_mesh_Base::TY& CT_mesh_Base::GetY(void) const
{
    return m_Y;
}

inline
CT_mesh_Base::TY& CT_mesh_Base::SetY(void)
{
    m_set_State[0] |= 0x100;
    return m_Y;
}

inline
bool CT_mesh_Base::IsSetZ(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CT_mesh_Base::CanGetZ(void) const
{
    return true;
}

inline
const CT_mesh_Base::TZ& CT_mesh_Base::GetZ(void) const
{
    return m_Z;
}

inline
CT_mesh_Base::TZ& CT_mesh_Base::SetZ(void)
{
    m_set_State[0] |= 0x400;
    return m_Z;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB2_T_MESH_BASE_HPP
