/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Molecule_graph_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB1_MOLECULE_GRAPH_BASE_HPP
#define OBJECTS_MMDB1_MOLECULE_GRAPH_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/mmdb1/Molecule_id.hpp>
#include <objects/mmdb1/PCSubstance_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBiomol_descr;
class CInter_residue_bond;
class CResidue;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// A molecule chemical graph is defined by a sequence of residues.  Nonpolymers
/// are described in the same way, but may contain only a single residue.  
/// Biopolymer molecules are identified within PDB entries according to their
/// appearance on SEQRES records, which formally define a biopolymer as such. 
/// Biopolymers are defined by the distinction between ATOM and HETATM 
/// coordinate records only in cases where the chemical sequence from SEQRES
/// is in conflict with coordinate data. The PDB-assigned chain code appears as 
/// the name within the molecule descriptions of the biopolymers.
/// Nonpolymer molecules from PDB correspond to individual HETEROGEN groups, 
/// excluding any HETEROGEN groups which represent modified biopolymer residues.
/// These molecules are named according to the chain, residue type and residue 
/// number fields as assigned by PDB. Any description appearing in the PDB HET 
/// record appears as a pdb-comment within the molecule description. 
/// Molecule types for PDB-derived molecule graphs are assigned by matching 
/// residue and atom names against the PDB-documented standard types for protein,
/// DNA and RNA, and against residue codes commonly used to indicate solvent.
/// Classification is by "majority rule". If more than half of the residues in
/// a biopolymer are standard groups of one type, then the molecule is of that 
/// type, and otherwise classified as "other". Note that this classification does
/// not preclude the presence of modified residues, but insists they constitute 
/// less than half the biopolymer. Non-polymers are classified only as "solvent"
/// or "other".  
/// Note that a molecule graph may also contain a set of cross references 
/// to biopolymer sequence databases.  All biopolymer molecules in MMDB contain 
/// appropriate identifiers for the corresponding entry in the NCBI-Sequences 
/// database, in particular the NCBI "gi" number, which may be used for sequence
/// retrieval. The Seq-id object type is defined in the NCBI molecular sequence 
/// specification, and not repeated here.
class NCBI_MMDB1_EXPORT CMolecule_graph_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMolecule_graph_Base(void);
    // destructor
    virtual ~CMolecule_graph_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CMolecule_id TId;
    typedef list< CRef< CBiomol_descr > > TDescr;
    typedef CSeq_id TSeq_id;
    typedef list< CRef< CResidue > > TResidue_sequence;
    typedef list< CRef< CInter_residue_bond > > TInter_residue_bonds;
    typedef CPCSubstance_id TSid;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_descr,
        e_seq_id,
        e_residue_sequence,
        e_inter_residue_bonds,
        e_sid
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CMolecule_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(const TId& value);
    TId& SetId(void);

    /// optional
    /// typedef list< CRef< CBiomol_descr > > TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    TDescr& SetDescr(void);

    /// optional
    /// typedef CSeq_id TSeq_id
    ///  Check whether the Seq_id data member has been assigned a value.
    bool IsSetSeq_id(void) const;
    /// Check whether it is safe or not to call GetSeq_id method.
    bool CanGetSeq_id(void) const;
    void ResetSeq_id(void);
    const TSeq_id& GetSeq_id(void) const;
    void SetSeq_id(TSeq_id& value);
    TSeq_id& SetSeq_id(void);

    /// mandatory
    /// typedef list< CRef< CResidue > > TResidue_sequence
    ///  Check whether the Residue_sequence data member has been assigned a value.
    bool IsSetResidue_sequence(void) const;
    /// Check whether it is safe or not to call GetResidue_sequence method.
    bool CanGetResidue_sequence(void) const;
    void ResetResidue_sequence(void);
    const TResidue_sequence& GetResidue_sequence(void) const;
    TResidue_sequence& SetResidue_sequence(void);

    /// optional
    /// typedef list< CRef< CInter_residue_bond > > TInter_residue_bonds
    ///  Check whether the Inter_residue_bonds data member has been assigned a value.
    bool IsSetInter_residue_bonds(void) const;
    /// Check whether it is safe or not to call GetInter_residue_bonds method.
    bool CanGetInter_residue_bonds(void) const;
    void ResetInter_residue_bonds(void);
    const TInter_residue_bonds& GetInter_residue_bonds(void) const;
    TInter_residue_bonds& SetInter_residue_bonds(void);

    /// optional
    /// typedef CPCSubstance_id TSid
    ///  Check whether the Sid data member has been assigned a value.
    bool IsSetSid(void) const;
    /// Check whether it is safe or not to call GetSid method.
    bool CanGetSid(void) const;
    void ResetSid(void);
    const TSid& GetSid(void) const;
    void SetSid(const TSid& value);
    TSid& SetSid(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMolecule_graph_Base(const CMolecule_graph_Base&);
    CMolecule_graph_Base& operator=(const CMolecule_graph_Base&);

    // data
    Uint4 m_set_State[1];
    CMolecule_id m_Id;
    list< CRef< CBiomol_descr > > m_Descr;
    CRef< TSeq_id > m_Seq_id;
    list< CRef< CResidue > > m_Residue_sequence;
    list< CRef< CInter_residue_bond > > m_Inter_residue_bonds;
    CPCSubstance_id m_Sid;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMolecule_graph_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMolecule_graph_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
void CMolecule_graph_Base::ResetId(void)
{
    m_Id = CMolecule_id(0);
    m_set_State[0] &= ~0x3;
}

inline
const CMolecule_graph_Base::TId& CMolecule_graph_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMolecule_graph_Base::SetId(const CMolecule_graph_Base::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
CMolecule_graph_Base::TId& CMolecule_graph_Base::SetId(void)
{
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMolecule_graph_Base::IsSetDescr(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMolecule_graph_Base::CanGetDescr(void) const
{
    return true;
}

inline
const CMolecule_graph_Base::TDescr& CMolecule_graph_Base::GetDescr(void) const
{
    return m_Descr;
}

inline
CMolecule_graph_Base::TDescr& CMolecule_graph_Base::SetDescr(void)
{
    m_set_State[0] |= 0x4;
    return m_Descr;
}

inline
bool CMolecule_graph_Base::IsSetSeq_id(void) const
{
    return m_Seq_id.NotEmpty();
}

inline
bool CMolecule_graph_Base::CanGetSeq_id(void) const
{
    return IsSetSeq_id();
}

inline
const CMolecule_graph_Base::TSeq_id& CMolecule_graph_Base::GetSeq_id(void) const
{
    if (!CanGetSeq_id()) {
        ThrowUnassigned(2);
    }
    return (*m_Seq_id);
}

inline
bool CMolecule_graph_Base::IsSetResidue_sequence(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMolecule_graph_Base::CanGetResidue_sequence(void) const
{
    return true;
}

inline
const CMolecule_graph_Base::TResidue_sequence& CMolecule_graph_Base::GetResidue_sequence(void) const
{
    return m_Residue_sequence;
}

inline
CMolecule_graph_Base::TResidue_sequence& CMolecule_graph_Base::SetResidue_sequence(void)
{
    m_set_State[0] |= 0x40;
    return m_Residue_sequence;
}

inline
bool CMolecule_graph_Base::IsSetInter_residue_bonds(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMolecule_graph_Base::CanGetInter_residue_bonds(void) const
{
    return true;
}

inline
const CMolecule_graph_Base::TInter_residue_bonds& CMolecule_graph_Base::GetInter_residue_bonds(void) const
{
    return m_Inter_residue_bonds;
}

inline
CMolecule_graph_Base::TInter_residue_bonds& CMolecule_graph_Base::SetInter_residue_bonds(void)
{
    m_set_State[0] |= 0x100;
    return m_Inter_residue_bonds;
}

inline
bool CMolecule_graph_Base::IsSetSid(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMolecule_graph_Base::CanGetSid(void) const
{
    return IsSetSid();
}

inline
void CMolecule_graph_Base::ResetSid(void)
{
    m_Sid = CPCSubstance_id(0);
    m_set_State[0] &= ~0xc00;
}

inline
const CMolecule_graph_Base::TSid& CMolecule_graph_Base::GetSid(void) const
{
    if (!CanGetSid()) {
        ThrowUnassigned(5);
    }
    return m_Sid;
}

inline
void CMolecule_graph_Base::SetSid(const CMolecule_graph_Base::TSid& value)
{
    m_Sid = value;
    m_set_State[0] |= 0xc00;
}

inline
CMolecule_graph_Base::TSid& CMolecule_graph_Base::SetSid(void)
{
    m_set_State[0] |= 0x400;
    return m_Sid;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB1_MOLECULE_GRAPH_BASE_HPP
