/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Biostruc_graph_pntr_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB1_BIOSTRUC_GRAPH_PNTR_BASE_HPP
#define OBJECTS_MMDB1_BIOSTRUC_GRAPH_PNTR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/mmdb1/Residue_graph_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBiostruc_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MMDB1_EXPORT CBiostruc_graph_pntr_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBiostruc_graph_pntr_Base(void);
    // destructor
    virtual ~CBiostruc_graph_pntr_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CBiostruc_id TBiostruc_id;
    typedef CResidue_graph_id TResidue_graph_id;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_biostruc_id,
        e_residue_graph_id
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CBiostruc_id TBiostruc_id
    ///  Check whether the Biostruc_id data member has been assigned a value.
    bool IsSetBiostruc_id(void) const;
    /// Check whether it is safe or not to call GetBiostruc_id method.
    bool CanGetBiostruc_id(void) const;
    void ResetBiostruc_id(void);
    const TBiostruc_id& GetBiostruc_id(void) const;
    void SetBiostruc_id(TBiostruc_id& value);
    TBiostruc_id& SetBiostruc_id(void);

    /// mandatory
    /// typedef CResidue_graph_id TResidue_graph_id
    ///  Check whether the Residue_graph_id data member has been assigned a value.
    bool IsSetResidue_graph_id(void) const;
    /// Check whether it is safe or not to call GetResidue_graph_id method.
    bool CanGetResidue_graph_id(void) const;
    void ResetResidue_graph_id(void);
    const TResidue_graph_id& GetResidue_graph_id(void) const;
    void SetResidue_graph_id(const TResidue_graph_id& value);
    TResidue_graph_id& SetResidue_graph_id(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBiostruc_graph_pntr_Base(const CBiostruc_graph_pntr_Base&);
    CBiostruc_graph_pntr_Base& operator=(const CBiostruc_graph_pntr_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TBiostruc_id > m_Biostruc_id;
    CResidue_graph_id m_Residue_graph_id;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBiostruc_graph_pntr_Base::IsSetBiostruc_id(void) const
{
    return m_Biostruc_id.NotEmpty();
}

inline
bool CBiostruc_graph_pntr_Base::CanGetBiostruc_id(void) const
{
    return true;
}

inline
const CBiostruc_graph_pntr_Base::TBiostruc_id& CBiostruc_graph_pntr_Base::GetBiostruc_id(void) const
{
    if ( !m_Biostruc_id ) {
        const_cast<CBiostruc_graph_pntr_Base*>(this)->ResetBiostruc_id();
    }
    return (*m_Biostruc_id);
}

inline
CBiostruc_graph_pntr_Base::TBiostruc_id& CBiostruc_graph_pntr_Base::SetBiostruc_id(void)
{
    if ( !m_Biostruc_id ) {
        ResetBiostruc_id();
    }
    return (*m_Biostruc_id);
}

inline
bool CBiostruc_graph_pntr_Base::IsSetResidue_graph_id(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBiostruc_graph_pntr_Base::CanGetResidue_graph_id(void) const
{
    return IsSetResidue_graph_id();
}

inline
void CBiostruc_graph_pntr_Base::ResetResidue_graph_id(void)
{
    m_Residue_graph_id = CResidue_graph_id(0);
    m_set_State[0] &= ~0xc;
}

inline
const CBiostruc_graph_pntr_Base::TResidue_graph_id& CBiostruc_graph_pntr_Base::GetResidue_graph_id(void) const
{
    if (!CanGetResidue_graph_id()) {
        ThrowUnassigned(1);
    }
    return m_Residue_graph_id;
}

inline
void CBiostruc_graph_pntr_Base::SetResidue_graph_id(const CBiostruc_graph_pntr_Base::TResidue_graph_id& value)
{
    m_Residue_graph_id = value;
    m_set_State[0] |= 0xc;
}

inline
CBiostruc_graph_pntr_Base::TResidue_graph_id& CBiostruc_graph_pntr_Base::SetResidue_graph_id(void)
{
    m_set_State[0] |= 0x4;
    return m_Residue_graph_id;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB1_BIOSTRUC_GRAPH_PNTR_BASE_HPP
